/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;

public abstract class AccumuloTestCase
extends ImportJobTestCase {
    private static final String ACCUMULO_USER = "root";
    private static final String ACCUMULO_PASSWORD = "rootroot";
    private static String testBuildDataProperty = "";
    public static final Log LOG = LogFactory.getLog((String)AccumuloTestCase.class.getName());
    protected static MiniAccumuloCluster accumuloCluster;
    protected static File tempDir;

    private static void recordTestBuildDataProperty() {
        testBuildDataProperty = System.getProperty("test.build.data", "");
    }

    private static void restoreTestBuidlDataProperty() {
        System.setProperty("test.build.data", testBuildDataProperty);
    }

    protected String[] getArgv(String accumuloTable, String accumuloColFam, boolean accumuloCreate, String queryStr) {
        ArrayList<String> args = new ArrayList<String>();
        if (null != queryStr) {
            args.add("--query");
            args.add(queryStr);
        } else {
            args.add("--table");
            args.add(this.getTableName());
        }
        args.add("--split-by");
        args.add(this.getColName(0));
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--num-mappers");
        args.add("1");
        args.add("--accumulo-column-family");
        args.add(accumuloColFam);
        args.add("--accumulo-table");
        args.add(accumuloTable);
        if (accumuloCreate) {
            args.add("--accumulo-create-table");
        }
        args.add("--accumulo-instance");
        args.add(accumuloCluster.getInstanceName());
        args.add("--accumulo-zookeepers");
        args.add(accumuloCluster.getZooKeepers());
        args.add("--accumulo-user");
        args.add(ACCUMULO_USER);
        args.add("--accumulo-password");
        args.add(ACCUMULO_PASSWORD);
        return args.toArray(new String[0]);
    }

    protected static void setUpCluster() throws Exception {
        File temp = File.createTempFile("test", "tmp");
        tempDir = new File(temp.getParent(), "accumulo" + System.currentTimeMillis());
        tempDir.mkdir();
        tempDir.deleteOnExit();
        temp.delete();
        accumuloCluster = AccumuloTestCase.createMiniAccumuloCluster(tempDir, ACCUMULO_PASSWORD);
        accumuloCluster.start();
    }

    protected static MiniAccumuloCluster createMiniAccumuloCluster(File tempDir, String rootPassword) throws Exception {
        String configImplClassName = "org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl";
        String clusterImplClassName = "org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl";
        try {
            Class<?> configImplClz = Class.forName("org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl");
            Constructor<?> cfgConstructor = configImplClz.getConstructor(File.class, String.class);
            Object configImpl = cfgConstructor.newInstance(tempDir, rootPassword);
            Method setClasspathItemsMethod = configImplClz.getDeclaredMethod("setClasspathItems", String[].class);
            String classpath = AccumuloTestCase.getClasspath(new File(tempDir, "conf"));
            setClasspathItemsMethod.invoke(configImpl, new Object[]{new String[]{classpath}});
            Constructor clusterConstructor = MiniAccumuloCluster.class.getDeclaredConstructor(configImplClz);
            clusterConstructor.setAccessible(true);
            Object clusterImpl = clusterConstructor.newInstance(configImpl);
            return (MiniAccumuloCluster)MiniAccumuloCluster.class.cast(clusterImpl);
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not load 1.6 minicluster classes", (Throwable)e);
            return new MiniAccumuloCluster(tempDir, ACCUMULO_PASSWORD);
        }
    }

    protected static String getClasspath(File confDir) throws URISyntaxException {
        ArrayList<ClassLoader> classloaders = new ArrayList<ClassLoader>();
        for (ClassLoader cl = AccumuloTestCase.class.getClassLoader(); cl != null; cl = cl.getParent()) {
            classloaders.add(cl);
        }
        Collections.reverse(classloaders);
        StringBuilder classpathBuilder = new StringBuilder(64);
        classpathBuilder.append(confDir.getAbsolutePath());
        for (int i = 1; i < classloaders.size(); ++i) {
            ClassLoader classLoader = (ClassLoader)classloaders.get(i);
            if (classLoader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                    AccumuloTestCase.append(classpathBuilder, u);
                }
                continue;
            }
            throw new IllegalArgumentException("Unknown classloader type : " + classLoader.getClass().getName());
        }
        return classpathBuilder.toString();
    }

    private static void append(StringBuilder classpathBuilder, URL url) throws URISyntaxException {
        File file = new File(url.toURI());
        if (!AccumuloTestCase.containsSiteFile(file) && !AccumuloTestCase.isHiveExec(file)) {
            classpathBuilder.append(File.pathSeparator).append(file.getAbsolutePath());
        }
    }

    private static boolean containsSiteFile(File f) {
        return f.isDirectory() && f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("site.xml");
            }
        }).length > 0;
    }

    private static boolean isHiveExec(File f) {
        if (f.isFile()) {
            String name = f.getName();
            return name.startsWith("hive-exec") && name.endsWith(".jar");
        }
        return false;
    }

    protected static void cleanUpCluster() throws Exception {
        accumuloCluster.stop();
        AccumuloTestCase.delete(tempDir);
    }

    protected static void delete(File dir) {
        if (dir.isDirectory()) {
            File[] kids;
            for (File f : kids = dir.listFiles()) {
                if (f.isDirectory()) {
                    AccumuloTestCase.delete(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }

    @Override
    @Before
    public void setUp() {
        try {
            AccumuloTestCase.setUpCluster();
        }
        catch (Exception e) {
            LOG.error((Object)"Error setting up MiniAccumuloCluster.", (Throwable)e);
        }
        AccumuloTestCase.recordTestBuildDataProperty();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            AccumuloTestCase.cleanUpCluster();
        }
        catch (Exception e) {
            LOG.error((Object)"Error stopping MiniAccumuloCluster.", (Throwable)e);
        }
    }

    protected void verifyAccumuloCell(String tableName, String rowKey, String colFamily, String colName, String val) throws IOException {
        try {
            ZooKeeperInstance inst = new ZooKeeperInstance(accumuloCluster.getInstanceName(), accumuloCluster.getZooKeepers());
            Connector conn = inst.getConnector(ACCUMULO_USER, (AuthenticationToken)new PasswordToken((CharSequence)ACCUMULO_PASSWORD));
            Scanner scanner = conn.createScanner(tableName, Constants.NO_AUTHS);
            scanner.setRange(new Range((CharSequence)rowKey));
            for (Map.Entry entry : scanner) {
                String columnFamily = ((Key)entry.getKey()).getColumnFamily().toString();
                String qual = ((Key)entry.getKey()).getColumnQualifier().toString();
                if (!columnFamily.equals(colFamily) || !qual.equals(colName)) continue;
                String value = ((Value)entry.getValue()).toString();
                if (null == val) {
                    AccumuloTestCase.assertNull((String)"Got a result when expected null", (Object)value);
                    continue;
                }
                AccumuloTestCase.assertNotNull((String)"No result, but we expected one", (Object)value);
                AccumuloTestCase.assertEquals((String)val, (String)value);
            }
        }
        catch (AccumuloException e) {
            throw new IOException("AccumuloException in verifyAccumuloCell", e);
        }
        catch (AccumuloSecurityException e) {
            throw new IOException("AccumuloSecurityException in verifyAccumuloCell", e);
        }
        catch (TableNotFoundException e) {
            throw new IOException("TableNotFoundException in verifyAccumuloCell", e);
        }
    }
}

