/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.GenericJdbcManager;
import org.h2.Driver;
import org.junit.After;
import org.junit.Before;

public class TestExportUsingProcedure
extends TestExport {
    private static final String PROCEDURE_NAME = "INSERT_PROCEDURE";
    private static TestExportUsingProcedure instanceForProcedure;
    private int functionCalls = 0;
    private String[] names;
    private String[] types;
    private Connection connection;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        instanceForProcedure = this;
    }

    @Override
    public void createTable(TestExport.ColumnGenerator ... extraColumns) throws SQLException {
        super.createTable(extraColumns);
        this.names = new String[extraColumns.length];
        this.types = new String[extraColumns.length];
        for (int i = 0; i < extraColumns.length; ++i) {
            this.names[i] = this.forIdx(i);
            this.types[i] = extraColumns[i].getType();
        }
        this.createProcedure(this.names, this.types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProcedure(String[] extraNames, String[] extraTypes) throws SQLException {
        StringBuilder drop = new StringBuilder("DROP ALIAS IF EXISTS ");
        drop.append(PROCEDURE_NAME);
        StringBuilder create = new StringBuilder("CREATE ALIAS ");
        create.append(PROCEDURE_NAME);
        create.append(" FOR \"");
        create.append(((Object)((Object)this)).getClass().getName());
        create.append(".insertFunction");
        if (extraNames.length > 0) {
            create.append(this.getName());
        }
        create.append('\"');
        Connection conn = this.getConnection();
        Statement statement = conn.createStatement();
        try {
            statement.execute(drop.toString());
            statement.execute(create.toString());
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected String getConnectString() {
        return "jdbc:h2:mem:" + this.getName();
    }

    @Override
    protected void verifyExport(int expectedNumRecords, Connection conn) throws IOException, SQLException {
        TestExportUsingProcedure.assertEquals((String)"stored procedure must be called for each row", (int)expectedNumRecords, (int)this.functionCalls);
        super.verifyExport(expectedNumRecords, conn);
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStmt, int statementsPerTx, String ... additionalArgv) {
        String[] args = this.newStrArray(additionalArgv, "--call", PROCEDURE_NAME, "--class-name", this.getName(), "--connection-manager", GenericJdbcManager.class.getName(), "--driver", Driver.class.getName());
        return super.getArgv(includeHadoopFlags, rowsPerStmt, statementsPerTx, args);
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] myExtraArgs = this.newStrArray(extraArgs, "--connection-manager", GenericJdbcManager.class.getName(), "--driver", Driver.class.getName());
        return super.getCodeGenArgv(myExtraArgs);
    }

    @Override
    protected Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            this.connection = DriverManager.getConnection(this.getConnectString());
            this.connection.setAutoCommit(false);
            return this.connection;
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions ret = new SqoopOptions(conf);
        if (ret.getConnManagerClassName() == null) {
            ret.setConnManagerClassName(GenericJdbcManager.class.getName());
        }
        if (ret.getDriverClassName() == null) {
            ret.setDriverClassName(Driver.class.getName());
        }
        return ret;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected boolean usesSQLtable() {
        return false;
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void testMultiMapTextExportWithStaging() throws IOException, SQLException {
        try {
            super.testMultiMapTextExportWithStaging();
            TestExportUsingProcedure.fail((String)"staging tables not compatible with --call");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void testMultiTransactionWithStaging() throws IOException, SQLException {
        try {
            super.testMultiTransactionWithStaging();
            TestExportUsingProcedure.fail((String)"staging tables not compatible with --call");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void testColumnsExport() throws IOException, SQLException {
        super.testColumnsExport("P1,P2,P3,P4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertFunction(int id, String msg, SetExtraArgs setExtraArgs) throws SQLException {
        int i;
        ++TestExportUsingProcedure.instanceForProcedure.functionCalls;
        Connection con = instanceForProcedure.getConnection();
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(instanceForProcedure.getTableName());
        sql.append("(id, msg");
        for (i = 0; i < TestExportUsingProcedure.instanceForProcedure.names.length; ++i) {
            sql.append(", ");
            sql.append(TestExportUsingProcedure.instanceForProcedure.names[i]);
        }
        sql.append(") values (");
        for (i = 0; i < TestExportUsingProcedure.instanceForProcedure.names.length + 2; ++i) {
            sql.append("?,");
        }
        sql = sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        PreparedStatement statement = con.prepareStatement(sql.toString());
        try {
            statement.setInt(1, id);
            statement.setString(2, msg);
            setExtraArgs.set(statement);
            statement.execute();
            con.commit();
        }
        finally {
            statement.close();
        }
    }

    public static void insertFunction(int id, String msg) throws SQLException {
        TestExportUsingProcedure.insertFunction(id, msg, new SetExtraArgs(){

            @Override
            public void set(PreparedStatement on) throws SQLException {
            }
        });
    }

    public static void insertFunctiontestIntCol(int id, String msg, final int testIntCol) throws SQLException {
        TestExportUsingProcedure.insertFunction(id, msg, new SetExtraArgs(){

            @Override
            public void set(PreparedStatement on) throws SQLException {
                on.setInt(3, testIntCol);
            }
        });
    }

    public static void insertFunctiontestBigIntCol(int id, String msg, final long testBigIntCol) throws SQLException {
        TestExportUsingProcedure.insertFunction(id, msg, new SetExtraArgs(){

            @Override
            public void set(PreparedStatement on) throws SQLException {
                on.setLong(3, testBigIntCol);
            }
        });
    }

    public static void insertFunctiontestDatesAndTimes(int id, String msg, final Date date, final Time time) throws SQLException {
        TestExportUsingProcedure.insertFunction(id, msg, new SetExtraArgs(){

            @Override
            public void set(PreparedStatement on) throws SQLException {
                on.setDate(3, date);
                on.setTime(4, time);
            }
        });
    }

    public static void insertFunctiontestNumericTypes(int id, String msg, final BigDecimal f, final BigDecimal d) throws SQLException {
        TestExportUsingProcedure.insertFunction(id, msg, new SetExtraArgs(){

            @Override
            public void set(PreparedStatement on) throws SQLException {
                on.setBigDecimal(3, f);
                on.setBigDecimal(4, d);
            }
        });
    }

    public static void insertFunctiontestColumnsExport(int id, String msg, final int int1, final int int2) throws SQLException {
        TestExportUsingProcedure.insertFunction(id, msg, new SetExtraArgs(){

            @Override
            public void set(PreparedStatement on) throws SQLException {
                on.setInt(3, int1);
                on.setNull(4, 4);
                on.setInt(5, int2);
            }
        });
    }

    private static interface SetExtraArgs {
        public void set(PreparedStatement var1) throws SQLException;
    }
}

