/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.sqoop.tool.ImportAllTablesTool;
import org.junit.After;
import org.junit.Before;

public class TestAutoResetMapper
extends ImportJobTestCase {
    private List<String> tableNames;
    private String[][] expectedStrings;
    public static final Log LOG = LogFactory.getLog((String)TestAutoResetMapper.class.getName());
    private static String[][] types = new String[][]{{"INT NOT NULL", "VARCHAR(32)"}, {"INT NOT NULL PRIMARY KEY", "VARCHAR(32)"}, {"INT NOT NULL", "VARCHAR(32)"}, {"INT NOT NULL PRIMARY KEY", "VARCHAR(32)"}, {"INT NOT NULL", "VARCHAR(32)"}};
    private int[] expectedPartFiles = new int[]{1, 2, 1, 2, 1};

    private String[] getArgv() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-D");
        args.add("mapreduce.jobtracker.address=local");
        args.add("-D");
        args.add("fs.defaultFS=file:///");
        args.add("-D");
        args.add("jobclient.completion.poll.interval=50");
        args.add("-D");
        args.add("jobclient.progress.monitor.poll.interval=50");
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--num-mappers");
        args.add("2");
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--escaped-by");
        args.add("\\");
        args.add("--autoreset-to-one-mapper");
        args.add("--verbose");
        return args.toArray(new String[0]);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        if (this.useHsqldbTestServer()) {
            try {
                this.getTestServer().dropExistingSchema();
            }
            catch (SQLException sqlE) {
                TestAutoResetMapper.fail((String)sqlE.toString());
            }
        }
        this.tableNames = new ArrayList<String>();
        int numTables = types.length;
        this.expectedStrings = new String[numTables][];
        int numRows = 2;
        for (int i = 0; i < numTables; ++i) {
            this.expectedStrings[i] = new String[numRows];
            ArrayList<String> vals = new ArrayList<String>();
            for (int j = 0; j < numRows; ++j) {
                String num = Integer.toString(j + 1);
                String str = "Table " + Integer.toString(i + 1) + " Row " + num;
                vals.add(num);
                vals.add("'" + str + "'");
                this.expectedStrings[i][j] = num + "," + str;
            }
            this.createTableWithColTypes(types[i], vals.toArray(new String[vals.size()]));
            this.tableNames.add(this.getTableName());
            this.removeTableDir();
            this.incrementTableNum();
        }
    }

    @Override
    @After
    public void tearDown() {
        try {
            for (String table : this.tableNames) {
                this.dropTableIfExists(table);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't clean up the database:", (Throwable)e);
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiTableImportWithAutoMapperReset() throws IOException {
        String[] argv = this.getArgv();
        this.runImport((SqoopTool)new ImportAllTablesTool(), argv);
        Path warehousePath = new Path(this.getWarehouseDir());
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        for (int i = 0; i < this.tableNames.size(); ++i) {
            String tableName = this.tableNames.get(i);
            LOG.debug((Object)("Validating import of " + tableName));
            Path tablePath = new Path(warehousePath, tableName);
            int numPartFiles = 0;
            ArrayList<String> importedData = new ArrayList<String>();
            for (int m = 0; m < 2; ++m) {
                Path filePath = new Path(tablePath, "part-m-0000" + Integer.toString(m));
                if (!fs.exists(filePath)) continue;
                ++numPartFiles;
                LOG.debug((Object)("Reading imported file " + filePath));
                BufferedReader reader = null;
                if (!TestAutoResetMapper.isOnPhysicalCluster()) {
                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath.toString()))));
                } else {
                    FileSystem dfs = FileSystem.get((Configuration)this.getConf());
                    FSDataInputStream dis = dfs.open(filePath);
                    reader = new BufferedReader(new InputStreamReader((InputStream)dis));
                }
                String line = null;
                try {
                    while ((line = reader.readLine()) != null) {
                        importedData.add(line);
                    }
                    continue;
                }
                finally {
                    IOUtils.closeStream((Closeable)reader);
                }
            }
            TestAutoResetMapper.assertEquals((String)("Table " + tableName + " expected a different number of part files"), (int)this.expectedPartFiles[i], (int)numPartFiles);
            for (int k = 0; k < this.expectedStrings[i].length; ++k) {
                TestAutoResetMapper.assertEquals((String)("Table " + tableName + "expected a different string"), (String)this.expectedStrings[i][k], (String)((String)importedData.get(k)));
            }
        }
    }
}

