/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.junit.Test;

public abstract class ManagerCompatTestCase
extends ImportJobTestCase {
    private Log log = LogFactory.getLog((String)ManagerCompatTestCase.class.getName());
    protected boolean skipped;
    static final String STRING_VAL_IN = "'this is a short string'";
    static final String STRING_VAL_OUT = "this is a short string";

    protected abstract Log getLogger();

    protected abstract String getDbFriendlyName();

    @Override
    protected String getTablePrefix() {
        return "MGR_" + this.getDbFriendlyName().toUpperCase() + "_";
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    public void setUp() {
        this.log = this.getLogger();
        this.skipped = false;
        super.setUp();
    }

    @Override
    public void tearDown() {
        try {
            this.dropTableIfExists(this.getTableName());
        }
        catch (SQLException e) {
            this.log.warn((Object)("Error trying to drop table '" + this.getTableName() + "' on tearDown: " + e));
        }
        super.tearDown();
    }

    protected boolean supportsBoolean() {
        return true;
    }

    protected boolean supportsBigInt() {
        return true;
    }

    protected boolean supportsTinyInt() {
        return true;
    }

    protected boolean supportsLongVarChar() {
        return true;
    }

    protected boolean supportsVarBinary() {
        return true;
    }

    protected boolean supportsTime() {
        return true;
    }

    protected boolean supportsClob() {
        return true;
    }

    protected boolean supportsBlob() {
        return true;
    }

    protected String getNumericType() {
        return "NUMERIC(" + this.getNumericScale() + ", " + this.getNumericDecPartDigits() + ")";
    }

    protected String getDecimalType() {
        return "DECIMAL(" + this.getDecimalScale() + ", " + this.getDecimalDecPartDigits() + ")";
    }

    protected int getNumericScale() {
        return 30;
    }

    protected int getNumericDecPartDigits() {
        return 5;
    }

    protected int getDecimalScale() {
        return 30;
    }

    protected int getDecimalDecPartDigits() {
        return 5;
    }

    protected String getDoubleType() {
        return "DOUBLE";
    }

    protected String getLongVarCharType() {
        return "LONGVARCHAR";
    }

    protected String getTimestampType() {
        return "TIMESTAMP";
    }

    protected String getClobType() {
        return "CLOB";
    }

    protected String getBlobType() {
        return "BLOB";
    }

    protected String getVarBinaryType() {
        return "VARBINARY(12)";
    }

    protected String getTinyIntType() {
        return "TINYINT";
    }

    protected String getTrueBoolNumericSqlInput() {
        return "1";
    }

    protected String getFalseBoolNumericSqlInput() {
        return "0";
    }

    protected String getTrueBoolLiteralSqlInput() {
        return "true";
    }

    protected String getFalseBoolLiteralSqlInput() {
        return "false";
    }

    protected String getTrueBoolSeqOutput() {
        return "true";
    }

    protected String getFalseBoolSeqOutput() {
        return "false";
    }

    protected String padString(int width, String str) {
        int extra = width - str.length();
        for (int i = 0; i < extra; ++i) {
            str = str + " ";
        }
        return str;
    }

    protected String withDecimalZero(String floatingPointStr) {
        if (floatingPointStr.indexOf(".") == -1) {
            return floatingPointStr + ".0";
        }
        return floatingPointStr;
    }

    protected String getRealSeqOutput(String realAsInserted) {
        return this.withDecimalZero(realAsInserted);
    }

    protected String getFloatSeqOutput(String floatAsInserted) {
        return this.withDecimalZero(floatAsInserted);
    }

    protected String getDoubleSeqOutput(String doubleAsInserted) {
        return this.withDecimalZero(doubleAsInserted);
    }

    protected String getDateInsertStr(String insertStr) {
        return insertStr;
    }

    protected String getTimeInsertStr(String insertStr) {
        return insertStr;
    }

    protected String getTimestampInsertStr(String insertStr) {
        return insertStr;
    }

    protected String getDateSeqOutput(String dateAsInserted) {
        return dateAsInserted;
    }

    protected String getTimestampSeqOutput(String tsAsInserted) {
        if ("null".equals(tsAsInserted)) {
            return tsAsInserted;
        }
        int dotPos = tsAsInserted.indexOf(".");
        if (-1 == dotPos) {
            return tsAsInserted + ".0";
        }
        return tsAsInserted;
    }

    protected String getNumericSeqOutput(String numAsInserted) {
        return numAsInserted;
    }

    protected String getDecimalSeqOutput(String numAsInserted) {
        return numAsInserted;
    }

    protected String getFixedCharSeqOut(int fieldWidth, String asInserted) {
        return asInserted;
    }

    protected String getBlobInsertStr(String blobData) {
        return "'" + blobData + "'";
    }

    protected byte[] getBlobDbOutput(String asInserted) {
        try {
            return asInserted.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            ManagerCompatTestCase.fail((String)"Could not get utf8 bytes");
            return null;
        }
    }

    protected String getBlobSeqOutput(String asInserted) {
        return new BytesWritable(this.getBlobDbOutput(asInserted)).toString();
    }

    protected String getVarBinarySeqOutput(String asInserted) {
        return new BytesWritable(this.getBlobDbOutput(asInserted)).toString();
    }

    protected String toLowerHexString(String str) {
        StringBuilder sb = new StringBuilder();
        boolean isOdd = false;
        boolean first = true;
        for (char c : str.toCharArray()) {
            if (!isOdd && !first) {
                sb.append(' ');
            }
            sb.append(Character.toLowerCase(c));
            isOdd = !isOdd;
            first = false;
        }
        return sb.toString();
    }

    protected void verifyType(String colType, String insertVal, String seqFileVal) {
        this.verifyType(colType, insertVal, seqFileVal, false);
    }

    protected void verifyType(String colType, String insertVal, String seqFileVal, boolean useIntPrimaryKey) {
        String readbackPrepend = "";
        if (useIntPrimaryKey) {
            String[] types = new String[]{"INTEGER", colType};
            String[] vals = new String[]{"0", insertVal};
            this.createTableWithColTypes(types, vals);
            readbackPrepend = "0,";
        } else {
            this.createTableForColType(colType, insertVal);
        }
        this.verifyImport(readbackPrepend + seqFileVal, null);
    }

    @Test
    public void testStringCol1() {
        this.verifyType("VARCHAR(32)", STRING_VAL_IN, STRING_VAL_OUT);
    }

    @Test
    public void testStringCol2() {
        this.verifyType("CHAR(32)", STRING_VAL_IN, this.getFixedCharSeqOut(32, STRING_VAL_OUT));
    }

    @Test
    public void testEmptyStringCol() {
        this.verifyType("VARCHAR(32)", "''", "");
    }

    @Test
    public void testNullStringCol() {
        this.verifyType("VARCHAR(32)", "NULL", null);
    }

    @Test
    public void testInt() {
        this.verifyType("INTEGER", "42", "42");
    }

    @Test
    public void testNullInt() {
        this.verifyType("INTEGER", "NULL", null);
    }

    @Test
    public void testBoolean() {
        if (!this.supportsBoolean()) {
            this.log.info((Object)"Skipping boolean test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("BOOLEAN", this.getTrueBoolNumericSqlInput(), this.getTrueBoolSeqOutput());
    }

    @Test
    public void testBoolean2() {
        if (!this.supportsBoolean()) {
            this.log.info((Object)"Skipping boolean test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("BOOLEAN", this.getFalseBoolNumericSqlInput(), this.getFalseBoolSeqOutput());
    }

    @Test
    public void testBoolean3() {
        if (!this.supportsBoolean()) {
            this.log.info((Object)"Skipping boolean test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("BOOLEAN", this.getFalseBoolLiteralSqlInput(), this.getFalseBoolSeqOutput());
    }

    @Test
    public void testTinyInt1() {
        if (!this.supportsTinyInt()) {
            this.log.info((Object)"Skipping tinyint test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType(this.getTinyIntType(), "0", "0");
    }

    @Test
    public void testTinyInt2() {
        if (!this.supportsTinyInt()) {
            this.log.info((Object)"Skipping tinyint test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType(this.getTinyIntType(), "42", "42");
    }

    @Test
    public void testSmallInt1() {
        this.verifyType("SMALLINT", "-1024", "-1024");
    }

    @Test
    public void testSmallInt2() {
        this.verifyType("SMALLINT", "2048", "2048");
    }

    @Test
    public void testBigInt1() {
        if (!this.supportsBigInt()) {
            this.log.info((Object)"Skipping bigint test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("BIGINT", "10000000000", "10000000000");
    }

    @Test
    public void testReal1() {
        this.verifyType("REAL", "256", this.getRealSeqOutput("256"));
    }

    @Test
    public void testReal2() {
        this.verifyType("REAL", "256.45", this.getRealSeqOutput("256.45"));
    }

    @Test
    public void testFloat1() {
        this.verifyType("FLOAT", "256", this.getFloatSeqOutput("256"));
    }

    @Test
    public void testFloat2() {
        this.verifyType("FLOAT", "256.5", this.getFloatSeqOutput("256.5"));
    }

    @Test
    public void testDouble1() {
        this.verifyType(this.getDoubleType(), "-256", this.getDoubleSeqOutput("-256"));
    }

    @Test
    public void testDouble2() {
        this.verifyType(this.getDoubleType(), "256.45", this.getDoubleSeqOutput("256.45"));
    }

    @Test
    public void testDate1() {
        this.verifyType("DATE", this.getDateInsertStr("'2009-01-12'"), this.getDateSeqOutput("2009-01-12"));
    }

    @Test
    public void testDate2() {
        this.verifyType("DATE", this.getDateInsertStr("'2009-04-24'"), this.getDateSeqOutput("2009-04-24"));
    }

    @Test
    public void testTime1() {
        if (!this.supportsTime()) {
            this.log.info((Object)"Skipping time test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("TIME", this.getTimeInsertStr("'12:24:00'"), "12:24:00");
    }

    @Test
    public void testTime2() {
        if (!this.supportsTime()) {
            this.log.info((Object)"Skipping time test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("TIME", this.getTimeInsertStr("'06:24:00'"), "06:24:00");
    }

    @Test
    public void testTime3() {
        if (!this.supportsTime()) {
            this.log.info((Object)"Skipping time test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("TIME", this.getTimeInsertStr("'6:24:00'"), "06:24:00");
    }

    @Test
    public void testTime4() {
        if (!this.supportsTime()) {
            this.log.info((Object)"Skipping time test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType("TIME", this.getTimeInsertStr("'18:24:00'"), "18:24:00");
    }

    @Test
    public void testTimestamp1() {
        this.verifyType(this.getTimestampType(), this.getTimestampInsertStr("'2009-04-24 18:24:00'"), this.getTimestampSeqOutput("2009-04-24 18:24:00"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestamp2() {
        try {
            this.log.debug((Object)"Beginning testTimestamp2");
            this.verifyType(this.getTimestampType(), this.getTimestampInsertStr("'2009-04-24 18:24:00.0002'"), this.getTimestampSeqOutput("2009-04-24 18:24:00.0002"));
        }
        finally {
            this.log.debug((Object)"End testTimestamp2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimestamp3() {
        try {
            this.log.debug((Object)"Beginning testTimestamp3");
            this.verifyType(this.getTimestampType(), "null", null);
        }
        finally {
            this.log.debug((Object)"End testTimestamp3");
        }
    }

    @Test
    public void testNumeric1() {
        this.verifyType(this.getNumericType(), "1", this.getNumericSeqOutput("1"));
    }

    @Test
    public void testNumeric2() {
        this.verifyType(this.getNumericType(), "-10", this.getNumericSeqOutput("-10"));
    }

    @Test
    public void testNumeric3() {
        this.verifyType(this.getNumericType(), "3.14159", this.getNumericSeqOutput("3.14159"));
    }

    @Test
    public void testNumeric4() {
        this.verifyType(this.getNumericType(), "3000000000000000000.14159", this.getNumericSeqOutput("3000000000000000000.14159"));
    }

    @Test
    public void testNumeric5() {
        this.verifyType(this.getNumericType(), "99999999999999999999.14159", this.getNumericSeqOutput("99999999999999999999.14159"));
    }

    @Test
    public void testNumeric6() {
        this.verifyType(this.getNumericType(), "-99999999999999999999.14159", this.getNumericSeqOutput("-99999999999999999999.14159"));
    }

    @Test
    public void testDecimal1() {
        this.verifyType(this.getDecimalType(), "1", this.getDecimalSeqOutput("1"));
    }

    @Test
    public void testDecimal2() {
        this.verifyType(this.getDecimalType(), "-10", this.getDecimalSeqOutput("-10"));
    }

    @Test
    public void testDecimal3() {
        this.verifyType(this.getDecimalType(), "3.14159", this.getDecimalSeqOutput("3.14159"));
    }

    @Test
    public void testDecimal4() {
        this.verifyType(this.getDecimalType(), "3000000000000000000.14159", this.getDecimalSeqOutput("3000000000000000000.14159"));
    }

    @Test
    public void testDecimal5() {
        this.verifyType(this.getDecimalType(), "99999999999999999999.14159", this.getDecimalSeqOutput("99999999999999999999.14159"));
    }

    @Test
    public void testDecimal6() {
        this.verifyType(this.getDecimalType(), "-99999999999999999999.14159", this.getDecimalSeqOutput("-99999999999999999999.14159"));
    }

    @Test
    public void testLongVarChar() {
        if (!this.supportsLongVarChar()) {
            this.log.info((Object)"Skipping long varchar test (unsupported)");
            this.skipped = true;
            return;
        }
        this.verifyType(this.getLongVarCharType(), "'this is a long varchar'", "this is a long varchar");
    }

    protected void verifyClob(String insertVal, String returnVal, String seqFileVal) {
        String[] types = new String[]{"INTEGER NOT NULL", this.getClobType()};
        String[] vals = new String[]{"1", insertVal};
        String[] checkCol = new String[]{"DATA_COL0", "DATA_COL1"};
        this.createTableWithColTypes(types, vals);
        this.verifyImport("1," + seqFileVal, checkCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyBlob(String insertVal, byte[] returnVal, String seqFileVal) {
        String[] types = new String[]{"INTEGER NOT NULL", this.getBlobType()};
        String[] vals = new String[]{"1", insertVal};
        String[] checkCols = new String[]{"DATA_COL0", "DATA_COL1"};
        this.createTableWithColTypes(types, vals);
        ResultSet results = null;
        try {
            results = this.getManager().readTable(this.getTableName(), this.getColNames());
            ManagerCompatTestCase.assertNotNull((String)"Null results from readTable()!", (Object)results);
            ManagerCompatTestCase.assertTrue((String)"Expected at least one row returned", (boolean)results.next());
            Blob blob = results.getBlob(2);
            byte[] databaseBytes = blob.getBytes(1L, (int)blob.length());
            this.log.info((Object)("Verifying readback of bytes from " + this.getTableName()));
            ManagerCompatTestCase.assertEquals((String)"byte arrays differ in size", (int)returnVal.length, (int)databaseBytes.length);
            for (int i = 0; i < returnVal.length; ++i) {
                ManagerCompatTestCase.assertEquals((String)("bytes differ at position " + i + ". Expected " + returnVal[i] + "; got " + databaseBytes[i]), (byte)returnVal[i], (byte)databaseBytes[i]);
            }
            ManagerCompatTestCase.assertFalse((String)"Expected at most one row returned", (boolean)results.next());
        }
        catch (SQLException sqlE) {
            ManagerCompatTestCase.fail((String)("Got SQLException: " + sqlE.toString()));
        }
        finally {
            if (null != results) {
                try {
                    results.close();
                }
                catch (SQLException sqlE) {
                    ManagerCompatTestCase.fail((String)("Got SQLException in resultset.close(): " + sqlE.toString()));
                }
            }
            this.getManager().release();
        }
        this.verifyImport("1," + seqFileVal, checkCols);
    }

    @Test
    public void testClob1() {
        if (!this.supportsClob()) {
            this.log.info((Object)"Skipping CLOB test; database does not support CLOB");
            return;
        }
        this.verifyClob("'This is short CLOB data'", "This is short CLOB data", "This is short CLOB data");
    }

    @Test
    public void testBlob1() {
        if (!this.supportsBlob()) {
            this.log.info((Object)"Skipping BLOB test; database does not support BLOB");
            return;
        }
        this.verifyBlob(this.getBlobInsertStr("This is short BLOB data"), this.getBlobDbOutput("This is short BLOB data"), this.getBlobSeqOutput("This is short BLOB data"));
    }

    @Test
    public void testVarBinary() {
        if (!this.supportsVarBinary()) {
            this.log.info((Object)"Skipping VARBINARY test; database does not support VARBINARY");
            return;
        }
        this.verifyType(this.getVarBinaryType(), "'F00FABCD'", this.getVarBinarySeqOutput("F00FABCD"), true);
    }
}

