/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import com.cloudera.sqoop.manager.DirectMySQLManager;
import com.cloudera.sqoop.manager.MySQLAuthTest;
import com.cloudera.sqoop.manager.MySQLTestUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Before;

public class DirectMySQLExportTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)DirectMySQLExportTest.class.getName());
    static final String TABLE_PREFIX = "EXPORT_MYSQL_";
    private DirectMySQLManager manager;
    private Connection conn;

    @Override
    protected Connection getConnection() {
        return this.conn;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return MySQLTestUtils.CONNECT_STRING;
    }

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(MySQLTestUtils.CONNECT_STRING, this.getTableName());
        options.setUsername(MySQLTestUtils.getCurrentUser());
        this.manager = new DirectMySQLManager(options);
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            DirectMySQLExportTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
    }

    @Override
    @After
    public void tearDown() {
        try {
            Statement stmt = this.conn.createStatement();
            stmt.execute(this.getDropTableStatement(this.getTableName()));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't clean up the database:", (Throwable)e);
        }
        super.tearDown();
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Got SQLException closing conn: " + sqlE.toString()));
            }
        }
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] moreArgs = new String[extraArgs.length + 2];
        int i = 0;
        for (i = 0; i < extraArgs.length; ++i) {
            moreArgs[i] = extraArgs[i];
        }
        moreArgs[i++] = "--username";
        moreArgs[i++] = MySQLTestUtils.getCurrentUser();
        return super.getCodeGenArgv(moreArgs);
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        String[] subArgv = this.newStrArray(additionalArgv, "--direct", "--username", MySQLTestUtils.getCurrentUser());
        return super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, subArgv);
    }

    public void testMultiTxExport() throws IOException, SQLException {
        this.multiFileTest(1, 20, 1, "-D", "sqoop.mysql.export.checkpoint.bytes=10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuthExport() throws IOException, SQLException {
        SqoopOptions options = new SqoopOptions(MySQLAuthTest.AUTH_CONNECT_STRING, this.getTableName());
        options.setUsername("sqooptest");
        options.setPassword("12345");
        this.manager = new DirectMySQLManager(options);
        Connection connection = null;
        Statement st = null;
        String tableName = this.getTableName();
        try {
            connection = this.manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS " + tableName);
            st.executeUpdate("CREATE TABLE " + tableName + " (" + "id INT NOT NULL PRIMARY KEY, " + "msg VARCHAR(24) NOT NULL)");
            connection.commit();
            Path tablePath = this.getTablePath();
            Path filePath = new Path(tablePath, "datafile");
            Configuration conf = new Configuration();
            conf.set("fs.default.name", "file:///");
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.mkdirs(tablePath);
            FSDataOutputStream os = fs.create(filePath);
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
            w.write(this.getRecordLine(0, new TestExport.ColumnGenerator[0]));
            w.write(this.getRecordLine(1, new TestExport.ColumnGenerator[0]));
            w.write(this.getRecordLine(2, new TestExport.ColumnGenerator[0]));
            w.close();
            os.close();
            this.runExport(this.getArgv(true, 10, 10, "--username", "sqooptest", "--password", "12345", "--connect", MySQLAuthTest.AUTH_CONNECT_STRING));
            this.verifyExport(3, connection);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            DirectMySQLExportTest.fail((String)("SQLException when accessing target table. " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    @Override
    public void testMultiMapTextExportWithStaging() throws IOException, SQLException {
    }

    @Override
    public void testMultiTransactionWithStaging() throws IOException, SQLException {
    }
}

