/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.util.ReflectionUtils;

public class TestSplitBy
extends ImportJobTestCase {
    protected String[] getArgv(boolean includeHadoopFlags, String[] colNames, String splitByCol) {
        String columnsString = "";
        for (String col : colNames) {
            columnsString = columnsString + col + ",";
        }
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(HsqldbTestServer.getTableName());
        args.add("--columns");
        args.add(columnsString);
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--as-sequencefile");
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    private int getFirstInt(String str) {
        String[] parts = str.split(",");
        return Integer.parseInt(parts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runSplitByTest(String splitByCol, int expectedSum) throws IOException {
        String[] columns = HsqldbTestServer.getFieldNames();
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, columns, splitByCol);
        this.runImport(argv);
        try {
            SqoopOptions opts = new ImportTool().parseArguments(this.getArgv(false, columns, splitByCol), null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            LOG.debug((Object)("Got jar from import job: " + jarFileName));
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            reader = SeqFileReader.getSeqFileReader(this.getDataFilePath().toString());
            Configuration conf = new Configuration();
            Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            int curSum = 0;
            while (reader.next(key) != null) {
                reader.getCurrentValue(val);
                curSum += this.getFirstInt(val.toString());
            }
            TestSplitBy.assertEquals((String)"Total sum of first db column mismatch", (int)expectedSum, (int)curSum);
            IOUtils.closeStream((Closeable)reader);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            TestSplitBy.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            TestSplitBy.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testSplitByFirstCol() throws IOException {
        String splitByCol = "INTFIELD1";
        this.runSplitByTest(splitByCol, HsqldbTestServer.getFirstColSum());
    }

    public void testSplitBySecondCol() throws IOException {
        String splitByCol = "INTFIELD2";
        this.runSplitByTest(splitByCol, HsqldbTestServer.getFirstColSum());
    }
}

