/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.util.MainframeFTPClientUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMainframeFTPClientUtils {
    private JobConf conf;
    private FTPClient mockFTPClient;

    @Before
    public void setUp() {
        this.conf = new JobConf();
        this.mockFTPClient = (FTPClient)Mockito.mock(FTPClient.class);
        Mockito.when((Object)this.mockFTPClient.getReplyString()).thenReturn((Object)"");
        MainframeFTPClientUtils.setMockFTPClient((FTPClient)this.mockFTPClient);
    }

    @After
    public void tearDown() {
        MainframeFTPClientUtils.setMockFTPClient(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnonymous_VERBOSE_IllegelPort() {
        try {
            Mockito.when((Object)this.mockFTPClient.login("anonymous", "")).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.logout()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.isConnected()).thenReturn((Object)false);
            Mockito.when((Object)this.mockFTPClient.getReplyCode()).thenReturn((Object)200);
        }
        catch (IOException e) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        this.conf.set("mapreduce.jdbc.url", "localhost:testPort");
        this.conf.setBoolean("sqoop.verbose", true);
        FTPClient ftp = null;
        boolean success = false;
        try {
            ftp = MainframeFTPClientUtils.getFTPConnection((Configuration)this.conf);
        }
        catch (IOException ioe) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        finally {
            success = MainframeFTPClientUtils.closeFTPConnection((FTPClient)ftp);
        }
        Assert.assertTrue((boolean)success);
    }

    @Test
    public void testCannotConnect() {
        try {
            Mockito.when((Object)this.mockFTPClient.login("testUser", "")).thenReturn((Object)false);
        }
        catch (IOException ioe) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        this.conf.set("mapreduce.jdbc.url", "testUser:11111");
        try {
            MainframeFTPClientUtils.getFTPConnection((Configuration)this.conf);
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"java.io.IOException: FTP server testUser refused connection:", (Object)ioe.toString());
        }
    }

    @Test
    public void testWrongUsername() {
        try {
            Mockito.when((Object)this.mockFTPClient.login("user", "pssword")).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.logout()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.isConnected()).thenReturn((Object)false);
            Mockito.when((Object)this.mockFTPClient.getReplyCode()).thenReturn((Object)200);
        }
        catch (IOException e) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        FTPClient ftp = null;
        this.conf.set("mapreduce.jdbc.url", "localhost:11111");
        this.conf.set("mapreduce.jdbc.username", "userr");
        this.conf.set("mapreduce.jdbc.password", "pssword");
        Text PASSWORD_SECRET_KEY = new Text("mapreduce.jdbc.password");
        this.conf.getCredentials().addSecretKey(PASSWORD_SECRET_KEY, "pssword".getBytes());
        try {
            ftp = MainframeFTPClientUtils.getFTPConnection((Configuration)this.conf);
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"java.io.IOException: Could not login to server localhost:", (Object)ioe.toString());
        }
        Assert.assertNull((Object)ftp);
    }

    @Test
    public void testNotListDatasets() {
        try {
            Mockito.when((Object)this.mockFTPClient.login("user", "pssword")).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.logout()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.isConnected()).thenReturn((Object)false);
            Mockito.when((Object)this.mockFTPClient.getReplyCode()).thenReturn((Object)200);
        }
        catch (IOException e) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        this.conf.set("mapreduce.jdbc.url", "localhost:11111");
        this.conf.set("mapreduce.jdbc.username", "userr");
        this.conf.set("mapreduce.jdbc.password", "pssword");
        Text PASSWORD_SECRET_KEY = new Text("mapreduce.jdbc.password");
        this.conf.getCredentials().addSecretKey(PASSWORD_SECRET_KEY, "pssword".getBytes());
        try {
            MainframeFTPClientUtils.listSequentialDatasets((String)"pdsName", (Configuration)this.conf);
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"java.io.IOException: Could not list datasets from pdsName:java.io.IOException: Could not login to server localhost:", (Object)ioe.toString());
        }
    }
}

