/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetFTPRecordReader;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetRecordReader;
import org.apache.sqoop.mapreduce.mainframe.MainframeImportJob;
import org.apache.sqoop.util.MainframeFTPClientUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestMainframeDatasetFTPRecordReader {
    private MainframeImportJob mfImportJob;
    private MainframeImportJob avroImportJob;
    private MainframeDatasetInputSplit mfDIS;
    private TaskAttemptContext context;
    private MainframeDatasetRecordReader mfDRR;
    private MainframeDatasetFTPRecordReader mfDFTPRR;
    private FTPClient mockFTPClient;

    @Before
    public void setUp() throws IOException {
        this.mockFTPClient = (FTPClient)Mockito.mock(FTPClient.class);
        MainframeFTPClientUtils.setMockFTPClient((FTPClient)this.mockFTPClient);
        try {
            Mockito.when((Object)this.mockFTPClient.login("user", "pssword")).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.logout()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.isConnected()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.completePendingCommand()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.changeWorkingDirectory(Matchers.anyString())).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.getReplyCode()).thenReturn((Object)200);
            Mockito.when((Object)this.mockFTPClient.noop()).thenReturn((Object)200);
            Mockito.when((Object)this.mockFTPClient.setFileType(Matchers.anyInt())).thenReturn((Object)true);
            FTPFile ftpFile1 = new FTPFile();
            ftpFile1.setType(0);
            ftpFile1.setName("test1");
            FTPFile ftpFile2 = new FTPFile();
            ftpFile2.setType(0);
            ftpFile2.setName("test2");
            FTPFile[] ftpFiles = new FTPFile[]{ftpFile1, ftpFile2};
            Mockito.when((Object)this.mockFTPClient.listFiles()).thenReturn((Object)ftpFiles);
            Mockito.when((Object)this.mockFTPClient.retrieveFileStream("test1")).thenReturn((Object)new ByteArrayInputStream("123\n456\n".getBytes()));
            Mockito.when((Object)this.mockFTPClient.retrieveFileStream("test2")).thenReturn((Object)new ByteArrayInputStream("789\n".getBytes()));
            Mockito.when((Object)this.mockFTPClient.retrieveFileStream("NotComplete")).thenReturn((Object)new ByteArrayInputStream("NotComplete\n".getBytes()));
        }
        catch (IOException e) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        JobConf conf = new JobConf();
        conf.set("mapreduce.jdbc.url", "localhost:11111");
        conf.set("mapreduce.jdbc.username", "user");
        conf.set("mapreduce.jdbc.password", "pssword");
        Text PASSWORD_SECRET_KEY = new Text("mapreduce.jdbc.password");
        conf.getCredentials().addSecretKey(PASSWORD_SECRET_KEY, "pssword".getBytes());
        conf.setClass("mapreduce.jdbc.input.class", DummySqoopRecord.class, DBWritable.class);
        Job job = new Job((Configuration)conf);
        this.mfDIS = new MainframeDatasetInputSplit();
        this.mfDIS.addDataset("test1");
        this.mfDIS.addDataset("test2");
        this.context = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)this.context.getConfiguration()).thenReturn((Object)job.getConfiguration());
        this.mfDFTPRR = new MainframeDatasetFTPRecordReader();
    }

    @After
    public void tearDown() {
        try {
            this.mfDFTPRR.close();
        }
        catch (IOException ioe) {
            Assert.fail((String)("Got IOException: " + ioe.toString()));
        }
        MainframeFTPClientUtils.setMockFTPClient(null);
    }

    @Test
    public void testReadAllData() {
        try {
            this.mfDFTPRR.initialize((InputSplit)this.mfDIS, this.context);
            Assert.assertTrue((String)"Retrieve of dataset", (boolean)this.mfDFTPRR.nextKeyValue());
            Assert.assertEquals((String)"Key should increase by records", (long)1L, (long)this.mfDFTPRR.getCurrentKey().get());
            Assert.assertEquals((String)"Read value by line and by dataset", (Object)"123", (Object)this.mfDFTPRR.getCurrentValue().toString());
            Assert.assertEquals((String)"Get progress according to left dataset", (double)this.mfDFTPRR.getProgress(), (double)0.5, (double)0.02);
            Assert.assertTrue((String)"Retrieve of dataset", (boolean)this.mfDFTPRR.nextKeyValue());
            Assert.assertEquals((String)"Key should increase by records", (long)2L, (long)this.mfDFTPRR.getCurrentKey().get());
            Assert.assertEquals((String)"Read value by line and by dataset", (Object)"456", (Object)this.mfDFTPRR.getCurrentValue().toString());
            Assert.assertEquals((String)"Get progress according to left dataset", (double)this.mfDFTPRR.getProgress(), (double)0.5, (double)0.02);
            Assert.assertTrue((String)"Retrieve of dataset", (boolean)this.mfDFTPRR.nextKeyValue());
            Assert.assertEquals((String)"Key should increase by records", (long)3L, (long)this.mfDFTPRR.getCurrentKey().get());
            Assert.assertEquals((String)"Read value by line and by dataset", (Object)"789", (Object)this.mfDFTPRR.getCurrentValue().toString());
            Assert.assertEquals((String)"Get progress according to left dataset", (double)this.mfDFTPRR.getProgress(), (double)1.0, (double)0.02);
            Assert.assertFalse((String)"End of dataset", (boolean)this.mfDFTPRR.nextKeyValue());
        }
        catch (IOException ioe) {
            Assert.fail((String)("Got IOException: " + ioe.toString()));
        }
        catch (InterruptedException ie) {
            Assert.fail((String)("Got InterruptedException: " + ie.toString()));
        }
    }

    @Test
    public void testReadPartOfData() {
        try {
            this.mfDFTPRR.initialize((InputSplit)this.mfDIS, this.context);
            Assert.assertTrue((String)"Retrieve of dataset", (boolean)this.mfDFTPRR.nextKeyValue());
            Assert.assertEquals((String)"Key should increase by records", (long)1L, (long)this.mfDFTPRR.getCurrentKey().get());
            Assert.assertEquals((String)"Read value by line and by dataset", (Object)"123", (Object)this.mfDFTPRR.getCurrentValue().toString());
            Assert.assertEquals((String)"Get progress according to left dataset", (double)this.mfDFTPRR.getProgress(), (double)0.5, (double)0.02);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Got IOException: " + ioe.toString()));
        }
        catch (InterruptedException ie) {
            Assert.fail((String)("Got InterruptedException: " + ie.toString()));
        }
    }

    @Test
    public void testFTPNotComplete() {
        try {
            this.mfDIS = new MainframeDatasetInputSplit();
            this.mfDIS.addDataset("NotComplete");
            this.mfDFTPRR.initialize((InputSplit)this.mfDIS, this.context);
            Assert.assertTrue((String)"Retrieve of dataset", (boolean)this.mfDFTPRR.nextKeyValue());
            Mockito.when((Object)this.mockFTPClient.completePendingCommand()).thenReturn((Object)false);
            this.mfDFTPRR.nextKeyValue();
        }
        catch (IOException ioe) {
            Assert.assertEquals((Object)"java.io.IOException: IOException during data transfer: java.io.IOException: Failed to complete ftp command.", (Object)ioe.toString());
        }
        catch (InterruptedException ie) {
            Assert.fail((String)("Got InterruptedException: " + ie.toString()));
        }
    }

    public static class DummySqoopRecord
    extends SqoopRecord {
        private String field;

        public Map<String, Object> getFieldMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fieldName", this.field);
            return map;
        }

        public void setField(String fieldName, Object fieldVal) {
            if (fieldVal instanceof String) {
                this.field = (String)fieldVal;
            }
        }

        public void setField(String val) {
            this.field = val;
        }

        public void readFields(DataInput in) throws IOException {
            this.field = in.readUTF();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.field);
        }

        public void readFields(ResultSet rs) throws SQLException {
            this.field = rs.getString(1);
        }

        public void write(PreparedStatement s) throws SQLException {
            s.setString(1, this.field);
        }

        public String toString() {
            return this.field;
        }

        public int write(PreparedStatement stmt, int offset) throws SQLException {
            return 0;
        }

        public String toString(DelimiterSet delimiters) {
            return null;
        }

        public int getClassFormatVersion() {
            return 0;
        }

        public int hashCode() {
            return Integer.parseInt(this.field);
        }

        public void loadLargeObjects(LargeObjectLoader loader) {
        }

        public void parse(CharSequence s) {
        }

        public void parse(Text s) {
        }

        public void parse(byte[] s) {
        }

        public void parse(char[] s) {
        }

        public void parse(ByteBuffer s) {
        }

        public void parse(CharBuffer s) {
        }
    }
}

