/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.sqoop.manager.oracle.util.OracleDataDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OracleTableDefinition {
    private String tableName;
    private List<OracleDataDefinition> columnList = new ArrayList<OracleDataDefinition>();
    private List<String> primaryKeyColumns = new ArrayList<String>();
    private List<String> uniqueKeyColumns = new ArrayList<String>();
    private String partitionClause;
    private boolean indexOrganizedTable = false;

    public List<String> getUniqueKeyColumns() {
        return this.uniqueKeyColumns;
    }

    public void setUniqueKeyColumns(List<String> newUniqueKeyColumns) {
        this.uniqueKeyColumns = newUniqueKeyColumns;
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(List<String> newPrimaryKeyColumns) {
        this.primaryKeyColumns = newPrimaryKeyColumns;
    }

    public List<OracleDataDefinition> getColumnList() {
        return this.columnList;
    }

    public void setColumnList(List<OracleDataDefinition> newColumnList) {
        this.columnList = newColumnList;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String newTableName) {
        this.tableName = newTableName;
    }

    public String getPartitionClause() {
        return this.partitionClause == null ? "" : this.partitionClause;
    }

    public void setPartitionClause(String newPartitionClause) {
        this.partitionClause = newPartitionClause;
    }

    public boolean isIndexOrganizedTable() {
        return this.indexOrganizedTable;
    }

    public void setIndexOrganizedTable(boolean newIndexOrganizedTable) {
        this.indexOrganizedTable = newIndexOrganizedTable;
    }

    public OracleTableDefinition() {
    }

    public OracleTableDefinition(URL url) {
        try {
            Node indexOrganizedTableNode;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(url.toURI()));
            Element table = doc.getDocumentElement();
            this.tableName = table.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue();
            NodeList columns = table.getElementsByTagName("column");
            for (int i = 0; i < columns.getLength(); ++i) {
                Node columnNode = columns.item(i);
                if (columnNode.getNodeType() != 1) continue;
                Element columnElement = (Element)columnNode;
                String name = columnElement.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue();
                String dataType = columnElement.getElementsByTagName("dataType").item(0).getChildNodes().item(0).getNodeValue();
                String dataExpression = columnElement.getElementsByTagName("dataExpression").item(0).getChildNodes().item(0).getNodeValue();
                this.columnList.add(new OracleDataDefinition(name, dataType, dataExpression));
            }
            NodeList primaryKeyColumnsNodeList = table.getElementsByTagName("primaryKeyColumn");
            for (int i = 0; i < primaryKeyColumnsNodeList.getLength(); ++i) {
                Node primaryKeyColumnNode = primaryKeyColumnsNodeList.item(i);
                if (primaryKeyColumnNode.getNodeType() != 1) continue;
                Element primaryKeyColumnElement = (Element)primaryKeyColumnNode;
                this.primaryKeyColumns.add(primaryKeyColumnElement.getChildNodes().item(0).getNodeValue());
            }
            NodeList uniqueKeyColumnsNodeList = table.getElementsByTagName("uniqueKeyColumn");
            for (int i = 0; i < uniqueKeyColumnsNodeList.getLength(); ++i) {
                Node uniqueKeyColumnNode = uniqueKeyColumnsNodeList.item(i);
                if (uniqueKeyColumnNode.getNodeType() != 1) continue;
                Element uniqueKeyColumnElement = (Element)uniqueKeyColumnNode;
                this.uniqueKeyColumns.add(uniqueKeyColumnElement.getChildNodes().item(0).getNodeValue());
            }
            Node partitionClauseNode = table.getElementsByTagName("partitionClause").item(0);
            if (partitionClauseNode != null) {
                this.partitionClause = partitionClauseNode.getChildNodes().item(0).getNodeValue();
            }
            if ((indexOrganizedTableNode = table.getElementsByTagName("indexOrganizedTable").item(0)) != null) {
                String indexOrganizedTableStr = indexOrganizedTableNode.getChildNodes().item(0).getNodeValue();
                this.indexOrganizedTable = Boolean.parseBoolean(indexOrganizedTableStr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load table configuration", e);
        }
    }
}

