/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.sqoop.manager.oracle.util.OraOopTestDataGenerator;

public class FloatGenerator
extends OraOopTestDataGenerator<BigDecimal> {
    private static final int MIN_SCALE = -125;
    private static final int MAX_SCALE = 125;
    private final int precision;

    public FloatGenerator(int precision) {
        this.precision = precision;
    }

    @Override
    public BigDecimal next() {
        BigInteger unscaled = new BigInteger(this.precision, this.rng);
        BigDecimal unscaledBD = new BigDecimal(unscaled);
        int scale = this.rng.nextInt(251) + -125 - unscaledBD.precision();
        BigDecimal result = new BigDecimal(unscaled, -scale);
        if (this.rng.nextBoolean()) {
            result = result.negate();
        }
        return result;
    }
}

