/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.SqoopRecord;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.apache.sqoop.manager.oracle.util.BigDecimalGenerator;
import org.apache.sqoop.manager.oracle.util.BinaryDoubleGenerator;
import org.apache.sqoop.manager.oracle.util.BinaryFloatGenerator;
import org.apache.sqoop.manager.oracle.util.BlobGenerator;
import org.apache.sqoop.manager.oracle.util.BytesGenerator;
import org.apache.sqoop.manager.oracle.util.CharGenerator;
import org.apache.sqoop.manager.oracle.util.FloatGenerator;
import org.apache.sqoop.manager.oracle.util.IntervalDaySecondGenerator;
import org.apache.sqoop.manager.oracle.util.IntervalYearMonthGenerator;
import org.apache.sqoop.manager.oracle.util.NCharGenerator;
import org.apache.sqoop.manager.oracle.util.RowIdGenerator;
import org.apache.sqoop.manager.oracle.util.TimestampGenerator;
import org.apache.sqoop.manager.oracle.util.URIGenerator;
import org.junit.Assert;
import org.junit.Test;

public class SystemImportTest
extends OraOopTestCase {
    private static Class<?> preparedStatementClass;
    private static Method methSetBinaryDouble;
    private static Method methSetBinaryFloat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void importTest() throws Exception {
        this.setSqoopTargetDirectory(this.getSqoopTargetDirectory() + "oraoop_test");
        int numRows = 100;
        Connection conn = this.getTestEnvConnection();
        OraOopOracleQueries.setConnectionTimeZone((Connection)conn, (String)"GMT");
        try {
            Statement s = conn.createStatement();
            try {
                int i;
                s.executeUpdate("CREATE TABLE oraoop_test (id NUMBER(10) PRIMARY KEY, bd BINARY_DOUBLE, bf BINARY_FLOAT, b BLOB, c CHAR(12), cl CLOB, d DATE, f FLOAT(126), l LONG, nc NCHAR(30), ncl NCLOB, n NUMBER(9,2), nvc NVARCHAR2(30), r ROWID, u URITYPE, iym INTERVAL YEAR(2) TO MONTH, ids INTERVAL DAY(2) TO SECOND(6), t TIMESTAMP(6), tz TIMESTAMP(6) WITH TIME ZONE, tltz TIMESTAMP(6) WITH LOCAL TIME ZONE, rawcol RAW(21))");
                BinaryDoubleGenerator bdg = new BinaryDoubleGenerator();
                BinaryFloatGenerator bfg = new BinaryFloatGenerator();
                BlobGenerator bg = new BlobGenerator(conn, 2048, 8192);
                CharGenerator cg = new CharGenerator(12, 12);
                CharGenerator clobg = new CharGenerator(2048, 8192);
                TimestampGenerator dateg = new TimestampGenerator(0);
                FloatGenerator fg = new FloatGenerator(126);
                CharGenerator lg = new CharGenerator(2048, 8192);
                NCharGenerator ncg = new NCharGenerator(30, 30);
                NCharGenerator nclobg = new NCharGenerator(2048, 8192);
                BigDecimalGenerator ng = new BigDecimalGenerator(9, 2);
                NCharGenerator nvcg = new NCharGenerator(1, 30);
                RowIdGenerator rg = new RowIdGenerator();
                URIGenerator ug = new URIGenerator();
                IntervalYearMonthGenerator iymg = new IntervalYearMonthGenerator(2);
                IntervalDaySecondGenerator idsg = new IntervalDaySecondGenerator(2, 6);
                TimestampGenerator tg = new TimestampGenerator(6);
                TimestampGenerator tzg = new TimestampGenerator(6);
                TimestampGenerator tltzg = new TimestampGenerator(6);
                BytesGenerator rawg = new BytesGenerator(21, 21);
                PreparedStatement ps = conn.prepareStatement("INSERT INTO oraoop_test ( id, bd, bf, b, c, cl, d, f, nc, ncl, n, nvc, r, u, iym, ids, t, tz, tltz, rawcol ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, sys.UriFactory.getUri(?), ?, ?, ?, ?, ?, ? )");
                try {
                    for (i = 0; i < numRows; ++i) {
                        ps.setInt(1, i);
                        methSetBinaryDouble.invoke((Object)ps, 2, bdg.next());
                        methSetBinaryFloat.invoke((Object)ps, 3, bfg.next());
                        ps.setBlob(4, bg.next());
                        ps.setString(5, cg.next());
                        ps.setString(6, clobg.next());
                        ps.setTimestamp(7, dateg.next());
                        ps.setBigDecimal(8, fg.next());
                        ps.setString(9, ncg.next());
                        ps.setString(10, nclobg.next());
                        ps.setBigDecimal(11, ng.next());
                        ps.setString(12, nvcg.next());
                        ps.setRowId(13, rg.next());
                        ps.setString(14, ug.next());
                        ps.setString(15, iymg.next());
                        ps.setString(16, idsg.next());
                        ps.setTimestamp(17, tg.next());
                        ps.setTimestamp(18, tzg.next());
                        ps.setTimestamp(19, tltzg.next());
                        ps.setBytes(20, rawg.next());
                        ps.executeUpdate();
                    }
                }
                finally {
                    ps.close();
                    conn.commit();
                }
                ps = conn.prepareStatement("UPDATE oraoop_test SET l = ? WHERE id = ?");
                try {
                    for (i = 0; i < numRows; ++i) {
                        ps.setString(1, lg.next());
                        ps.setInt(2, i);
                        ps.executeUpdate();
                    }
                }
                finally {
                    ps.close();
                    conn.commit();
                }
                try {
                    int retCode = this.runImport("oraoop_test", this.getSqoopConf(), true);
                    Assert.assertEquals((String)"Return code should be 0", (long)0L, (long)retCode);
                    String sqoopGenJarPath = "file://" + this.getSqoopGenLibDirectory() + "/" + this.getSqoopGenClassName() + ".jar";
                    URLClassLoader loader = new URLClassLoader(new URL[]{new URL(sqoopGenJarPath)}, this.getClass().getClassLoader());
                    Thread.currentThread().setContextClassLoader(loader);
                    Configuration hadoopConf = this.getSqoopConf();
                    FileSystem hdfs = FileSystem.get((Configuration)hadoopConf);
                    Path path = new Path(this.getSqoopTargetDirectory());
                    FileStatus[] statuses = hdfs.listStatus(path);
                    int hadoopRecordCount = 0;
                    for (FileStatus status : statuses) {
                        if (!status.getPath().getName().startsWith("part-m-")) continue;
                        SequenceFile.Reader reader = new SequenceFile.Reader(hdfs, status.getPath(), hadoopConf);
                        LongWritable key = new LongWritable();
                        SqoopRecord value = (SqoopRecord)reader.getValueClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                        ps = conn.prepareStatement("SELECT bd, bf, b, c, cl, d, f, l, nc, ncl, nvc, r, u, iym, ids, t, tz, tltz, rawcol FROM oraoop_test WHERE id = ?");
                        while (reader.next((Writable)key, (Writable)value)) {
                            Map fields = value.getFieldMap();
                            BigDecimal id = (BigDecimal)fields.get("ID");
                            ps.setBigDecimal(1, id);
                            ResultSet rs = ps.executeQuery();
                            Assert.assertTrue((String)("Did not find row with id " + id + " in oracle"), (boolean)rs.next());
                            Assert.assertEquals((String)("BinaryDouble did not match for row " + id), fields.get("BD"), (Object)rs.getDouble(1));
                            Assert.assertEquals((String)("BinaryFloat did not match for row " + id), fields.get("BF"), (Object)Float.valueOf(rs.getFloat(2)));
                            Assert.assertEquals((String)("Long did not match for row " + id), fields.get("L"), (Object)rs.getString(8));
                            BlobRef hadoopBlob = (BlobRef)fields.get("B");
                            Blob oraBlob = rs.getBlob(3);
                            Assert.assertTrue((String)("Blob did not match for row " + id), (boolean)Arrays.equals((byte[])hadoopBlob.getData(), oraBlob.getBytes(1L, (int)oraBlob.length())));
                            Assert.assertEquals((String)("Char did not match for row " + id), fields.get("C"), (Object)rs.getString(4));
                            ClobRef hadoopClob = (ClobRef)fields.get("CL");
                            Clob oraClob = rs.getClob(5);
                            Assert.assertEquals((String)("Clob did not match for row " + id), (Object)hadoopClob.getData(), (Object)oraClob.getSubString(1L, (int)oraClob.length()));
                            Assert.assertEquals((String)("Date did not match for row " + id), fields.get("D"), (Object)rs.getString(6));
                            BigDecimal hadoopFloat = (BigDecimal)fields.get("F");
                            BigDecimal oraFloat = rs.getBigDecimal(7);
                            Assert.assertEquals((String)("Float did not match for row " + id), (Object)hadoopFloat, (Object)oraFloat);
                            Assert.assertEquals((String)("NChar did not match for row " + id), fields.get("NC"), (Object)rs.getString(9));
                            Assert.assertEquals((String)("NClob did not match for row " + id), fields.get("NCL"), (Object)rs.getString(10));
                            Assert.assertEquals((String)("NVarChar did not match for row " + id), fields.get("NVC"), (Object)rs.getString(11));
                            Assert.assertEquals((String)("RowId did not match for row " + id), fields.get("R"), (Object)new String(rs.getRowId(12).getBytes()));
                            Struct url = (Struct)rs.getObject(13);
                            String urlString = (String)url.getAttributes()[0];
                            if (url.getSQLTypeName().equals("SYS.HTTPURITYPE")) {
                                urlString = "http://" + urlString;
                            } else if (url.getSQLTypeName().equals("SYS.DBURITYPE")) {
                                urlString = "/ORADB" + urlString;
                            }
                            Assert.assertEquals((String)("UriType did not match for row " + id), fields.get("U"), (Object)urlString);
                            Assert.assertEquals((String)("Interval Year to Month did not match for row " + id), fields.get("IYM"), (Object)rs.getString(14));
                            String ids = (String)fields.get("IDS");
                            int lastNonZero = ids.length() - 1;
                            while (ids.charAt(lastNonZero) == '0') {
                                --lastNonZero;
                            }
                            ids = ids.substring(0, lastNonZero + 1);
                            Assert.assertEquals((String)("Interval Day to Second did not match for row " + id), (Object)ids, (Object)rs.getString(15));
                            Assert.assertEquals((String)("Timestamp did not match for row " + id), fields.get("T"), (Object)rs.getString(16));
                            Assert.assertEquals((String)("Timestamp with Time Zone did not match for row " + id), fields.get("TZ"), (Object)rs.getString(17));
                            Assert.assertEquals((String)("Timestamp with Local Time Zone did not match for row " + id), fields.get("TLTZ"), (Object)rs.getString(18));
                            BytesWritable rawCol = (BytesWritable)fields.get("RAWCOL");
                            byte[] rawColData = Arrays.copyOf(rawCol.getBytes(), rawCol.getLength());
                            Assert.assertTrue((String)("RAW did not match for row " + id), (boolean)Arrays.equals(rawColData, rs.getBytes(19)));
                            Assert.assertFalse((String)("Found multiple rows with id " + id + " in oracle"), (boolean)rs.next());
                            ++hadoopRecordCount;
                        }
                        reader.close();
                    }
                    ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM oraoop_test");
                    rs.next();
                    int oracleRecordCount = rs.getInt(1);
                    Assert.assertEquals((String)"Number of records in Hadoop does not match number of records in oracle", (long)hadoopRecordCount, (long)oracleRecordCount);
                    rs.close();
                }
                finally {
                    this.cleanupFolders();
                }
            }
            finally {
                s.executeUpdate("DROP TABLE oraoop_test");
                s.close();
            }
        }
        finally {
            this.closeTestEnvConnection();
        }
    }

    static {
        try {
            preparedStatementClass = Class.forName("oracle.jdbc.OraclePreparedStatement");
            methSetBinaryDouble = preparedStatementClass.getMethod("setBinaryDouble", Integer.TYPE, Double.TYPE);
            methSetBinaryFloat = preparedStatementClass.getMethod("setBinaryFloat", Integer.TYPE, Float.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem getting Oracle JDBC methods via reflection.", e);
        }
    }
}

