/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.cubrid;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.CubridManager;
import org.apache.sqoop.manager.cubrid.CubridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CubridAuthTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)CubridAuthTest.class.getName());
    static final String TABLE_NAME = "employees_cubrid";
    private CubridManager manager;
    private Configuration conf = new Configuration();

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        LOG.debug((Object)("Setting up another CubridImport test: " + CubridTestUtils.getConnectString()));
        this.setUpData(TABLE_NAME, true);
        LOG.debug((Object)"setUp complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpData(String tableName, boolean nullEntry) {
        SqoopOptions options = new SqoopOptions(CubridTestUtils.getConnectString(), TABLE_NAME);
        options.setUsername(CubridTestUtils.getCurrentUser());
        options.setPassword(CubridTestUtils.getPassword());
        LOG.debug((Object)("Setting up another CubridImport test: " + CubridTestUtils.getConnectString()));
        this.manager = new CubridManager(options);
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS employees_cubrid");
            String sqlStmt = "CREATE TABLE employees_cubrid (" + this.manager.escapeColName("id") + " INT NOT NULL PRIMARY KEY, " + this.manager.escapeColName("name") + " VARCHAR(24) NOT NULL);";
            st.executeUpdate(sqlStmt);
            st.executeUpdate("INSERT INTO employees_cubrid VALUES(1,'Aaron');");
            connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            CubridAuthTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            CubridAuthTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testAuthAccess() throws IOException {
        SqoopOptions options = new SqoopOptions(this.conf);
        options.setConnectString(CubridTestUtils.getConnectString());
        options.setUsername(CubridTestUtils.getCurrentUser());
        options.setPassword(CubridTestUtils.getPassword());
        CubridManager mgr = new CubridManager(options);
        Object[] tables = mgr.listTables();
        Arrays.sort(tables);
        CubridAuthTest.assertTrue((String)"employees_cubrid is not found!", (Arrays.binarySearch(tables, TABLE_NAME) >= 0 ? 1 : 0) != 0);
    }
}

