/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hcat;

import com.cloudera.sqoop.testutil.ExportJobTestCase;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.sqoop.hcat.HCatalogTestUtils;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.junit.Before;

public class HCatalogExportTest
extends ExportJobTestCase {
    private static final Log LOG = LogFactory.getLog(HCatalogExportTest.class);
    private HCatalogTestUtils utils = HCatalogTestUtils.instance();

    @Override
    @Before
    public void setUp() {
        super.setUp();
        try {
            this.utils.initUtils();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing HCatTestUtilis", e);
        }
    }

    protected String[] getCodeGenArgv(String ... extraArgs) {
        ArrayList<String> codeGenArgv = new ArrayList<String>();
        if (null != extraArgs) {
            for (String arg : extraArgs) {
                codeGenArgv.add(arg);
            }
        }
        codeGenArgv.add("--table");
        codeGenArgv.add(this.getTableName());
        codeGenArgv.add("--connect");
        codeGenArgv.add(this.getConnectString());
        codeGenArgv.add("--hcatalog-table");
        codeGenArgv.add(this.getTableName());
        return codeGenArgv.toArray(new String[0]);
    }

    protected void assertColMinAndMax(String colName, HCatalogTestUtils.ColumnGenerator generator) throws SQLException {
        Connection conn = this.getConnection();
        int minId = this.getMinRowId(conn);
        int maxId = this.getMaxRowId(conn);
        String table = this.getTableName();
        LOG.info((Object)("Checking min/max for column " + colName + " with type " + SqoopHCatUtilities.sqlTypeString((int)generator.getSqlType())));
        Object expectedMin = generator.getDBValue(minId);
        Object expectedMax = generator.getDBValue(maxId);
        this.utils.assertSqlColValForRowId(conn, table, minId, colName, expectedMin);
        this.utils.assertSqlColValForRowId(conn, table, maxId, colName, expectedMax);
    }

    protected void runHCatExport(List<String> addlArgsArray, int totalRecords, String table, HCatalogTestUtils.ColumnGenerator[] cols) throws Exception {
        this.utils.createHCatTable(HCatalogTestUtils.CreateMode.CREATE_AND_LOAD, totalRecords, table, cols);
        this.utils.createSqlTable(this.getConnection(), true, totalRecords, table, cols);
        Map<String, String> addlArgsMap = this.utils.getAddlTestArgs();
        addlArgsArray.add("--verbose");
        addlArgsArray.add("-m");
        addlArgsArray.add("1");
        addlArgsArray.add("--hcatalog-table");
        addlArgsArray.add(table);
        String[] argv = new String[]{};
        if (addlArgsMap.containsKey("-libjars")) {
            argv = new String[]{"-libjars", addlArgsMap.get("-libjars")};
        }
        for (String k : addlArgsMap.keySet()) {
            if (k.equals("-libjars")) continue;
            addlArgsArray.add(k);
            addlArgsArray.add(addlArgsMap.get(k));
        }
        Object[] exportArgs = this.getArgv(true, 10, 10, this.newStrArray(argv, addlArgsArray.toArray(new String[0])));
        LOG.debug((Object)("Export args = " + Arrays.toString(exportArgs)));
        SqoopHCatUtilities.instance().setConfigured(false);
        this.runExport((String[])exportArgs);
        this.verifyExport(totalRecords);
        for (int i = 0; i < cols.length; ++i) {
            this.assertColMinAndMax(HCatalogTestUtils.forIdx(i), cols[i]);
        }
    }

    public void testIntTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "boolean", 16, HCatFieldSchema.Type.BOOLEAN, 0, 0, Boolean.TRUE, Boolean.TRUE, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "tinyint", 4, HCatFieldSchema.Type.INT, 0, 0, 10, 10, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "smallint", 4, HCatFieldSchema.Type.INT, 0, 0, 100, 100, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(3), "int", 4, HCatFieldSchema.Type.INT, 0, 0, 1000, 1000, HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(4), "bigint", -5, HCatFieldSchema.Type.BIGINT, 0, 0, 10000L, 10000L, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testFloatTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "float", 6, HCatFieldSchema.Type.FLOAT, 0, 0, Float.valueOf(10.0f), Float.valueOf(10.0f), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "real", 6, HCatFieldSchema.Type.FLOAT, 0, 0, Float.valueOf(20.0f), Float.valueOf(20.0f), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "double", 8, HCatFieldSchema.Type.DOUBLE, 0, 0, 30.0, 30.0, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testNumberTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "numeric(18,2)", 2, HCatFieldSchema.Type.STRING, 0, 0, "1000", new BigDecimal("1000"), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "decimal(18,2)", 3, HCatFieldSchema.Type.STRING, 0, 0, "2000", new BigDecimal("2000"), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "decimal(18,2)", 3, HCatFieldSchema.Type.DECIMAL, 18, 2, HiveDecimal.create((BigDecimal)new BigDecimal("2000")), new BigDecimal("2000"), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testDateTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "date", 91, HCatFieldSchema.Type.STRING, 0, 0, "2013-12-31", new Date(113, 11, 31), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "date", 91, HCatFieldSchema.Type.DATE, 0, 0, new Date(113, 11, 31), new Date(113, 11, 31), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "time", 92, HCatFieldSchema.Type.STRING, 0, 0, "10:11:12", new Time(10, 11, 12), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(3), "timestamp", 93, HCatFieldSchema.Type.STRING, 0, 0, "2013-12-31 10:11:12", new Timestamp(113, 11, 31, 10, 11, 12, 0), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(4), "timestamp", 93, HCatFieldSchema.Type.TIMESTAMP, 0, 0, new Timestamp(113, 11, 31, 10, 11, 12, 0), new Timestamp(113, 11, 31, 10, 11, 12, 0), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testDateTypesToBigInt() throws Exception {
        int TOTAL_RECORDS = 10;
        long offset = TimeZone.getDefault().getRawOffset();
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "date", 91, HCatFieldSchema.Type.BIGINT, 0, 0, 0L - offset, new Date(70, 0, 1), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "time", 92, HCatFieldSchema.Type.BIGINT, 0, 0, 36672000L - offset, new Time(10, 11, 12), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "timestamp", 93, HCatFieldSchema.Type.BIGINT, 0, 0, 36672000L - offset, new Timestamp(70, 0, 1, 10, 11, 12, 0), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--map-column-hive");
        addlArgsArray.add("COL0=bigint,COL1=bigint,COL2=bigint");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testStringTypes() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "char(14)", 1, HCatFieldSchema.Type.STRING, 0, 0, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "char(14)", 1, HCatFieldSchema.Type.CHAR, 14, 0, new HiveChar("string to test", 14), "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "char(14)", 1, HCatFieldSchema.Type.VARCHAR, 14, 0, new HiveVarchar("string to test", 14), "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(3), "longvarchar", -1, HCatFieldSchema.Type.STRING, 0, 0, "string to test", "string to test", HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testBinaryTypes() throws Exception {
        ByteBuffer bb = ByteBuffer.wrap(new byte[]{0, 1, 2});
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "binary(10)", -2, HCatFieldSchema.Type.BINARY, 0, 0, bb.array(), bb.array(), HCatalogTestUtils.KeyType.NOT_A_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varbinary(10)", -2, HCatFieldSchema.Type.BINARY, 0, 0, bb.array(), bb.array(), HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testColumnProjection() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", null, HCatalogTestUtils.KeyType.NOT_A_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--columns");
        addlArgsArray.add("ID,MSG");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testStaticPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testStaticPartitioningWithMultipleKeys() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "2", "2", HCatalogTestUtils.KeyType.STATIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hcatalog-partition-keys");
        addlArgsArray.add("col0,col1");
        addlArgsArray.add("--hcatalog-partition-values");
        addlArgsArray.add("1,2");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testDynamicPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testStaticAndDynamicPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testMultipleStaticKeysAndDynamicPartitioning() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "2", "2", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(2), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "3", "3", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hcatalog-partition-keys");
        addlArgsArray.add("col0,col1");
        addlArgsArray.add("--hcatalog-partition-values");
        addlArgsArray.add("1,2");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testSequenceFile() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.utils.setStorageInfo("stored as\n\tsequencefile\n");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }

    public void testTextFile() throws Exception {
        int TOTAL_RECORDS = 10;
        String table = this.getTableName().toUpperCase();
        HCatalogTestUtils.ColumnGenerator[] cols = new HCatalogTestUtils.ColumnGenerator[]{HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(0), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "1", "1", HCatalogTestUtils.KeyType.STATIC_KEY), HCatalogTestUtils.colGenerator(HCatalogTestUtils.forIdx(1), "varchar(20)", 12, HCatFieldSchema.Type.STRING, 0, 0, "2", "2", HCatalogTestUtils.KeyType.DYNAMIC_KEY)};
        ArrayList<String> addlArgsArray = new ArrayList<String>();
        addlArgsArray.add("--hive-partition-key");
        addlArgsArray.add("col0");
        addlArgsArray.add("--hive-partition-value");
        addlArgsArray.add("1");
        this.utils.setStorageInfo("stored as\n\ttextfile\n");
        this.runHCatExport(addlArgsArray, 10, table, cols);
    }
}

