/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.metastore;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.HsqldbManager;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.metastore.JobStorage;
import com.cloudera.sqoop.metastore.JobStorageFactory;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.tool.VersionTool;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;

public class TestSavedJobs
extends TestCase {
    public static final String TEST_AUTOCONNECT_URL = "jdbc:hsqldb:mem:sqoopmetastore";
    public static final String TEST_AUTOCONNECT_USER = "SA";
    public static final String TEST_AUTOCONNECT_PASS = "";

    public void setUp() throws Exception {
        TestSavedJobs.resetJobSchema();
    }

    public static void resetJobSchema() throws SQLException {
        SqoopOptions options = new SqoopOptions();
        options.setConnectString(TEST_AUTOCONNECT_URL);
        options.setUsername(TEST_AUTOCONNECT_USER);
        options.setPassword(TEST_AUTOCONNECT_PASS);
        TestSavedJobs.resetSchema(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetSchema(SqoopOptions options) throws SQLException {
        HsqldbManager manager = new HsqldbManager(options);
        Connection c = manager.getConnection();
        Statement s = c.createStatement();
        try {
            String[] tables;
            for (String table : tables = manager.listTables()) {
                s.executeUpdate("DROP TABLE " + manager.escapeTableName(table));
            }
            c.commit();
        }
        finally {
            s.close();
        }
    }

    public static Configuration newConf() {
        Configuration conf = new Configuration();
        conf.set("sqoop.metastore.client.autoconnect.username", TEST_AUTOCONNECT_USER);
        conf.set("sqoop.metastore.client.autoconnect.password", TEST_AUTOCONNECT_PASS);
        conf.set("sqoop.metastore.client.autoconnect.url", TEST_AUTOCONNECT_URL);
        return conf;
    }

    public void testAutoConnect() throws IOException {
        Configuration conf = TestSavedJobs.newConf();
        JobStorageFactory ssf = new JobStorageFactory(conf);
        TreeMap descriptor = new TreeMap();
        JobStorage storage = ssf.getJobStorage(descriptor);
        storage.open(descriptor);
        List jobs = storage.list();
        TestSavedJobs.assertEquals((int)0, (int)jobs.size());
        storage.close();
    }

    public void testCreateDeleteJob() throws IOException {
        Configuration conf = TestSavedJobs.newConf();
        JobStorageFactory ssf = new JobStorageFactory(conf);
        TreeMap descriptor = new TreeMap();
        JobStorage storage = ssf.getJobStorage(descriptor);
        storage.open(descriptor);
        List jobs = storage.list();
        TestSavedJobs.assertEquals((int)0, (int)jobs.size());
        JobData data = new JobData(new SqoopOptions(), (SqoopTool)new VersionTool());
        storage.create("versionJob", data);
        jobs = storage.list();
        TestSavedJobs.assertEquals((int)1, (int)jobs.size());
        TestSavedJobs.assertEquals((String)"versionJob", (String)((String)jobs.get(0)));
        try {
            storage.create("versionJob", data);
            TestSavedJobs.fail((String)"Expected IOException; this job already exists.");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        jobs = storage.list();
        TestSavedJobs.assertEquals((int)1, (int)jobs.size());
        JobData outData = storage.read("versionJob");
        TestSavedJobs.assertEquals((String)new VersionTool().getToolName(), (String)outData.getSqoopTool().getToolName());
        try {
            storage.read("DoesNotExist");
            TestSavedJobs.fail((String)"Expected IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        storage.delete("versionJob");
        jobs = storage.list();
        TestSavedJobs.assertEquals((int)0, (int)jobs.size());
        storage.close();
    }

    public void testMultiConnections() throws IOException {
        Configuration conf = TestSavedJobs.newConf();
        JobStorageFactory ssf = new JobStorageFactory(conf);
        TreeMap descriptor = new TreeMap();
        JobStorage storage = ssf.getJobStorage(descriptor);
        storage.open(descriptor);
        List jobs = storage.list();
        TestSavedJobs.assertEquals((int)0, (int)jobs.size());
        JobData data = new JobData(new SqoopOptions(), (SqoopTool)new VersionTool());
        storage.create("versionJob", data);
        jobs = storage.list();
        TestSavedJobs.assertEquals((int)1, (int)jobs.size());
        TestSavedJobs.assertEquals((String)"versionJob", (String)((String)jobs.get(0)));
        storage.close();
        ssf = new JobStorageFactory(TestSavedJobs.newConf());
        storage = ssf.getJobStorage(descriptor);
        storage.open(descriptor);
        jobs = storage.list();
        TestSavedJobs.assertEquals((int)1, (int)jobs.size());
        TestSavedJobs.assertEquals((String)"versionJob", (String)((String)jobs.get(0)));
        JobData outData = storage.read("versionJob");
        TestSavedJobs.assertEquals((String)new VersionTool().getToolName(), (String)outData.getSqoopTool().getToolName());
        storage.close();
    }
}

