/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.sqoop.manager.CubridManager;
import org.apache.sqoop.manager.cubrid.CubridTestUtils;
import org.apache.sqoop.util.FileListing;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CubridManagerImportTest
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)CubridManagerImportTest.class.getName());
    static final String TABLE_NAME = "employees_cubrid";
    static final String NULL_TABLE_NAME = "null_employees_cubrid";
    private CubridManager manager;
    private Configuration conf = new Configuration();

    @Override
    protected Configuration getConf() {
        return this.conf;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        LOG.debug((Object)("Setting up another CubridImport test: " + CubridTestUtils.getConnectString()));
        this.setUpData(TABLE_NAME, false);
        this.setUpData(NULL_TABLE_NAME, true);
        LOG.debug((Object)"setUp complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpData(String tableName, boolean nullEntry) {
        SqoopOptions options = new SqoopOptions(CubridTestUtils.getConnectString(), tableName);
        options.setUsername(CubridTestUtils.getCurrentUser());
        options.setPassword(CubridTestUtils.getPassword());
        LOG.debug((Object)("Setting up another CubridImport test: " + CubridTestUtils.getConnectString()));
        this.manager = new CubridManager(options);
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.manager.getConnection();
            connection.setAutoCommit(false);
            st = connection.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS " + tableName);
            st.executeUpdate("CREATE TABLE " + tableName + " (" + this.manager.escapeColName("id") + " INT NOT NULL PRIMARY KEY, " + this.manager.escapeColName("name") + " VARCHAR(24) NOT NULL, " + this.manager.escapeColName("start_date") + " DATE, " + this.manager.escapeColName("Salary") + " FLOAT, " + this.manager.escapeColName("dept") + " VARCHAR(32));");
            st.executeUpdate("INSERT INTO " + tableName + " VALUES(1,'Aaron','2009-05-14'," + "1000000.00,'engineering');");
            st.executeUpdate("INSERT INTO " + tableName + " VALUES(2,'Bob','2009-04-20',400.00,'sales');");
            st.executeUpdate("INSERT INTO " + tableName + " VALUES(3,'Fred','2009-01-23'," + "15.00,'marketing');");
            if (nullEntry) {
                st.executeUpdate("INSERT INTO " + tableName + " VALUES(4,'Mike',NULL,NULL,NULL);");
            }
            connection.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Encountered SQL Exception: " + sqlE));
            sqlE.printStackTrace();
            CubridManagerImportTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (SQLException sqlE) {
                LOG.warn((Object)("Got SQLException when closing connection: " + sqlE));
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            CubridManagerImportTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testImportSimple() throws IOException {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14,1000000.0,engineering", "2,Bob,2009-04-20,400.0,sales", "3,Fred,2009-01-23,15.0,marketing"};
        this.doImportAndVerify(TABLE_NAME, expectedResults, new String[0]);
    }

    @Test
    public void testListTables() throws IOException {
        SqoopOptions options = new SqoopOptions(new Configuration());
        options.setConnectString(CubridTestUtils.getConnectString());
        options.setUsername(CubridTestUtils.getCurrentUser());
        options.setPassword(CubridTestUtils.getPassword());
        CubridManager mgr = new CubridManager(options);
        Object[] tables = mgr.listTables();
        Arrays.sort(tables);
        CubridManagerImportTest.assertTrue((String)"employees_cubrid is not found!", (Arrays.binarySearch(tables, TABLE_NAME) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNullEscapeCharacters() throws Exception {
        String[] expectedResults = new String[]{"1,Aaron,2009-05-14,1000000.0,engineering", "2,Bob,2009-04-20,400.0,sales", "3,Fred,2009-01-23,15.0,marketing", "4,Mike,cubrid,cubrid,cubrid"};
        String[] extraArgs = new String[]{"--null-string", "cubrid", "--null-non-string", "cubrid"};
        this.doImportAndVerify(NULL_TABLE_NAME, expectedResults, extraArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportAndVerify(String tableName, String[] expectedResults, String ... extraArgs) throws IOException {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, tableName);
        Path filePath = new Path(tablePath, "part-m-00000");
        File tableFile = new File(tablePath.toString());
        if (tableFile.exists() && tableFile.isDirectory()) {
            FileListing.recursiveDeleteDir((File)tableFile);
        }
        String[] argv = this.getArgv(tableName, extraArgs);
        try {
            this.runImport(argv);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Got IOException during import: " + ioe.toString()));
            ioe.printStackTrace();
            CubridManagerImportTest.fail((String)ioe.toString());
        }
        File f = new File(filePath.toString());
        CubridManagerImportTest.assertTrue((String)"Could not find imported data file", (boolean)f.exists());
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            for (String expectedLine : expectedResults) {
                CubridManagerImportTest.assertEquals((String)expectedLine, (String)r.readLine());
            }
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Got IOException verifying results: " + ioe.toString()));
                ioe.printStackTrace();
                CubridManagerImportTest.fail((String)ioe.toString());
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(r);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)r);
        }
        IOUtils.closeStream((Closeable)r);
    }

    private String[] getArgv(String tableName, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(tableName);
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(CubridTestUtils.getConnectString());
        args.add("--username");
        args.add(CubridTestUtils.getCurrentUser());
        args.add("--password");
        args.add(CubridTestUtils.getPassword());
        args.add("--num-mappers");
        args.add("1");
        if (extraArgs.length > 0) {
            for (String arg : extraArgs) {
                args.add(arg);
            }
        }
        return args.toArray(new String[0]);
    }
}

