/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.hbase;

import com.cloudera.sqoop.hbase.HBaseTestCase;
import com.cloudera.sqoop.hbase.HBaseUtil;
import java.io.IOException;
import org.junit.Test;

public class HBaseImportTest
extends HBaseTestCase {
    @Test
    public void testBasicUsage() throws IOException {
        String[] argv = this.getArgv(true, "BasicUsage", "BasicColFam", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("BasicUsage", "0", "BasicColFam", this.getColName(1), "1");
    }

    @Test
    public void testMissingTableFails() throws IOException {
        String[] argv = this.getArgv(true, "MissingTable", "MissingFam", false, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        try {
            this.runImport(argv);
            HBaseImportTest.fail((String)"Expected IOException");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Got exception -- ok; we expected that job to fail.");
        }
    }

    @Test
    public void testOverwriteSucceeds() throws IOException {
        String[] argv = this.getArgv(true, "OverwriteT", "OverwriteF", true, null);
        String[] types = new String[]{"INT", "INT"};
        String[] vals = new String[]{"0", "1"};
        this.createTableWithColTypes(types, vals);
        this.runImport(argv);
        this.verifyHBaseCell("OverwriteT", "0", "OverwriteF", this.getColName(1), "1");
        this.runImport(argv);
        this.verifyHBaseCell("OverwriteT", "0", "OverwriteF", this.getColName(1), "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitFailure() throws IOException {
        String[] types = new String[]{"INT", "INT", "INT"};
        String[] vals = new String[]{"0", "42", "43"};
        this.createTableWithColTypes(types, vals);
        String[] argv = this.getArgv(true, "NoHBaseT", "NoHBaseF", true, null);
        try {
            HBaseUtil.setAlwaysNoHBaseJarMode((boolean)true);
            this.runImport(argv);
        }
        catch (IOException e) {
            return;
        }
        finally {
            HBaseUtil.setAlwaysNoHBaseJarMode((boolean)false);
        }
        HBaseImportTest.fail((String)"should have gotten exception");
    }
}

