/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.ExportJobTestCase;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.junit.Assert;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetWriter;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.Formats;

public class TestParquetExport
extends ExportJobTestCase {
    protected String[] getCodeGenArgv(String ... extraArgs) {
        ArrayList<String> codeGenArgv = new ArrayList<String>();
        if (null != extraArgs) {
            for (String arg : extraArgs) {
                codeGenArgv.add(arg);
            }
        }
        codeGenArgv.add("--table");
        codeGenArgv.add(this.getTableName());
        codeGenArgv.add("--connect");
        codeGenArgv.add(this.getConnectString());
        return codeGenArgv.toArray(new String[0]);
    }

    private ColumnGenerator colGenerator(final Object exportValue, final Schema schema, final Object verifyValue, final String columnType) {
        return new ColumnGenerator(){

            @Override
            public Object getVerifyValue(int rowNum) {
                return verifyValue;
            }

            @Override
            public Object getExportValue(int rowNum) {
                return exportValue;
            }

            @Override
            public String getColumnType() {
                return columnType;
            }

            @Override
            public Schema getColumnParquetSchema() {
                return schema;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createParquetFile(int fileNum, int numRecords, ColumnGenerator ... extraCols) throws IOException {
        String uri = "dataset:file:" + this.getTablePath();
        Schema schema = this.buildSchema(extraCols);
        DatasetDescriptor descriptor = new DatasetDescriptor.Builder().schema(schema).format(Formats.PARQUET).build();
        Dataset dataset = (Dataset)Datasets.create((String)uri, (DatasetDescriptor)descriptor);
        DatasetWriter writer = dataset.newWriter();
        try {
            for (int i = 0; i < numRecords; ++i) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put("id", (Object)i);
                record.put("msg", (Object)(this.getMsgPrefix() + i));
                this.addExtraColumns((GenericRecord)record, i, extraCols);
                writer.write((Object)record);
            }
        }
        finally {
            writer.close();
        }
    }

    private Schema buildSchema(ColumnGenerator ... extraCols) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(this.buildField("id", Schema.Type.INT));
        fields.add(this.buildField("msg", Schema.Type.STRING));
        int colNum = 0;
        for (ColumnGenerator gen : extraCols) {
            if (gen.getColumnParquetSchema() == null) continue;
            fields.add(this.buildParquetField(this.forIdx(colNum++), gen.getColumnParquetSchema()));
        }
        Schema schema = Schema.createRecord((String)"myschema", null, null, (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    private void addExtraColumns(GenericRecord record, int rowNum, ColumnGenerator[] extraCols) {
        int colNum = 0;
        for (ColumnGenerator gen : extraCols) {
            if (gen.getColumnParquetSchema() == null) continue;
            record.put(this.forIdx(colNum++), gen.getExportValue(rowNum));
        }
    }

    private Schema.Field buildField(String name, Schema.Type type) {
        return new Schema.Field(name, Schema.create((Schema.Type)type), null, null);
    }

    private Schema.Field buildParquetField(String name, Schema schema) {
        return new Schema.Field(name, schema, null, null);
    }

    protected String forIdx(int idx) {
        return "col" + idx;
    }

    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE " + tableName + " IF EXISTS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(ColumnGenerator ... extraColumns) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement(this.getDropTableStatement(this.getTableName()), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getTableName());
        sb.append(" (id INT NOT NULL PRIMARY KEY, msg VARCHAR(64)");
        int colNum = 0;
        for (ColumnGenerator gen : extraColumns) {
            if (gen.getColumnType() == null) continue;
            sb.append(", " + this.forIdx(colNum++) + " " + gen.getColumnType());
        }
        sb.append(")");
        statement = conn.prepareStatement(sb.toString(), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertColValForRowId(int id, String colName, Object expectedVal) throws SQLException {
        Connection conn = this.getConnection();
        LOG.info((Object)("Verifying column " + colName + " has value " + expectedVal));
        PreparedStatement statement = conn.prepareStatement("SELECT " + colName + " FROM " + this.getTableName() + " WHERE id = " + id, 1003, 1007);
        Object actualVal = null;
        try {
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                actualVal = rs.getObject(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        if (expectedVal != null && expectedVal instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expectedVal), (byte[])((byte[])actualVal));
        } else {
            TestParquetExport.assertEquals((String)"Got unexpected column value", (Object)expectedVal, (Object)actualVal);
        }
    }

    protected void assertColMinAndMax(String colName, ColumnGenerator generator) throws SQLException {
        Connection conn = this.getConnection();
        int minId = this.getMinRowId(conn);
        int maxId = this.getMaxRowId(conn);
        LOG.info((Object)("Checking min/max for column " + colName + " with type " + generator.getColumnType()));
        Object expectedMin = generator.getVerifyValue(minId);
        Object expectedMax = generator.getVerifyValue(maxId);
        this.assertColValForRowId(minId, colName, expectedMin);
        this.assertColValForRowId(maxId, colName, expectedMax);
    }

    public void testSupportedParquetTypes() throws IOException, SQLException {
        String[] argv = new String[]{};
        int TOTAL_RECORDS = 10;
        byte[] b = new byte[]{1, 2};
        Schema fixed = Schema.createFixed((String)"myfixed", null, null, (int)2);
        Schema enumeration = Schema.createEnum((String)"myenum", null, null, (List)Lists.newArrayList((Object[])new String[]{"a", "b"}));
        ColumnGenerator[] gens = new ColumnGenerator[]{this.colGenerator(true, Schema.create((Schema.Type)Schema.Type.BOOLEAN), true, "BIT"), this.colGenerator(100, Schema.create((Schema.Type)Schema.Type.INT), 100, "INTEGER"), this.colGenerator(200L, Schema.create((Schema.Type)Schema.Type.LONG), 200L, "BIGINT"), this.colGenerator(Float.valueOf(1.0f), Schema.create((Schema.Type)Schema.Type.FLOAT), 1.0, "REAL"), this.colGenerator(2.0, Schema.create((Schema.Type)Schema.Type.DOUBLE), 2.0, "DOUBLE"), this.colGenerator("s", Schema.create((Schema.Type)Schema.Type.STRING), "s", "VARCHAR(8)"), this.colGenerator(ByteBuffer.wrap(b), Schema.create((Schema.Type)Schema.Type.BYTES), b, "VARBINARY(8)"), this.colGenerator(new GenericData.Fixed(fixed, b), fixed, b, "BINARY(2)"), this.colGenerator(new GenericData.EnumSymbol(enumeration, "a"), enumeration, "a", "VARCHAR(8)")};
        this.createParquetFile(0, 10, gens);
        this.createTable(gens);
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(argv, "-m", "1")));
        this.verifyExport(10);
        for (int i = 0; i < gens.length; ++i) {
            this.assertColMinAndMax(this.forIdx(i), gens[i]);
        }
    }

    public void testNullableField() throws IOException, SQLException {
        String[] argv = new String[]{};
        int TOTAL_RECORDS = 10;
        ArrayList<Schema> childSchemas = new ArrayList<Schema>();
        childSchemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        childSchemas.add(Schema.create((Schema.Type)Schema.Type.STRING));
        Schema schema = Schema.createUnion(childSchemas);
        ColumnGenerator gen0 = this.colGenerator(null, schema, null, "VARCHAR(64)");
        ColumnGenerator gen1 = this.colGenerator("s", schema, "s", "VARCHAR(64)");
        this.createParquetFile(0, 10, gen0, gen1);
        this.createTable(gen0, gen1);
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(argv, "-m", "1")));
        this.verifyExport(10);
        this.assertColMinAndMax(this.forIdx(0), gen0);
        this.assertColMinAndMax(this.forIdx(1), gen1);
    }

    public void testParquetRecordsNotSupported() throws IOException, SQLException {
        String[] argv = new String[]{};
        boolean TOTAL_RECORDS = true;
        Schema schema = Schema.createRecord((String)"nestedrecord", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{this.buildField("myint", Schema.Type.INT)}));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("myint", (Object)100);
        ColumnGenerator gen = this.colGenerator(record, schema, null, "VARCHAR(64)");
        this.createParquetFile(0, 1, gen);
        this.createTable(gen);
        try {
            this.runExport(this.getArgv(true, 10, 10, this.newStrArray(argv, "-m", "1")));
            TestParquetExport.fail((String)"Parquet records can not be exported.");
        }
        catch (Exception e) {
            TestParquetExport.assertTrue((boolean)true);
        }
    }

    public void testMissingDatabaseFields() throws IOException, SQLException {
        String[] argv = new String[]{};
        boolean TOTAL_RECORDS = true;
        ColumnGenerator gen = this.colGenerator(100, Schema.create((Schema.Type)Schema.Type.INT), null, null);
        this.createParquetFile(0, 1, gen);
        this.createTable(gen);
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(argv, "-m", "1")));
        this.verifyExport(1);
    }

    public void testMissingParquetFields() throws IOException, SQLException {
        String[] argv = new String[]{};
        boolean TOTAL_RECORDS = true;
        ColumnGenerator gen = this.colGenerator(null, null, null, "VARCHAR(64)");
        this.createParquetFile(0, 1, gen);
        this.createTable(gen);
        try {
            this.runExport(this.getArgv(true, 10, 10, this.newStrArray(argv, "-m", "1")));
            TestParquetExport.fail((String)"Missing Parquet field.");
        }
        catch (Exception e) {
            TestParquetExport.assertTrue((boolean)true);
        }
    }

    public static interface ColumnGenerator {
        public Object getExportValue(int var1);

        public Schema getColumnParquetSchema();

        public Object getVerifyValue(int var1);

        public String getColumnType();
    }
}

