/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.util.ReflectionUtils;

public class TestBoundaryQuery
extends ImportJobTestCase {
    protected String[] getArgv(boolean includeHadoopFlags, boolean tableImport, String boundaryQuery, String targetDir, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        if (tableImport) {
            args.add("--table");
            args.add(HsqldbTestServer.getTableName());
        } else {
            args.add("--query");
            args.add("SELECT INTFIELD1, INTFIELD2 FROM " + HsqldbTestServer.getTableName() + " WHERE $CONDITIONS");
        }
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        if (boundaryQuery != null) {
            args.add("--boundary-query");
            args.add(boundaryQuery);
        }
        args.add("--as-sequencefile");
        args.add("--target-dir");
        args.add(targetDir);
        args.add("--class-name");
        args.add(this.getTableName());
        args.add("--verbose");
        for (String extraArg : extraArgs) {
            args.add(extraArg);
        }
        return args.toArray(new String[0]);
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    private int getFirstInt(String str) {
        String[] parts = str.split(",");
        return Integer.parseInt(parts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runQueryTest(String query, boolean tableImport, int numExpectedResults, int expectedSum, String targetDir, String ... extraArgs) throws IOException {
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, tableImport, query, targetDir, extraArgs);
        this.runImport(argv);
        try {
            SqoopOptions opts = new ImportTool().parseArguments(this.getArgv(false, tableImport, query, targetDir, extraArgs), null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            reader = SeqFileReader.getSeqFileReader(this.getDataFilePath().toString());
            Configuration conf = new Configuration();
            Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            if (reader.next(key) == null) {
                TestBoundaryQuery.fail((String)"Empty SequenceFile during import");
            }
            reader.getCurrentValue(val);
            int curSum = this.getFirstInt(val.toString());
            int totalResults = 1;
            while (reader.next(key) != null) {
                reader.getCurrentValue(val);
                curSum += this.getFirstInt(val.toString());
                ++totalResults;
            }
            TestBoundaryQuery.assertEquals((String)"Total sum of first db column mismatch", (int)expectedSum, (int)curSum);
            TestBoundaryQuery.assertEquals((String)"Incorrect number of results for query", (int)numExpectedResults, (int)totalResults);
            IOUtils.closeStream((Closeable)reader);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            TestBoundaryQuery.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            TestBoundaryQuery.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testBoundaryQuery() throws IOException {
        System.out.println("PCYO");
        String query = "select min(intfield1), max(intfield1) from " + this.getTableName() + " where intfield1 in (3, 5)";
        this.runQueryTest(query, true, 2, 8, this.getTablePath().toString(), "--m", "1", "--split-by", "INTFIELD1");
    }

    public void testNoBoundaryQuerySingleMapper() throws IOException {
        this.runQueryTest(null, false, 4, 16, this.getTablePath().toString(), "--m", "1");
    }
}

