/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.hive.TestHiveImport;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.tool.SqoopTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;

public class SQLServerHiveImportManualTest
extends TestHiveImport {
    @Override
    public void setUp() {
        super.setUp();
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    @Override
    protected String[] getTypesNewLineTest() {
        String[] types = new String[]{"VARCHAR(32)", "INTEGER", "VARCHAR(64)"};
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opts;
    }

    SqoopOptions getSqoopOptions(String[] args, SqoopTool tool) {
        SqoopOptions opts = null;
        try {
            opts = tool.parseArguments(args, null, null, true);
            String username = MSSQLTestUtils.getDBUserName();
            String password = MSSQLTestUtils.getDBPassWord();
            opts.setUsername(username);
            opts.setPassword(password);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            SQLServerHiveImportManualTest.fail((String)("Invalid options: " + e.toString()));
        }
        return opts;
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, String[] moreArgs) {
        ArrayList<String> args = new ArrayList<String>();
        System.out.println("Ovverdien getArgv is called..");
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        if (null != moreArgs) {
            for (String arg : moreArgs) {
                args.add(arg);
            }
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--hive-import");
        String[] colNames = this.getColNames();
        if (null != colNames) {
            args.add("--split-by");
            args.add(colNames[0]);
        } else {
            SQLServerHiveImportManualTest.fail((String)"Could not determine column names.");
        }
        args.add("--num-mappers");
        args.add("1");
        for (String a : args) {
            LOG.debug((Object)("ARG : " + a));
        }
        return args.toArray(new String[0]);
    }

    @Override
    protected String[] getCodeGenArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--hive-import");
        return args.toArray(new String[0]);
    }
}

