/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import org.apache.sqoop.manager.oracle.util.OraOopTestDataGenerator;

public class BlobGenerator
extends OraOopTestDataGenerator<Blob> {
    private static Class<?> blobClass;
    private static Method methCreateTemporary;
    private static Method methGetBufferSize;
    private static int durationSession;
    private Connection conn;
    private int minBytes;
    private int maxBytes;

    public BlobGenerator(Connection conn, int minBytes, int maxBytes) {
        this.conn = conn;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
    }

    @Override
    public Blob next() {
        try {
            Blob blob = (Blob)methCreateTemporary.invoke(null, this.conn, false, durationSession);
            int blobSize = (int)(this.rng.nextDouble() * (double)(this.maxBytes - this.minBytes) + (double)this.minBytes);
            byte[] blobData = new byte[blobSize];
            this.rng.nextBytes(blobData);
            OutputStream os = blob.setBinaryStream(1L);
            ByteArrayInputStream is = new ByteArrayInputStream(blobData);
            int bufferSize = (Integer)methGetBufferSize.invoke((Object)blob, new Object[0]);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = 0;
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            ((InputStream)is).close();
            return blob;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            blobClass = Class.forName("oracle.sql.BLOB");
            methCreateTemporary = blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
            methGetBufferSize = blobClass.getMethod("getBufferSize", new Class[0]);
            durationSession = blobClass.getField("DURATION_SESSION").getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem getting Oracle JDBC methods via reflection.", e);
        }
    }
}

