/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.cubrid;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.ManagerCompatTestCase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.cubrid.CubridTestUtils;

public class CubridCompatTest
extends ManagerCompatTestCase {
    public static final Log LOG = LogFactory.getLog((String)CubridCompatTest.class.getName());

    @Override
    protected Log getLogger() {
        return LOG;
    }

    @Override
    protected String getDbFriendlyName() {
        return "CUBRID";
    }

    @Override
    protected String getConnectString() {
        return CubridTestUtils.getConnectString();
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(CubridTestUtils.getCurrentUser());
        opts.setPassword(CubridTestUtils.getPassword());
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement("DROP TABLE IF EXISTS " + table, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected boolean supportsBoolean() {
        return false;
    }

    @Override
    protected boolean supportsLongVarChar() {
        return false;
    }

    @Override
    protected String getFixedCharSeqOut(int fieldWidth, String asInserted) {
        return this.padString(fieldWidth, asInserted);
    }

    @Override
    protected String getTimestampSeqOutput(String tsAsInserted) {
        if ("null".equals(tsAsInserted)) {
            return tsAsInserted;
        }
        int dotPos = tsAsInserted.indexOf(".");
        if (-1 == dotPos) {
            return tsAsInserted + ".0";
        }
        return tsAsInserted.substring(0, dotPos + 2);
    }

    @Override
    protected String getVarBinaryType() {
        return "BIT VARYING(48)";
    }

    @Override
    protected String getVarBinarySeqOutput(String asInserted) {
        return this.toLowerHexString(asInserted);
    }

    @Override
    protected String getNumericSeqOutput(String numAsInserted) {
        int numPad;
        int totalDecPartSize = this.getNumericDecPartDigits();
        int dotPos = numAsInserted.indexOf(".");
        if (-1 == dotPos) {
            numAsInserted = numAsInserted + ".";
            numPad = totalDecPartSize;
        } else {
            int existingDecimalSize = numAsInserted.length() - dotPos;
            numPad = totalDecPartSize - existingDecimalSize;
        }
        if (numPad < 0) {
            return numAsInserted.substring(0, numAsInserted.length() + numPad + 1);
        }
        String zeros = "";
        for (int i = 0; i < numPad; ++i) {
            zeros = zeros + "0";
        }
        return numAsInserted + zeros;
    }

    @Override
    protected String getDecimalSeqOutput(String numAsInserted) {
        return this.getNumericSeqOutput(numAsInserted);
    }
}

