/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.ConnFactory;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.metastore.JobData;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.accumulo.AccumuloUtil;
import org.apache.sqoop.hbase.HBaseUtil;
import org.apache.sqoop.tool.MainframeImportTool;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMainframeManager
extends BaseSqoopTestCase {
    private static final Log LOG = LogFactory.getLog((String)TestMainframeManager.class.getName());
    private ConnManager manager;
    private SqoopOptions opts;
    private ImportJobContext context;

    @Override
    @Before
    public void setUp() {
        Configuration conf = this.getConf();
        this.opts = this.getSqoopOptions(conf);
        this.opts.setConnectString("dummy.server");
        this.opts.setTableName("dummy.pds");
        this.opts.setConnManagerClassName("org.apache.sqoop.manager.MainframeManager");
        this.context = new ImportJobContext(this.getTableName(), null, this.opts, null);
        ConnFactory f = new ConnFactory(conf);
        try {
            this.manager = f.getManager(new JobData(this.opts, (SqoopTool)new MainframeImportTool()));
        }
        catch (IOException ioe) {
            TestMainframeManager.fail((String)("IOException instantiating manager: " + StringUtils.stringifyException((Throwable)ioe)));
        }
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            TestMainframeManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testListColNames() {
        String[] colNames = this.manager.getColumnNames(this.getTableName());
        TestMainframeManager.assertNotNull((String)"manager should return a column list", (Object)colNames);
        TestMainframeManager.assertEquals((String)"Column list should be length 1", (int)1, (int)colNames.length);
        TestMainframeManager.assertEquals((String)"DEFAULT_COLUMN", (String)colNames[0]);
    }

    @Test
    public void testListColTypes() {
        Map types = this.manager.getColumnTypes(this.getTableName());
        TestMainframeManager.assertNotNull((String)"manager should return a column types map", (Object)types);
        TestMainframeManager.assertEquals((String)"Column types map should be size 1", (int)1, (int)types.size());
        TestMainframeManager.assertEquals((int)((Integer)types.get("DEFAULT_COLUMN")), (int)12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportTableNoHBaseJarPresent() {
        HBaseUtil.setAlwaysNoHBaseJarMode((boolean)true);
        this.opts.setHBaseTable("dummy_table");
        try {
            this.manager.importTable(this.context);
            TestMainframeManager.fail((String)"An ImportException should be thrown: HBase jars are not present in classpath, cannot import to HBase!");
        }
        catch (ImportException e) {
            TestMainframeManager.assertEquals((String)e.toString(), (String)"HBase jars are not present in classpath, cannot import to HBase!");
        }
        catch (IOException e) {
            TestMainframeManager.fail((String)"No IOException should be thrown!");
        }
        finally {
            this.opts.setHBaseTable(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportTableNoAccumuloJarPresent() {
        AccumuloUtil.setAlwaysNoAccumuloJarMode((boolean)true);
        this.opts.setAccumuloTable("dummy_table");
        try {
            this.manager.importTable(this.context);
            TestMainframeManager.fail((String)"An ImportException should be thrown: Accumulo jars are not present in classpath, cannot import to Accumulo!");
        }
        catch (ImportException e) {
            TestMainframeManager.assertEquals((String)e.toString(), (String)"Accumulo jars are not present in classpath, cannot import to Accumulo!");
        }
        catch (IOException e) {
            TestMainframeManager.fail((String)"No IOException should be thrown!");
        }
        finally {
            this.opts.setAccumuloTable(null);
        }
    }

    @Test
    public void testListTables() {
        String[] tables = this.manager.listTables();
        TestMainframeManager.assertNull((String)"manager should not return a list of tables", (Object)tables);
    }

    @Test
    public void testListDatabases() {
        String[] databases = this.manager.listDatabases();
        TestMainframeManager.assertNull((String)"manager should not return a list of databases", (Object)databases);
    }

    @Test
    public void testGetPrimaryKey() {
        String primaryKey = this.manager.getPrimaryKey(this.getTableName());
        TestMainframeManager.assertNull((String)"manager should not return a primary key", (Object)primaryKey);
    }

    @Test
    public void testReadTable() {
        String[] colNames = this.manager.getColumnNames(this.getTableName());
        try {
            ResultSet table = this.manager.readTable(this.getTableName(), colNames);
            TestMainframeManager.assertNull((String)"manager should not read a table", (Object)table);
        }
        catch (SQLException sqlE) {
            TestMainframeManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testGetConnection() {
        try {
            Connection con = this.manager.getConnection();
            TestMainframeManager.assertNull((String)"manager should not return a connection", (Object)con);
        }
        catch (SQLException sqlE) {
            TestMainframeManager.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Test
    public void testGetDriverClass() {
        String driverClass = this.manager.getDriverClass();
        TestMainframeManager.assertNotNull((String)"manager should return a driver class", (Object)driverClass);
        TestMainframeManager.assertEquals((String)"manager should return an empty driver class", (String)"", (String)driverClass);
    }
}

