/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hcat;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatInputFormat;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatUtilities;
import org.junit.Assert;

public final class HCatalogTestUtils {
    protected Configuration conf;
    private static List<HCatRecord> recsToLoad = new ArrayList<HCatRecord>();
    private static List<HCatRecord> recsRead = new ArrayList<HCatRecord>();
    private static final Log LOG = LogFactory.getLog(HCatalogTestUtils.class);
    private FileSystem fs;
    private final SqoopHCatUtilities utils = SqoopHCatUtilities.instance();
    private static final double DELTAVAL = 1.0E-10;
    public static final String SQOOP_HCATALOG_TEST_ARGS = "sqoop.hcatalog.test.args";
    private final boolean initialized = false;
    private static String storageInfo = null;
    public static final String STORED_AS_RCFILE = "stored as\n\trcfile\n";
    public static final String STORED_AS_SEQFILE = "stored as\n\tsequencefile\n";
    public static final String STORED_AS_TEXT = "stored as\n\ttextfile\n";

    private HCatalogTestUtils() {
    }

    public static HCatalogTestUtils instance() {
        return Holder.INSTANCE;
    }

    public static StringBuilder escHCatObj(String objectName) {
        return SqoopHCatUtilities.escHCatObj((String)objectName);
    }

    public void initUtils() throws IOException, MetaException {
        this.conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            this.conf.set("fs.defaultfs.name", "file:///");
        }
        this.fs = FileSystem.get((Configuration)this.conf);
        this.fs.initialize(this.fs.getWorkingDirectory().toUri(), this.conf);
        storageInfo = null;
        SqoopHCatUtilities.setTestMode((boolean)true);
    }

    public static String getStorageInfo() {
        if (null != storageInfo && storageInfo.length() > 0) {
            return storageInfo;
        }
        return STORED_AS_RCFILE;
    }

    public void setStorageInfo(String info) {
        storageInfo = info;
    }

    private static String getHCatDropTableCmd(String dbName, String tableName) {
        return "DROP TABLE IF EXISTS " + HCatalogTestUtils.escHCatObj(dbName.toLowerCase()) + "." + HCatalogTestUtils.escHCatObj(tableName.toLowerCase());
    }

    private static String getHCatCreateTableCmd(String dbName, String tableName, List<HCatFieldSchema> tableCols, List<HCatFieldSchema> partKeys) {
        HCatFieldSchema hfs;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("create table ").append((CharSequence)HCatalogTestUtils.escHCatObj(dbName.toLowerCase()).append('.'));
        sb.append((CharSequence)HCatalogTestUtils.escHCatObj(tableName.toLowerCase()).append(" (\n\t"));
        for (i = 0; i < tableCols.size(); ++i) {
            hfs = tableCols.get(i);
            if (i > 0) {
                sb.append(",\n\t");
            }
            sb.append((CharSequence)HCatalogTestUtils.escHCatObj(hfs.getName().toLowerCase()));
            sb.append(' ').append(hfs.getTypeString());
        }
        sb.append(")\n");
        if (partKeys != null && partKeys.size() > 0) {
            sb.append("partitioned by (\n\t");
            for (i = 0; i < partKeys.size(); ++i) {
                hfs = partKeys.get(i);
                if (i > 0) {
                    sb.append("\n\t,");
                }
                sb.append((CharSequence)HCatalogTestUtils.escHCatObj(hfs.getName().toLowerCase()));
                sb.append(' ').append(hfs.getTypeString());
            }
            sb.append(")\n");
        }
        sb.append(HCatalogTestUtils.getStorageInfo());
        LOG.info((Object)("Create table command : " + sb));
        return sb.toString();
    }

    public void createHCatTableUsingSchema(String dbName, String tableName, List<HCatFieldSchema> tableCols, List<HCatFieldSchema> partKeys) throws Exception {
        String databaseName = dbName == null ? "default" : dbName;
        LOG.info((Object)("Dropping HCatalog table if it exists " + databaseName + '.' + tableName));
        String dropCmd = HCatalogTestUtils.getHCatDropTableCmd(databaseName, tableName);
        try {
            this.utils.launchHCatCli(dropCmd);
        }
        catch (Exception e) {
            LOG.debug((Object)("Drop hcatalog table exception : " + e));
            LOG.info((Object)("Unable to drop table." + dbName + "." + tableName + ".   Assuming it did not exist"));
        }
        LOG.info((Object)("Creating HCatalog table if it exists " + databaseName + '.' + tableName));
        String createCmd = HCatalogTestUtils.getHCatCreateTableCmd(databaseName, tableName, tableCols, partKeys);
        this.utils.launchHCatCli(createCmd);
        LOG.info((Object)("Created HCatalog table " + dbName + "." + tableName));
    }

    private void createInputFile(Path path, int rowCount) throws IOException {
        if (this.fs.exists(path)) {
            this.fs.delete(path, true);
        }
        FSDataOutputStream os = this.fs.create(path);
        for (int i = 0; i < rowCount; ++i) {
            String s = i + "\n";
            os.writeChars(s);
        }
        os.close();
    }

    public List<HCatRecord> loadHCatTable(String dbName, String tableName, Map<String, String> partKeyMap, HCatSchema tblSchema, List<HCatRecord> records) throws Exception {
        Job job = new Job(this.conf, "HCat load job");
        job.setJarByClass(this.getClass());
        job.setMapperClass(HCatWriterMapper.class);
        Path path = new Path(this.fs.getWorkingDirectory(), "mapreduce/HCatTableIndexInput");
        job.getConfiguration().setInt("mapred.map.tasks", 1);
        int writeCount = records.size();
        recsToLoad.clear();
        recsToLoad.addAll(records);
        this.createInputFile(path, writeCount);
        HCatWriterMapper.setWrittenRecordCount(0);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{path});
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(HCatOutputFormat.class);
        OutputJobInfo outputJobInfo = OutputJobInfo.create((String)dbName, (String)tableName, partKeyMap);
        HCatOutputFormat.setOutput((Job)job, (OutputJobInfo)outputJobInfo);
        HCatOutputFormat.setSchema((Job)job, (HCatSchema)tblSchema);
        job.setMapOutputKeyClass(BytesWritable.class);
        job.setMapOutputValueClass(DefaultHCatRecord.class);
        job.setNumReduceTasks(0);
        SqoopHCatUtilities.addJars((Job)job, (SqoopOptions)new SqoopOptions());
        boolean success = job.waitForCompletion(true);
        if (!success) {
            throw new IOException("Loading HCatalog table with test records failed");
        }
        this.utils.invokeOutputCommitterForLocalMode(job);
        LOG.info((Object)("Loaded " + HCatWriterMapper.writtenRecordCount + " records"));
        return recsToLoad;
    }

    public List<HCatRecord> readHCatRecords(String dbName, String tableName, String filter) throws Exception {
        HCatReaderMapper.setReadRecordCount(0);
        recsRead.clear();
        Job job = new Job(this.conf, "HCatalog reader job");
        job.setJarByClass(this.getClass());
        job.setMapperClass(HCatReaderMapper.class);
        job.getConfiguration().setInt("mapred.map.tasks", 1);
        job.setInputFormatClass(HCatInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        HCatInputFormat.setInput((Job)job, (String)dbName, (String)tableName).setFilter(filter);
        job.setMapOutputKeyClass(BytesWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setNumReduceTasks(0);
        Path path = new Path(this.fs.getWorkingDirectory(), "mapreduce/HCatTableIndexOutput");
        if (this.fs.exists(path)) {
            this.fs.delete(path, true);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)path);
        job.waitForCompletion(true);
        LOG.info((Object)("Read " + HCatReaderMapper.readRecordCount + " records"));
        return recsRead;
    }

    public static String forIdx(int idx) {
        return "col" + idx;
    }

    public static ColumnGenerator colGenerator(final String name, final String dbType, final int sqlType, final HCatFieldSchema.Type hCatType, final int hCatPrecision, final int hCatScale, final Object hCatValue, final Object dbValue, final KeyType keyType) {
        return new ColumnGenerator(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Object getDBValue(int rowNum) {
                return dbValue;
            }

            @Override
            public Object getHCatValue(int rowNum) {
                return hCatValue;
            }

            @Override
            public String getDBTypeString() {
                return dbType;
            }

            @Override
            public int getSqlType() {
                return sqlType;
            }

            @Override
            public HCatFieldSchema.Type getHCatType() {
                return hCatType;
            }

            @Override
            public int getHCatPrecision() {
                return hCatPrecision;
            }

            @Override
            public int getHCatScale() {
                return hCatScale;
            }

            @Override
            public KeyType getKeyType() {
                return keyType;
            }
        };
    }

    public static void assertEquals(Object expectedVal, Object actualVal) {
        if (expectedVal != null && expectedVal instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expectedVal), (byte[])((byte[])actualVal));
        } else if (expectedVal instanceof Float) {
            if (actualVal instanceof Double) {
                Assert.assertEquals((double)((Float)expectedVal).floatValue(), (double)((Double)actualVal), (double)1.0E-10);
            } else {
                Assert.assertEquals((String)"Got unexpected column value", (Object)expectedVal, (Object)actualVal);
            }
        } else if (expectedVal instanceof Double) {
            if (actualVal instanceof Float) {
                Assert.assertEquals((double)((Double)expectedVal), (double)((Float)actualVal).doubleValue(), (double)1.0E-10);
            } else {
                Assert.assertEquals((String)"Got unexpected column value", (Object)expectedVal, (Object)actualVal);
            }
        } else if (expectedVal instanceof HiveVarchar) {
            HiveVarchar vc1 = (HiveVarchar)expectedVal;
            if (actualVal instanceof HiveVarchar) {
                HiveVarchar vc2 = (HiveVarchar)actualVal;
                HCatalogTestUtils.assertEquals(vc1.getCharacterLength(), vc2.getCharacterLength());
                HCatalogTestUtils.assertEquals(vc1.getValue(), vc2.getValue());
            } else {
                String vc2 = (String)actualVal;
                HCatalogTestUtils.assertEquals(vc1.getCharacterLength(), vc2.length());
                HCatalogTestUtils.assertEquals(vc1.getValue(), vc2);
            }
        } else if (expectedVal instanceof HiveChar) {
            HiveChar c1 = (HiveChar)expectedVal;
            if (actualVal instanceof HiveChar) {
                HiveChar c2 = (HiveChar)actualVal;
                HCatalogTestUtils.assertEquals(c1.getCharacterLength(), c2.getCharacterLength());
                HCatalogTestUtils.assertEquals(c1.getValue(), c2.getValue());
            } else {
                String c2 = (String)actualVal;
                HCatalogTestUtils.assertEquals(c1.getCharacterLength(), c2.length());
                HCatalogTestUtils.assertEquals(c1.getValue(), c2);
            }
        } else {
            Assert.assertEquals((String)"Got unexpected column value", (Object)expectedVal, (Object)actualVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertSqlColValForRowId(Connection conn, String table, int id, String colName, Object expectedVal) throws SQLException {
        LOG.info((Object)("Verifying column " + colName + " has value " + expectedVal));
        PreparedStatement statement = conn.prepareStatement("SELECT " + colName + " FROM " + table + " WHERE id = " + id, 1003, 1007);
        Object actualVal = null;
        try {
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                actualVal = rs.getObject(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        HCatalogTestUtils.assertEquals(expectedVal, actualVal);
    }

    public static void assertHCatColValForRowId(List<HCatRecord> recs, HCatSchema schema, int id, String fieldName, Object expectedVal) throws IOException {
        LOG.info((Object)("Verifying field " + fieldName + " has value " + expectedVal));
        Object actualVal = null;
        for (HCatRecord rec : recs) {
            if (!rec.getInteger("id", schema).equals(id)) continue;
            actualVal = rec.get(fieldName, schema);
            break;
        }
        if (actualVal == null) {
            throw new IOException("No record found with id = " + id);
        }
        if (expectedVal != null && expectedVal instanceof byte[]) {
            Assert.assertArrayEquals((byte[])((byte[])expectedVal), (byte[])((byte[])actualVal));
        } else if (expectedVal instanceof Float) {
            if (actualVal instanceof Double) {
                Assert.assertEquals((double)((Float)expectedVal).floatValue(), (double)((Double)actualVal), (double)1.0E-10);
            } else {
                Assert.assertEquals((String)"Got unexpected column value", (Object)expectedVal, actualVal);
            }
        } else if (expectedVal instanceof Double) {
            if (actualVal instanceof Float) {
                Assert.assertEquals((double)((Double)expectedVal), (double)((Float)actualVal).doubleValue(), (double)1.0E-10);
            } else {
                Assert.assertEquals((String)"Got unexpected column value", (Object)expectedVal, (Object)actualVal);
            }
        } else {
            Assert.assertEquals((String)"Got unexpected column value", (Object)expectedVal, actualVal);
        }
    }

    public static String getSqlDropTableStatement(String tableName) {
        return "DROP TABLE " + tableName;
    }

    public static String getSqlCreateTableStatement(String tableName, ColumnGenerator ... extraCols) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(tableName);
        sb.append(" (id INT NOT NULL PRIMARY KEY, msg VARCHAR(64)");
        int colNum = 0;
        for (ColumnGenerator gen : extraCols) {
            sb.append(", " + HCatalogTestUtils.forIdx(colNum++) + " " + gen.getDBTypeString());
        }
        sb.append(")");
        String cmd = sb.toString();
        LOG.debug((Object)("Generated SQL create table command : " + cmd));
        return cmd;
    }

    public static String getSqlInsertTableStatement(String tableName, ColumnGenerator ... extraCols) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(tableName);
        sb.append(" (id, msg");
        int colNum = 0;
        for (i = 0; i < extraCols.length; ++i) {
            sb.append(", " + HCatalogTestUtils.forIdx(colNum++));
        }
        sb.append(") VALUES ( ?, ?");
        for (i = 0; i < extraCols.length; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        String s = sb.toString();
        LOG.debug((Object)("Generated SQL insert table command : " + s));
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSqlTable(Connection conn, boolean generateOnly, int count, String table, ColumnGenerator ... extraCols) throws Exception {
        PreparedStatement statement = conn.prepareStatement(HCatalogTestUtils.getSqlDropTableStatement(table), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        catch (SQLException sqle) {
            conn.rollback();
        }
        finally {
            statement.close();
        }
        statement = conn.prepareStatement(HCatalogTestUtils.getSqlCreateTableStatement(table, extraCols), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
        if (!generateOnly) {
            this.loadSqlTable(conn, table, count, extraCols);
        }
    }

    public HCatSchema createHCatTable(CreateMode mode, int count, String table, ColumnGenerator ... extraCols) throws Exception {
        HCatSchema hCatTblSchema = this.generateHCatTableSchema(extraCols);
        HCatSchema hCatPartSchema = this.generateHCatPartitionSchema(extraCols);
        HCatSchema hCatFullSchema = new HCatSchema(hCatTblSchema.getFields());
        for (HCatFieldSchema hfs : hCatPartSchema.getFields()) {
            hCatFullSchema.append(hfs);
        }
        if (mode != CreateMode.NO_CREATION) {
            this.createHCatTableUsingSchema(null, table, hCatTblSchema.getFields(), hCatPartSchema.getFields());
            if (mode == CreateMode.CREATE_AND_LOAD) {
                HCatSchema hCatLoadSchema = new HCatSchema(hCatTblSchema.getFields());
                HCatSchema dynPartSchema = this.generateHCatDynamicPartitionSchema(extraCols);
                for (HCatFieldSchema hfs : dynPartSchema.getFields()) {
                    hCatLoadSchema.append(hfs);
                }
                this.loadHCatTable(hCatLoadSchema, table, count, extraCols);
            }
        }
        return hCatFullSchema;
    }

    private void loadHCatTable(HCatSchema hCatSchema, String table, int count, ColumnGenerator ... extraCols) throws Exception {
        HashMap<String, String> staticKeyMap = new HashMap<String, String>();
        for (ColumnGenerator col : extraCols) {
            if (col.getKeyType() != KeyType.STATIC_KEY) continue;
            staticKeyMap.put(col.getName(), (String)col.getHCatValue(0));
        }
        this.loadHCatTable(null, table, staticKeyMap, hCatSchema, this.generateHCatRecords(count, hCatSchema, extraCols));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSqlTable(Connection conn, String table, int count, ColumnGenerator ... extraCols) throws Exception {
        PreparedStatement statement = conn.prepareStatement(HCatalogTestUtils.getSqlInsertTableStatement(table, extraCols), 1003, 1007);
        try {
            for (int i = 0; i < count; ++i) {
                statement.setObject(1, (Object)i, 4);
                statement.setObject(2, (Object)("textfield" + i), 12);
                for (int j = 0; j < extraCols.length; ++j) {
                    statement.setObject(j + 3, extraCols[j].getDBValue(i), extraCols[j].getSqlType());
                }
                statement.executeUpdate();
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        finally {
            statement.close();
        }
    }

    private HCatSchema generateHCatTableSchema(ColumnGenerator ... extraCols) throws Exception {
        ArrayList<HCatFieldSchema> hCatTblCols = new ArrayList<HCatFieldSchema>();
        hCatTblCols.clear();
        PrimitiveTypeInfo tInfo = new PrimitiveTypeInfo();
        tInfo.setTypeName(HCatFieldSchema.Type.INT.name().toLowerCase());
        hCatTblCols.add(new HCatFieldSchema("id", tInfo, ""));
        tInfo = new PrimitiveTypeInfo();
        tInfo.setTypeName(HCatFieldSchema.Type.STRING.name().toLowerCase());
        hCatTblCols.add(new HCatFieldSchema("msg", tInfo, ""));
        for (ColumnGenerator gen : extraCols) {
            if (gen.getKeyType() != KeyType.NOT_A_KEY) continue;
            switch (gen.getHCatType()) {
                case CHAR: {
                    tInfo = new CharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case VARCHAR: {
                    tInfo = new VarcharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case DECIMAL: {
                    tInfo = new DecimalTypeInfo(gen.getHCatPrecision(), gen.getHCatScale());
                    break;
                }
                default: {
                    tInfo = new PrimitiveTypeInfo();
                    tInfo.setTypeName(gen.getHCatType().name().toLowerCase());
                }
            }
            hCatTblCols.add(new HCatFieldSchema(gen.getName(), tInfo, ""));
        }
        HCatSchema hCatTblSchema = new HCatSchema(hCatTblCols);
        return hCatTblSchema;
    }

    private HCatSchema generateHCatPartitionSchema(ColumnGenerator ... extraCols) throws Exception {
        ArrayList<HCatFieldSchema> hCatPartCols = new ArrayList<HCatFieldSchema>();
        for (ColumnGenerator gen : extraCols) {
            PrimitiveTypeInfo tInfo;
            if (gen.getKeyType() == KeyType.NOT_A_KEY) continue;
            switch (gen.getHCatType()) {
                case CHAR: {
                    tInfo = new CharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case VARCHAR: {
                    tInfo = new VarcharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case DECIMAL: {
                    tInfo = new DecimalTypeInfo(gen.getHCatPrecision(), gen.getHCatScale());
                    break;
                }
                default: {
                    tInfo = new PrimitiveTypeInfo();
                    tInfo.setTypeName(gen.getHCatType().name().toLowerCase());
                }
            }
            hCatPartCols.add(new HCatFieldSchema(gen.getName(), tInfo, ""));
        }
        HCatSchema hCatPartSchema = new HCatSchema(hCatPartCols);
        return hCatPartSchema;
    }

    private HCatSchema generateHCatDynamicPartitionSchema(ColumnGenerator ... extraCols) throws Exception {
        ArrayList<HCatFieldSchema> hCatPartCols = new ArrayList<HCatFieldSchema>();
        hCatPartCols.clear();
        for (ColumnGenerator gen : extraCols) {
            PrimitiveTypeInfo tInfo;
            if (gen.getKeyType() == KeyType.NOT_A_KEY || gen.getKeyType() == KeyType.STATIC_KEY) continue;
            switch (gen.getHCatType()) {
                case CHAR: {
                    tInfo = new CharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case VARCHAR: {
                    tInfo = new VarcharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case DECIMAL: {
                    tInfo = new DecimalTypeInfo(gen.getHCatPrecision(), gen.getHCatScale());
                    break;
                }
                default: {
                    tInfo = new PrimitiveTypeInfo();
                    tInfo.setTypeName(gen.getHCatType().name().toLowerCase());
                }
            }
            hCatPartCols.add(new HCatFieldSchema(gen.getName(), tInfo, ""));
        }
        HCatSchema hCatPartSchema = new HCatSchema(hCatPartCols);
        return hCatPartSchema;
    }

    private HCatSchema generateHCatStaticPartitionSchema(ColumnGenerator ... extraCols) throws Exception {
        ArrayList<HCatFieldSchema> hCatPartCols = new ArrayList<HCatFieldSchema>();
        hCatPartCols.clear();
        for (ColumnGenerator gen : extraCols) {
            PrimitiveTypeInfo tInfo;
            if (gen.getKeyType() != KeyType.STATIC_KEY) continue;
            switch (gen.getHCatType()) {
                case CHAR: {
                    tInfo = new CharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case VARCHAR: {
                    tInfo = new VarcharTypeInfo(gen.getHCatPrecision());
                    break;
                }
                case DECIMAL: {
                    tInfo = new DecimalTypeInfo(gen.getHCatPrecision(), gen.getHCatScale());
                    break;
                }
                default: {
                    tInfo = new PrimitiveTypeInfo();
                    tInfo.setTypeName(gen.getHCatType().name().toLowerCase());
                }
            }
            hCatPartCols.add(new HCatFieldSchema(gen.getName(), tInfo, ""));
            break;
        }
        HCatSchema hCatPartSchema = new HCatSchema(hCatPartCols);
        return hCatPartSchema;
    }

    private List<HCatRecord> generateHCatRecords(int numRecords, HCatSchema hCatTblSchema, ColumnGenerator ... extraCols) throws Exception {
        ArrayList<HCatRecord> records = new ArrayList<HCatRecord>();
        List hCatTblCols = hCatTblSchema.getFields();
        int size = hCatTblCols.size();
        for (int i = 0; i < numRecords; ++i) {
            DefaultHCatRecord record = new DefaultHCatRecord(size);
            record.set(((HCatFieldSchema)hCatTblCols.get(0)).getName(), hCatTblSchema, (Object)i);
            record.set(((HCatFieldSchema)hCatTblCols.get(1)).getName(), hCatTblSchema, (Object)("textfield" + i));
            int idx = 0;
            for (int j = 0; j < extraCols.length; ++j) {
                if (extraCols[j].getKeyType() == KeyType.STATIC_KEY) continue;
                record.set(((HCatFieldSchema)hCatTblCols.get(idx + 2)).getName(), hCatTblSchema, extraCols[j].getHCatValue(i));
                ++idx;
            }
            records.add((HCatRecord)record);
        }
        return records;
    }

    public String hCatRecordDump(List<HCatRecord> recs, HCatSchema schema) throws Exception {
        List fields = schema.getFieldNames();
        int count = 0;
        StringBuilder sb = new StringBuilder(1024);
        for (HCatRecord rec : recs) {
            sb.append("HCat Record : " + ++count).append('\n');
            for (String field : fields) {
                sb.append('\t').append(field).append('=');
                sb.append(rec.get(field, schema)).append('\n');
                sb.append("\n\n");
            }
        }
        return sb.toString();
    }

    public Map<String, String> getAddlTestArgs() {
        String addlArgs = System.getProperty(SQOOP_HCATALOG_TEST_ARGS);
        HashMap<String, String> addlArgsMap = new HashMap<String, String>();
        if (addlArgs != null) {
            String[] argsArray;
            for (String s : argsArray = addlArgs.split(",")) {
                String[] keyVal = s.split("=");
                if (keyVal.length == 2) {
                    addlArgsMap.put(keyVal[0], keyVal[1]);
                    continue;
                }
                LOG.info((Object)("Ignoring malformed addl arg " + s));
            }
        }
        return addlArgsMap;
    }

    public static interface ColumnGenerator {
        public String getName();

        public Object getHCatValue(int var1);

        public Object getDBValue(int var1);

        public String getDBTypeString();

        public int getSqlType();

        public HCatFieldSchema.Type getHCatType();

        public int getHCatPrecision();

        public int getHCatScale();

        public KeyType getKeyType();
    }

    public static enum CreateMode {
        NO_CREATION,
        CREATE,
        CREATE_AND_LOAD;

    }

    public static enum KeyType {
        NOT_A_KEY,
        STATIC_KEY,
        DYNAMIC_KEY;

    }

    public static class HCatReaderMapper
    extends Mapper<WritableComparable, HCatRecord, BytesWritable, Text> {
        private static int readRecordCount = 0;

        public static int getReadRecordCount() {
            return readRecordCount;
        }

        public static void setReadRecordCount(int count) {
            readRecordCount = count;
        }

        public void map(WritableComparable key, HCatRecord value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                recsRead.add(value);
                ++readRecordCount;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                throw new IOException(e);
            }
        }
    }

    public static class HCatWriterMapper
    extends Mapper<LongWritable, Text, BytesWritable, HCatRecord> {
        private static int writtenRecordCount = 0;

        public static int getWrittenRecordCount() {
            return writtenRecordCount;
        }

        public static void setWrittenRecordCount(int count) {
            writtenRecordCount = count;
        }

        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                HCatRecord rec = (HCatRecord)recsToLoad.get(writtenRecordCount);
                context.write(null, (Object)rec);
                ++writtenRecordCount;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace(System.err);
                }
                throw new IOException(e);
            }
        }
    }

    private static final class Holder {
        private static final HCatalogTestUtils INSTANCE = new HCatalogTestUtils();

        private Holder() {
        }
    }
}

