/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DataDrivenDBInputFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.mapreduce.DBWritable;

public class TestDataDrivenDBInputFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestDataDrivenDBInputFormat.class);
    private static final String DB_NAME = "dddbif";
    private static final String DB_URL = "jdbc:hsqldb:mem:dddbif";
    private static final String DRIVER_CLASS = "org.hsqldb.jdbcDriver";
    private Connection connection;
    private static final String OUT_DIR = System.getProperty("test.build.data", "/tmp") + "/dddbifout";

    private void createConnection(String driverClassName, String url) throws Exception {
        Class.forName(driverClassName);
        this.connection = DriverManager.getConnection(url);
        this.connection.setAutoCommit(false);
    }

    private void shutdown() {
        try {
            this.connection.commit();
            this.connection.close();
            this.connection = null;
        }
        catch (Throwable ex) {
            LOG.warn((Object)("Exception occurred while closing connection :" + StringUtils.stringifyException((Throwable)ex)));
        }
    }

    private void initialize(String driverClassName, String url) throws Exception {
        this.createConnection(driverClassName, url);
    }

    public void setUp() throws Exception {
        this.initialize(DRIVER_CLASS, DB_URL);
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateSplits() throws Exception {
        Statement s = this.connection.createStatement();
        String DATE_TABLE = "datetable";
        String COL = "foo";
        try {
            try {
                s.executeUpdate("DROP TABLE datetable");
            }
            catch (SQLException e) {
                // empty catch block
            }
            s.executeUpdate("CREATE TABLE datetable(foo TIMESTAMP)");
            s.executeUpdate("INSERT INTO datetable VALUES('2010-04-01')");
            s.executeUpdate("INSERT INTO datetable VALUES('2010-04-02')");
            s.executeUpdate("INSERT INTO datetable VALUES('2010-05-01')");
            s.executeUpdate("INSERT INTO datetable VALUES('2011-04-01')");
            this.connection.commit();
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", "file:///");
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            fs.delete(new Path(OUT_DIR), true);
            Job job = new Job(conf);
            job.setMapperClass(ValMapper.class);
            job.setReducerClass(Reducer.class);
            job.setMapOutputKeyClass(DateCol.class);
            job.setMapOutputValueClass(NullWritable.class);
            job.setOutputKeyClass(DateCol.class);
            job.setOutputValueClass(NullWritable.class);
            job.setNumReduceTasks(1);
            job.getConfiguration().setInt("mapreduce.map.tasks", 2);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(OUT_DIR));
            DBConfiguration.configureDB((Configuration)job.getConfiguration(), (String)DRIVER_CLASS, (String)DB_URL, (String)null, (String)null);
            DataDrivenDBInputFormat.setInput((Job)job, DateCol.class, (String)"datetable", null, (String)"foo", (String[])new String[]{"foo"});
            boolean ret = job.waitForCompletion(true);
            TestDataDrivenDBInputFormat.assertTrue((String)"job failed", (boolean)ret);
            TestDataDrivenDBInputFormat.assertEquals((String)"Did not get all the records", (long)4L, (long)job.getCounters().findCounter("org.apache.hadoop.mapred.Task$Counter", "REDUCE_OUTPUT_RECORDS").getValue());
        }
        finally {
            s.close();
        }
    }

    public static class ValMapper
    extends Mapper<Object, Object, Object, NullWritable> {
        public void map(Object k, Object v, Mapper.Context c) throws IOException, InterruptedException {
            c.write(v, (Object)NullWritable.get());
        }
    }

    public static class DateCol
    implements DBWritable,
    WritableComparable {
        private Date d;

        public Date getDate() {
            return this.d;
        }

        public void setDate(Date dt) {
            this.d = dt;
        }

        public String toString() {
            return this.d.toString();
        }

        public void readFields(ResultSet rs) throws SQLException {
            this.d = rs.getDate(1);
        }

        public void write(PreparedStatement ps) {
        }

        public void readFields(DataInput in) throws IOException {
            long v = in.readLong();
            this.d = new Date(v);
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.d.getTime());
        }

        public int hashCode() {
            return (int)this.d.getTime();
        }

        public int compareTo(Object o) {
            if (o instanceof DateCol) {
                Long v = this.d.getTime();
                Long other = ((DateCol)o).d.getTime();
                return v.compareTo(other);
            }
            return -1;
        }

        public boolean equals(Object o) {
            return o instanceof DateCol && this.compareTo(o) == 0;
        }
    }
}

