/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.io;

import com.cloudera.sqoop.io.CodecMap;
import com.cloudera.sqoop.io.UnsupportedCodecException;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;

public class TestCodecMap
extends TestCase {
    private void verifyCodec(Class<?> c, String codecName) throws UnsupportedCodecException {
        CompressionCodec codec = CodecMap.getCodec((String)codecName, (Configuration)new Configuration());
        TestCodecMap.assertEquals(codec.getClass(), c);
    }

    public void testGetCodecNames() {
        TestCodecMap.assertTrue((boolean)CodecMap.getCodecNames().contains("gzip"));
    }

    public void testGetCodec() throws IOException {
        this.verifyCodec(GzipCodec.class, "gzip");
        this.verifyCodec(GzipCodec.class, "Gzip");
        this.verifyCodec(GzipCodec.class, "GZIP");
        this.verifyCodec(GzipCodec.class, "gzipcodec");
        this.verifyCodec(GzipCodec.class, "GzipCodec");
        this.verifyCodec(GzipCodec.class, "GZIPCODEC");
        this.verifyCodec(GzipCodec.class, "org.apache.hadoop.io.compress.GzipCodec");
    }

    public void testGetShortName() throws UnsupportedCodecException {
        this.verifyShortName("gzip", "org.apache.hadoop.io.compress.GzipCodec");
        this.verifyShortName("default", "org.apache.hadoop.io.compress.DefaultCodec");
        try {
            this.verifyShortName("NONE", "bogus");
            TestCodecMap.fail((String)"Expected IOException");
        }
        catch (UnsupportedCodecException unsupportedCodecException) {
            // empty catch block
        }
    }

    private void verifyShortName(String expected, String codecName) throws UnsupportedCodecException {
        TestCodecMap.assertEquals((String)expected, (String)CodecMap.getCodecShortNameByName((String)codecName, (Configuration)new Configuration()));
    }

    public void testUnrecognizedCodec() {
        try {
            CodecMap.getCodec((String)"bogus", (Configuration)new Configuration());
            TestCodecMap.fail((String)"'bogus' codec should throw exception");
        }
        catch (UnsupportedCodecException unsupportedCodecException) {
            // empty catch block
        }
    }
}

