/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kitesdk.data.CompressionType;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetReader;
import org.kitesdk.data.Datasets;

public class TestParquetImport
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestParquetImport.class.getName());

    protected String[] getOutputArgv(boolean includeHadoopFlags, String[] extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--m");
        args.add("1");
        args.add("--split-by");
        args.add("INTFIELD1");
        args.add("--as-parquetfile");
        if (extraArgs != null) {
            args.addAll(Arrays.asList(extraArgs));
        }
        return args.toArray(new String[args.size()]);
    }

    public void testSnappyCompression() throws IOException {
        this.runParquetImportTest("snappy");
    }

    public void testDeflateCompression() throws IOException {
        this.runParquetImportTest("deflate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runParquetImportTest(String codec) throws IOException {
        String[] types = new String[]{"BIT", "INTEGER", "BIGINT", "REAL", "DOUBLE", "VARCHAR(6)", "VARBINARY(2)"};
        String[] vals = new String[]{"true", "100", "200", "1.0", "2.0", "'s'", "'0102'"};
        this.createTableWithColTypes(types, vals);
        String[] extraArgs = new String[]{"--compression-codec", codec};
        this.runImport(this.getOutputArgv(true, extraArgs));
        TestParquetImport.assertEquals((Object)CompressionType.forName((String)codec), (Object)this.getCompressionType());
        Schema schema = this.getSchema();
        TestParquetImport.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        List fields = schema.getFields();
        TestParquetImport.assertEquals((int)types.length, (int)fields.size());
        this.checkField((Schema.Field)fields.get(0), "DATA_COL0", Schema.Type.BOOLEAN);
        this.checkField((Schema.Field)fields.get(1), "DATA_COL1", Schema.Type.INT);
        this.checkField((Schema.Field)fields.get(2), "DATA_COL2", Schema.Type.LONG);
        this.checkField((Schema.Field)fields.get(3), "DATA_COL3", Schema.Type.FLOAT);
        this.checkField((Schema.Field)fields.get(4), "DATA_COL4", Schema.Type.DOUBLE);
        this.checkField((Schema.Field)fields.get(5), "DATA_COL5", Schema.Type.STRING);
        this.checkField((Schema.Field)fields.get(6), "DATA_COL6", Schema.Type.BYTES);
        DatasetReader<GenericRecord> reader = this.getReader();
        try {
            GenericRecord record1 = (GenericRecord)reader.next();
            TestParquetImport.assertEquals((String)"DATA_COL0", (Object)true, (Object)record1.get("DATA_COL0"));
            TestParquetImport.assertEquals((String)"DATA_COL1", (Object)100, (Object)record1.get("DATA_COL1"));
            TestParquetImport.assertEquals((String)"DATA_COL2", (Object)200L, (Object)record1.get("DATA_COL2"));
            TestParquetImport.assertEquals((String)"DATA_COL3", (Object)Float.valueOf(1.0f), (Object)record1.get("DATA_COL3"));
            TestParquetImport.assertEquals((String)"DATA_COL4", (Object)2.0, (Object)record1.get("DATA_COL4"));
            TestParquetImport.assertEquals((String)"DATA_COL5", (Object)"s", (Object)record1.get("DATA_COL5"));
            Object object = record1.get("DATA_COL6");
            TestParquetImport.assertTrue((boolean)(object instanceof ByteBuffer));
            ByteBuffer b = (ByteBuffer)object;
            TestParquetImport.assertEquals((byte)1, (byte)b.get(0));
            TestParquetImport.assertEquals((byte)2, (byte)b.get(1));
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverrideTypeMapping() throws IOException {
        String[] types = new String[]{"INT"};
        String[] vals = new String[]{"10"};
        this.createTableWithColTypes(types, vals);
        String[] extraArgs = new String[]{"--map-column-java", "DATA_COL0=String"};
        this.runImport(this.getOutputArgv(true, extraArgs));
        Schema schema = this.getSchema();
        TestParquetImport.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        List fields = schema.getFields();
        TestParquetImport.assertEquals((int)types.length, (int)fields.size());
        this.checkField((Schema.Field)fields.get(0), "DATA_COL0", Schema.Type.STRING);
        DatasetReader<GenericRecord> reader = this.getReader();
        try {
            GenericRecord record1 = (GenericRecord)reader.next();
            TestParquetImport.assertEquals((String)"DATA_COL0", (Object)"10", (Object)record1.get("DATA_COL0"));
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFirstUnderscoreInColumnName() throws IOException {
        String[] names = new String[]{"_NAME"};
        String[] types = new String[]{"INT"};
        String[] vals = new String[]{"1987"};
        this.createTableWithColTypesAndNames(names, types, vals);
        this.runImport(this.getOutputArgv(true, null));
        Schema schema = this.getSchema();
        TestParquetImport.assertEquals((Object)Schema.Type.RECORD, (Object)schema.getType());
        List fields = schema.getFields();
        TestParquetImport.assertEquals((int)types.length, (int)fields.size());
        this.checkField((Schema.Field)fields.get(0), "__NAME", Schema.Type.INT);
        DatasetReader<GenericRecord> reader = this.getReader();
        try {
            GenericRecord record1 = (GenericRecord)reader.next();
            TestParquetImport.assertEquals((String)"__NAME", (Object)1987, (Object)record1.get("__NAME"));
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullableParquetImport() throws IOException, SQLException {
        String[] types = new String[]{"INT"};
        String[] vals = new String[]{null};
        this.createTableWithColTypes(types, vals);
        this.runImport(this.getOutputArgv(true, null));
        DatasetReader<GenericRecord> reader = this.getReader();
        try {
            GenericRecord record1 = (GenericRecord)reader.next();
            TestParquetImport.assertNull((Object)record1.get("DATA_COL0"));
        }
        finally {
            reader.close();
        }
    }

    private CompressionType getCompressionType() {
        return this.getDataset().getDescriptor().getCompressionType();
    }

    private Schema getSchema() {
        return this.getDataset().getDescriptor().getSchema();
    }

    private DatasetReader<GenericRecord> getReader() {
        return this.getDataset().newReader();
    }

    private Dataset<GenericRecord> getDataset() {
        String uri = "dataset:file:" + this.getTablePath();
        return (Dataset)Datasets.load((String)uri, GenericRecord.class);
    }

    private void checkField(Schema.Field field, String name, Schema.Type type) {
        TestParquetImport.assertEquals((String)name, (String)field.name());
        TestParquetImport.assertEquals((Object)Schema.Type.UNION, (Object)field.schema().getType());
        TestParquetImport.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)field.schema().getTypes().get(0)).getType());
        TestParquetImport.assertEquals((Object)type, (Object)((Schema)field.schema().getTypes().get(1)).getType());
    }
}

