/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.ExportJobTestCase;
import com.cloudera.sqoop.tool.CodeGenTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.ReflectionUtils;

public class TestExport
extends ExportJobTestCase {
    protected String[] getCodeGenArgv(String ... extraArgs) {
        ArrayList<String> codeGenArgv = new ArrayList<String>();
        if (null != extraArgs) {
            for (String arg : extraArgs) {
                codeGenArgv.add(arg);
            }
        }
        codeGenArgv.add("--table");
        codeGenArgv.add(this.getTableName());
        codeGenArgv.add("--connect");
        codeGenArgv.add(this.getConnectString());
        codeGenArgv.add("--fields-terminated-by");
        codeGenArgv.add("\\t");
        codeGenArgv.add("--lines-terminated-by");
        codeGenArgv.add("\\n");
        return codeGenArgv.toArray(new String[0]);
    }

    protected String getRecordLine(int recordNum, ColumnGenerator ... extraCols) {
        String idStr = Integer.toString(recordNum);
        StringBuilder sb = new StringBuilder();
        sb.append(idStr);
        sb.append("\t");
        sb.append(this.getMsgPrefix());
        sb.append(idStr);
        for (ColumnGenerator gen : extraCols) {
            sb.append("\t");
            sb.append(gen.getExportText(recordNum));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected void createTextFile(int fileNum, int numRecords, boolean gzip, ColumnGenerator ... extraCols) throws IOException {
        int startId = fileNum * numRecords;
        String ext = ".txt";
        if (gzip) {
            ext = ext + ".gz";
        }
        Path tablePath = this.getTablePath();
        Path filePath = new Path(tablePath, "part" + fileNum + ext);
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(tablePath);
        FSDataOutputStream os = fs.create(filePath);
        if (gzip) {
            CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
            CompressionCodec codec = ccf.getCodec(filePath);
            os = codec.createOutputStream((OutputStream)os);
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)os));
        for (int i = 0; i < numRecords; ++i) {
            w.write(this.getRecordLine(startId + i, extraCols));
        }
        w.close();
        os.close();
        if (gzip) {
            this.verifyCompressedFile(filePath, numRecords);
        }
    }

    private void verifyCompressedFile(Path f, int expectedNumLines) throws IOException {
        String ln;
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataInputStream is = fs.open(f);
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(f);
        LOG.info((Object)("gzip check codec is " + codec));
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        if (null == decompressor) {
            LOG.info((Object)"Verifying gzip sanity with null decompressor");
        } else {
            LOG.info((Object)("Verifying gzip sanity with decompressor: " + decompressor.toString()));
        }
        is = codec.createInputStream((InputStream)is, decompressor);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is));
        int numLines = 0;
        while ((ln = r.readLine()) != null) {
            ++numLines;
        }
        r.close();
        TestExport.assertEquals((String)"Did not read back correct number of lines", (int)expectedNumLines, (int)numLines);
        LOG.info((Object)("gzip sanity check returned " + numLines + " lines; ok."));
    }

    private void createSequenceFile(int fileNum, int numRecords, String className) throws IOException {
        try {
            Class<?> cls = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            SqoopRecord record = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)new Configuration());
            Configuration conf = new Configuration();
            if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
                conf.set("fs.defaultfs.name", "file:///");
            }
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tablePath = this.getTablePath();
            Path filePath = new Path(tablePath, "part" + fileNum);
            fs.mkdirs(tablePath);
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)filePath, LongWritable.class, cls);
            int startId = fileNum * numRecords;
            for (int i = 0; i < numRecords; ++i) {
                record.parse((CharSequence)this.getRecordLine(startId + i, new ColumnGenerator[0]));
                w.append((Writable)new LongWritable((long)(startId + i)), (Writable)record);
            }
            w.close();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        catch (RecordParser.ParseError pe) {
            throw new IOException(pe);
        }
    }

    protected String forIdx(int idx) {
        return "col" + idx;
    }

    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE " + tableName + " IF EXISTS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(ColumnGenerator ... extraColumns) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement(this.getDropTableStatement(this.getTableName()), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(this.getTableName());
        sb.append(" (id INT NOT NULL PRIMARY KEY, msg VARCHAR(64)");
        int colNum = 0;
        for (ColumnGenerator gen : extraColumns) {
            sb.append(", " + this.forIdx(colNum++) + " " + gen.getType());
        }
        sb.append(")");
        statement = conn.prepareStatement(sb.toString(), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    public String getStagingTableName() {
        return this.getTableName() + "_STAGE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStagingTable(ColumnGenerator ... extraColumns) throws SQLException {
        String stageTableName = this.getStagingTableName();
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement(this.getDropTableStatement(stageTableName), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(stageTableName);
        sb.append(" (id INT NOT NULL PRIMARY KEY, msg VARCHAR(64)");
        int colNum = 0;
        for (ColumnGenerator gen : extraColumns) {
            sb.append(", " + this.forIdx(colNum++) + " " + gen.getType());
        }
        sb.append(")");
        statement = conn.prepareStatement(sb.toString(), 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    private void removeTablePath() throws IOException {
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(this.getTablePath(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertColValForRowId(int id, String colName, String expectedVal) throws SQLException {
        Connection conn = this.getConnection();
        LOG.info((Object)("Verifying column " + colName + " has value " + expectedVal));
        PreparedStatement statement = conn.prepareStatement("SELECT " + colName + " FROM " + this.getTableName() + " WHERE id = " + id, 1003, 1007);
        String actualVal = null;
        try {
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                actualVal = rs.getString(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
        TestExport.assertEquals((String)"Got unexpected column value", (String)expectedVal, (String)actualVal);
    }

    protected void assertColMinAndMax(String colName, ColumnGenerator generator) throws SQLException {
        Connection conn = this.getConnection();
        int minId = this.getMinRowId(conn);
        int maxId = this.getMaxRowId(conn);
        LOG.info((Object)("Checking min/max for column " + colName + " with type " + generator.getType()));
        String expectedMin = generator.getVerifyText(minId);
        String expectedMax = generator.getVerifyText(maxId);
        this.assertColValForRowId(minId, colName, expectedMin);
        this.assertColValForRowId(maxId, colName, expectedMax);
    }

    @Override
    protected String[] newStrArray(String[] entries, String ... moreEntries) {
        if (null == moreEntries) {
            return entries;
        }
        if (null == entries) {
            entries = new String[]{};
        }
        int newSize = entries.length + moreEntries.length;
        String[] out = new String[newSize];
        int i = 0;
        for (String e : entries) {
            out[i++] = e;
        }
        for (String e : moreEntries) {
            out[i++] = e;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multiFileTest(int numFiles, int recordsPerMap, int numMaps, String ... argv) throws IOException, SQLException {
        int TOTAL_RECORDS = numFiles * recordsPerMap;
        try {
            LOG.info((Object)("Beginning test: numFiles=" + numFiles + "; recordsPerMap=" + recordsPerMap + "; numMaps=" + numMaps));
            for (int i = 0; i < numFiles; ++i) {
                this.createTextFile(i, recordsPerMap, false, new ColumnGenerator[0]);
            }
            this.createTable(new ColumnGenerator[0]);
            this.runExport(this.getArgv(true, 10, 10, this.newStrArray(argv, "-m", "" + numMaps)));
            this.verifyExport(TOTAL_RECORDS);
        }
        finally {
            LOG.info((Object)"multi-file test complete");
        }
    }

    public void testEmptyExport() throws IOException, SQLException {
        this.multiFileTest(1, 0, 1, new String[0]);
    }

    public void testTextExport() throws IOException, SQLException {
        this.multiFileTest(1, 10, 1, new String[0]);
    }

    public void testMultiFilesOneMapper() throws IOException, SQLException {
        this.multiFileTest(2, 10, 1, new String[0]);
    }

    public void testMultiFilesMultiMaps() throws IOException, SQLException {
        this.multiFileTest(2, 10, 2, new String[0]);
    }

    public void testGzipExport() throws IOException, SQLException {
        LOG.info((Object)"Beginning gzip export test");
        int TOTAL_RECORDS = 10;
        this.createTextFile(0, 10, true, new ColumnGenerator[0]);
        this.createTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(10);
        LOG.info((Object)"Complete gzip export test");
    }

    public void testMultiStatement() throws IOException, SQLException {
        int TOTAL_RECORDS = 20;
        this.createTextFile(0, 20, true, new ColumnGenerator[0]);
        this.createTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(20);
    }

    public void testMultiTransaction() throws IOException, SQLException {
        int TOTAL_RECORDS = 20;
        this.createTextFile(0, 20, true, new ColumnGenerator[0]);
        this.createTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 5, 2, new String[0]));
        this.verifyExport(20);
    }

    public void testMultiTransactionWithStaging() throws IOException, SQLException {
        int TOTAL_RECORDS = 20;
        this.createTextFile(0, 20, true, new ColumnGenerator[0]);
        this.createTable(new ColumnGenerator[0]);
        this.createStagingTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 5, 2, "--staging-table", this.getStagingTableName()));
        this.verifyExport(20);
    }

    public void testUnlimitedTransactionSize() throws IOException, SQLException {
        int TOTAL_RECORDS = 20;
        this.createTextFile(0, 20, true, new ColumnGenerator[0]);
        this.createTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 5, -1, new String[0]));
        this.verifyExport(20);
    }

    public void testMultiMapTextExport() throws IOException, SQLException {
        int RECORDS_PER_MAP = 10;
        int NUM_FILES = 2;
        for (int f = 0; f < 2; ++f) {
            this.createTextFile(f, 10, false, new ColumnGenerator[0]);
        }
        this.createTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(20);
    }

    public void testMultiMapTextExportWithStaging() throws IOException, SQLException {
        int RECORDS_PER_MAP = 10;
        int NUM_FILES = 2;
        for (int f = 0; f < 2; ++f) {
            this.createTextFile(f, 10, false, new ColumnGenerator[0]);
        }
        this.createTable(new ColumnGenerator[0]);
        this.createStagingTable(new ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, "--staging-table", this.getStagingTableName()));
        this.verifyExport(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequenceFileExport() throws Exception {
        int TOTAL_RECORDS = 10;
        LOG.info((Object)"Creating initial schema for SeqFile test");
        this.createTable(new ColumnGenerator[0]);
        LOG.info((Object)"Generating code...");
        CodeGenTool codeGen = new CodeGenTool();
        String[] codeGenArgs = this.getCodeGenArgv(new String[0]);
        SqoopOptions options = codeGen.parseArguments(codeGenArgs, null, null, true);
        codeGen.validateOptions(options);
        int ret = codeGen.run(options);
        TestExport.assertEquals((int)0, (int)ret);
        List generatedJars = codeGen.getGeneratedJarFiles();
        LOG.info((Object)"Resetting schema and data...");
        this.createTable(new ColumnGenerator[0]);
        this.removeTablePath();
        TestExport.assertNotNull((Object)generatedJars);
        TestExport.assertEquals((String)"Expected 1 generated jar file", (int)1, (int)generatedJars.size());
        String jarFileName = (String)generatedJars.get(0);
        Path jarPath = new Path(jarFileName);
        String jarBaseName = jarPath.getName();
        TestExport.assertTrue((boolean)jarBaseName.endsWith(".jar"));
        TestExport.assertTrue((jarBaseName.length() > ".jar".length() ? 1 : 0) != 0);
        String className = jarBaseName.substring(0, jarBaseName.length() - ".jar".length());
        LOG.info((Object)("Using jar filename: " + jarFileName));
        LOG.info((Object)("Using class name: " + className));
        ClassLoader prevClassLoader = null;
        try {
            if (null != jarFileName) {
                prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)className);
            }
            LOG.info((Object)"Writing data to SequenceFiles");
            this.createSequenceFile(0, 10, className);
            LOG.info((Object)"Exporting SequenceFile-based data");
            this.runExport(this.getArgv(true, 10, 10, "--class-name", className, "--jar-file", jarFileName));
            this.verifyExport(10);
        }
        finally {
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
            }
        }
    }

    public void testIntCol() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        ColumnGenerator gen = new ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                return "" + rowNum;
            }

            @Override
            public String getVerifyText(int rowNum) {
                return "" + rowNum;
            }

            @Override
            public String getType() {
                return "INTEGER";
            }
        };
        this.createTextFile(0, 10, false, gen);
        this.createTable(gen);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(10);
        this.assertColMinAndMax(this.forIdx(0), gen);
    }

    protected String getBigIntType() {
        return "BIGINT";
    }

    public void testBigIntCol() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        ColumnGenerator gen = new ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                long val = (long)rowNum * 1000000000L;
                return "" + val;
            }

            @Override
            public String getVerifyText(int rowNum) {
                long val = (long)rowNum * 1000000000L;
                return "" + val;
            }

            @Override
            public String getType() {
                return TestExport.this.getBigIntType();
            }
        };
        this.createTextFile(0, 10, false, gen);
        this.createTable(gen);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(10);
        this.assertColMinAndMax(this.forIdx(0), gen);
    }

    protected String pad(int n) {
        if (n <= 9) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    protected ColumnGenerator getDateColumnGenerator() {
        return new ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                int day = rowNum + 1;
                return "2009-10-" + TestExport.this.pad(day);
            }

            @Override
            public String getVerifyText(int rowNum) {
                int day = rowNum + 1;
                return "2009-10-" + TestExport.this.pad(day);
            }

            @Override
            public String getType() {
                return "DATE";
            }
        };
    }

    protected ColumnGenerator getTimeColumnGenerator() {
        return new ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                return "10:01:" + TestExport.this.pad(rowNum);
            }

            @Override
            public String getVerifyText(int rowNum) {
                return "10:01:" + TestExport.this.pad(rowNum);
            }

            @Override
            public String getType() {
                return "TIME";
            }
        };
    }

    public void testDatesAndTimes() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        ColumnGenerator genDate = this.getDateColumnGenerator();
        ColumnGenerator genTime = this.getTimeColumnGenerator();
        this.createTextFile(0, 10, false, genDate, genTime);
        this.createTable(genDate, genTime);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(10);
        this.assertColMinAndMax(this.forIdx(0), genDate);
        this.assertColMinAndMax(this.forIdx(1), genTime);
    }

    public void testNumericTypes() throws IOException, SQLException {
        int TOTAL_RECORDS = 9;
        ColumnGenerator genFloat = new ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                double v = 3.141 * (double)(rowNum + 1);
                return "" + v;
            }

            @Override
            public String getVerifyText(int rowNum) {
                double v = 3.141 * (double)(rowNum + 1);
                return "" + v;
            }

            @Override
            public String getType() {
                return "FLOAT";
            }
        };
        ColumnGenerator genNumeric = new ColumnGenerator(){

            @Override
            public String getExportText(int rowNum) {
                int digit = rowNum + 1;
                return "2.718" + digit;
            }

            @Override
            public String getVerifyText(int rowNum) {
                int digit = rowNum + 1;
                return "2.718" + digit;
            }

            @Override
            public String getType() {
                return "NUMERIC(6,4)";
            }
        };
        this.createTextFile(0, 9, false, genFloat, genNumeric);
        this.createTable(genFloat, genNumeric);
        this.runExport(this.getArgv(true, 10, 10, new String[0]));
        this.verifyExport(9);
        this.assertColMinAndMax(this.forIdx(0), genFloat);
        this.assertColMinAndMax(this.forIdx(1), genNumeric);
    }

    public void testColumnsExport() throws IOException, SQLException {
        this.testColumnsExport("id,msg," + this.forIdx(0) + "," + this.forIdx(2));
    }

    protected void testColumnsExport(String columnsStr) throws IOException, SQLException {
        int TOTAL_COLUMNS = 3;
        int TOTAL_RECORDS = 10;
        class MultiColumnGenerator
        implements ColumnGenerator {
            private int col;

            MultiColumnGenerator(int col) {
                this.col = col;
            }

            @Override
            public String getExportText(int rowNum) {
                return new Integer(rowNum * 3 + this.col).toString();
            }

            @Override
            public String getVerifyText(int rowNum) {
                return new Integer(rowNum * 3 + this.col).toString();
            }

            @Override
            public String getType() {
                return "INTEGER";
            }
        }
        MultiColumnGenerator gen0 = new MultiColumnGenerator(0);
        MultiColumnGenerator gen1 = new MultiColumnGenerator(1);
        MultiColumnGenerator gen2 = new MultiColumnGenerator(2);
        this.createTextFile(0, 10, false, gen0, gen2);
        this.createTable(gen0, gen1, gen2);
        this.runExport(this.getArgv(true, 10, 10, "--columns", columnsStr));
        class NullColumnGenerator
        implements ColumnGenerator {
            NullColumnGenerator() {
            }

            @Override
            public String getExportText(int rowNum) {
                return null;
            }

            @Override
            public String getVerifyText(int rowNum) {
                return null;
            }

            @Override
            public String getType() {
                return "INTEGER";
            }
        }
        NullColumnGenerator genNull = new NullColumnGenerator();
        this.verifyExport(10);
        this.assertColMinAndMax(this.forIdx(0), gen0);
        this.assertColMinAndMax(this.forIdx(2), gen2);
        this.assertColMinAndMax(this.forIdx(1), genNull);
    }

    public static interface ColumnGenerator {
        public String getExportText(int var1);

        public String getVerifyText(int var1);

        public String getType();
    }
}

