/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import com.cloudera.sqoop.SqoopOptions;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.validation.AbortOnFailureHandler;
import org.apache.sqoop.validation.RowCountValidator;
import org.apache.sqoop.validation.ValidationContext;
import org.apache.sqoop.validation.ValidationException;

public class AbortOnFailureHandlerTest
extends TestCase {
    public void testAbortOnFailureHandlerIsDefaultOption() {
        AbortOnFailureHandlerTest.assertEquals(AbortOnFailureHandler.class, (Object)new SqoopOptions(new Configuration()).getValidationFailureHandlerClass());
    }

    public void testAbortOnFailureHandlerAborting() {
        try {
            RowCountValidator validator = new RowCountValidator();
            validator.validate(new ValidationContext(100L, 90L));
            AbortOnFailureHandlerTest.fail((String)"AbortOnFailureHandler should have thrown an exception");
        }
        catch (ValidationException e) {
            AbortOnFailureHandlerTest.assertEquals((String)"Validation failed by RowCountValidator. Reason: The expected counter value was 100 but the actual value was 90, Row Count at Source: 100, Row Count at Target: 90", (String)e.getMessage());
        }
    }

    public void testAbortOnFailureHandlerNotAborting() {
        try {
            RowCountValidator validator = new RowCountValidator();
            validator.validate(new ValidationContext(100L, 100L));
        }
        catch (ValidationException e) {
            AbortOnFailureHandlerTest.fail((String)"AbortOnFailureHandler should NOT have thrown an exception");
        }
    }
}

