/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.sqlserver;

import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerUpsertOutputFormat;
import org.hsqldb.jdbcDriver;
import org.junit.Assert;
import org.junit.Test;

public class SqlServerUpsertOutputFormatTest {
    @Test
    public void Merge_statement_is_parameterized_correctly() throws Exception {
        SqlServerUpsertOutputFormat outputFormat;
        Configuration conf = new Configuration();
        conf.set("mapred.jdbc.driver.class", jdbcDriver.class.getName());
        conf.set("mapred.jdbc.url", "jdbc:hsqldb:.");
        conf.set("sqoop.mapreduce.export.update.col", "");
        conf.set("mapred.jdbc.output.field.names", "");
        String tableName = "#myTable";
        Object[] columnNames = new String[]{"FirstColumn", "SecondColumn", "ThirdColumn"};
        Object[] updateKeyColumns = new String[]{"FirstColumn"};
        conf.set("mapred.jdbc.output.table.name", tableName);
        conf.set("mapred.jdbc.output.field.names", StringUtils.join((Object[])columnNames, (char)','));
        conf.set("sqoop.mapreduce.export.update.col", StringUtils.join((Object[])updateKeyColumns, (char)','));
        conf.set("org.apache.sqoop.manager.sqlserver.table.hints", "NOLOCK");
        conf.set("org.apache.sqoop.manager.sqlserver.table.identity", "true");
        TaskAttemptContext context = null;
        Class<?> cls = null;
        try {
            cls = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (cls == null) {
            try {
                cls = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContext");
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        Assert.assertNotNull(cls);
        Constructor<?> c = cls.getConstructor(Configuration.class, TaskAttemptID.class);
        context = (TaskAttemptContext)c.newInstance(conf, new TaskAttemptID());
        SqlServerUpsertOutputFormat sqlServerUpsertOutputFormat = outputFormat = new SqlServerUpsertOutputFormat();
        sqlServerUpsertOutputFormat.getClass();
        SqlServerUpsertOutputFormat.SqlServerUpsertRecordWriter recordWriter = new SqlServerUpsertOutputFormat.SqlServerUpsertRecordWriter(sqlServerUpsertOutputFormat, context);
        Assert.assertEquals((Object)"SET IDENTITY_INSERT #myTable ON MERGE INTO #myTable AS _target USING ( VALUES ( ?, ?, ? ) ) AS _source ( FirstColumn, SecondColumn, ThirdColumn ) ON _source.FirstColumn = _target.FirstColumn  WHEN MATCHED THEN UPDATE SET _target.SecondColumn = _source.SecondColumn, _target.ThirdColumn = _source.ThirdColumn  WHEN NOT MATCHED THEN INSERT ( FirstColumn, SecondColumn, ThirdColumn ) VALUES ( _source.FirstColumn, _source.SecondColumn, _source.ThirdColumn ) OPTION (NOLOCK);", (Object)recordWriter.getUpdateStatement());
    }
}

