/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.mapreduce.AvroImportMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetImportMapper;
import org.apache.sqoop.mapreduce.mainframe.MainframeImportJob;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMainframeImportJob {
    private MainframeImportJob mfImportJob;
    private MainframeImportJob avroImportJob;
    private SqoopOptions options;

    @Before
    public void setUp() {
        this.options = new SqoopOptions();
    }

    @Test
    public void testGetMainframeDatasetImportMapperClass() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String jarFile = "dummyJarFile";
        String tableName = "dummyTableName";
        Path path = new Path("dummyPath");
        ImportJobContext context = new ImportJobContext(tableName, jarFile, this.options, path);
        this.mfImportJob = new MainframeImportJob(this.options, context);
        Class[] types = new Class[]{};
        Method m_getMapperClass = MainframeImportJob.class.getDeclaredMethod("getMapperClass", types);
        m_getMapperClass.setAccessible(true);
        Class mapper = (Class)m_getMapperClass.invoke((Object)this.mfImportJob, new Object[0]);
        Assert.assertEquals((Object)mapper, MainframeDatasetImportMapper.class);
    }

    @Test
    public void testSuperMapperClass() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String jarFile = "dummyJarFile";
        String tableName = "dummyTableName";
        Path path = new Path("dummyPath");
        this.options.setFileLayout(SqoopOptions.FileLayout.AvroDataFile);
        ImportJobContext context = new ImportJobContext(tableName, jarFile, this.options, path);
        this.avroImportJob = new MainframeImportJob(this.options, context);
        Class[] types = new Class[]{};
        Method m_getMapperClass = MainframeImportJob.class.getDeclaredMethod("getMapperClass", types);
        m_getMapperClass.setAccessible(true);
        Class mapper = (Class)m_getMapperClass.invoke((Object)this.avroImportJob, new Object[0]);
        Assert.assertEquals((Object)mapper, AvroImportMapper.class);
    }
}

