/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.ReparseMapper;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;

public class SQLServerParseMethodsManualTest
extends ImportJobTestCase {
    @Override
    public void setUp() {
        super.setUp();
        Path p = new Path(this.getWarehouseDir());
        try {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            fs.delete(p);
        }
        catch (IOException e) {
            LOG.error((Object)("Setup fail with IOException: " + StringUtils.stringifyException((Throwable)e)));
            SQLServerParseMethodsManualTest.fail((String)("Setup fail with IOException: " + StringUtils.stringifyException((Throwable)e)));
        }
    }

    private String[] getArgv(boolean includeHadoopFlags, String fieldTerminator, String lineTerminator, String encloser, String escape, boolean encloserRequired) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--as-textfile");
        args.add("--split-by");
        args.add("DATA_COL0");
        args.add("--fields-terminated-by");
        args.add(fieldTerminator);
        args.add("--lines-terminated-by");
        args.add(lineTerminator);
        args.add("--escaped-by");
        args.add(escape);
        if (encloserRequired) {
            args.add("--enclosed-by");
        } else {
            args.add("--optionally-enclosed-by");
        }
        args.add(encloser);
        args.add("--num-mappers");
        args.add("1");
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runParseTest(String fieldTerminator, String lineTerminator, String encloser, String escape, boolean encloseRequired) throws IOException {
        ClassLoader prevClassLoader = null;
        String[] argv = this.getArgv(true, fieldTerminator, lineTerminator, encloser, escape, encloseRequired);
        this.runImport(argv);
        try {
            String tableClassName = this.getTableName();
            argv = this.getArgv(false, fieldTerminator, lineTerminator, encloser, escape, encloseRequired);
            SqoopOptions opts = new ImportTool().parseArguments(argv, null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)tableClassName);
            JobConf job = new JobConf();
            job.setJar(jarFileName);
            job.set("sqoop.user.class", tableClassName);
            ConfigurationHelper.setJobtrackerAddr((Configuration)job, (String)"local");
            job.set("fs.default.name", "file:///");
            String warehouseDir = this.getWarehouseDir();
            Path warehousePath = new Path(warehouseDir);
            Path inputPath = new Path(warehousePath, this.getTableName());
            Path outputPath = new Path(warehousePath, this.getTableName() + "-out");
            job.setMapperClass(ReparseMapper.class);
            job.setNumReduceTasks(0);
            FileInputFormat.addInputPath((JobConf)job, (Path)inputPath);
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(NullWritable.class);
            JobClient.runJob((JobConf)job);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)ioe));
            SQLServerParseMethodsManualTest.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)pe));
            SQLServerParseMethodsManualTest.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testDefaults() throws IOException {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "INTEGER"};
        String[] vals = new String[]{"64", "'foo'", "128"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\\"", "\\", false);
    }

    public void testRequiredEnclose() throws IOException {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "INTEGER"};
        String[] vals = new String[]{"64", "'foo'", "128"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\\"", "\\", true);
    }

    public void testStringEscapes() throws IOException {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] vals = new String[]{"'foo'", "'foo,bar'", "'foo''bar'", "'foo\\bar'", "'foo,bar''baz'"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\'", "\\", false);
    }

    public void testNumericTypes() throws IOException {
        String[] types = new String[]{"INTEGER", "REAL", "FLOAT", "DATE", "TIME", "BIT"};
        String[] vals = new String[]{"42", "36.0", "127.1", "'2009-07-02'", "'11:24:00'", "1"};
        this.createTableWithColTypes(types, vals);
        this.runParseTest(",", "\\n", "\\'", "\\", false);
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opts;
    }
}

