/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle.util;

import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.sqoop.manager.oracle.util.OraOopTestDataGenerator;

public class TimestampGenerator
extends OraOopTestDataGenerator<Timestamp> {
    private static final int NANOS_DIGITS = 9;
    private static final int MIN_YEAR = -4711;
    private static final int MAX_YEAR = 9999;
    private final int precision;
    private final Calendar cal = Calendar.getInstance();

    public TimestampGenerator(int precision) {
        this.precision = precision;
    }

    @Override
    public Timestamp next() {
        this.cal.clear();
        this.cal.set(1, -4711 + this.rng.nextInt(14711));
        this.cal.set(6, 1 + this.rng.nextInt(this.cal.getActualMaximum(6)));
        this.cal.set(11, this.rng.nextInt(24));
        this.cal.set(12, this.rng.nextInt(60));
        this.cal.set(13, this.rng.nextInt(this.cal.getActualMaximum(13)));
        if (this.cal.get(0) == 0 && this.cal.get(2) == 1 && this.cal.get(5) >= 28) {
            return this.next();
        }
        Timestamp timestamp = new Timestamp(this.cal.getTimeInMillis());
        if (this.precision > 0) {
            int nanos = this.rng.nextInt((int)Math.pow(10.0, this.precision));
            timestamp.setNanos(nanos * (int)Math.pow(10.0, 9 - this.precision));
        }
        return timestamp;
    }
}

