/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import org.apache.sqoop.manager.oracle.OraOopJdbcUrl;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOraOopJdbcUrl
extends OraOopTestCase {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testParseJdbcOracleThinConnectionString() {
        OraOopUtilities.JdbcOracleThinConnection actual;
        try {
            actual = new OraOopJdbcUrl(null).parseJdbcOracleThinConnectionString();
            junit.framework.Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        try {
            actual = new OraOopJdbcUrl("").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:oci8:@dbname.domain").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.fail((String)"A JdbcOracleThinConnectionParsingError should be been thrown.");
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            Assert.assertTrue((String)"An exception should be thown that tells us there's an incorrect number of fragments in the JDBC URL.", (boolean)ex.getMessage().toLowerCase().contains("the oracle \"thin\" jdbc driver is not being used."));
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:loremipsum:@hostname.domain.com.au:port1521:dbsid").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.fail((String)"A JdbcOracleThinConnectionParsingError should be been thrown.");
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            Assert.assertTrue((String)"An exception should be thown that refers to the fact that the thin JDBC driver is not being used.", (boolean)ex.getMessage().toLowerCase().contains("oracle \"thin\" jdbc driver is not being used"));
            Assert.assertTrue((String)"An exception should be thown that tells us which JDBC driver was specified.", (boolean)ex.getMessage().toLowerCase().contains("loremipsum"));
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@hostname.domain.com.au:port1521:dbsid").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.fail((String)"An JdbcOracleThinConnectionParsingError should be been thrown.");
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            Assert.assertTrue((String)"The invalid port number should be included in the exception message.", (boolean)ex.getMessage().toLowerCase().contains("port1521"));
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@hostname.domain.com.au:-1521:dbsid").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.fail((String)"An JdbcOracleThinConnectionParsingError should be been thrown.");
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            Assert.assertTrue((String)"The invalid port number should be included in the exception message.", (boolean)ex.getMessage().toLowerCase().contains("-1521"));
        }
        try {
            actual = new OraOopJdbcUrl("JDBC:Oracle:tHiN:@hostname.domain.com.au:1521:dbsid").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname.domain.com.au", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1521, (int)actual.getPort());
            junit.framework.Assert.assertEquals((String)"dbsid", (String)actual.getSid());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
        try {
            actual = new OraOopJdbcUrl(" JDBC : Oracle : tHiN : @hostname.domain.com.au : 1529 : dbsid").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname.domain.com.au", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1529, (int)actual.getPort());
            junit.framework.Assert.assertEquals((String)"dbsid", (String)actual.getSid());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@hostname:1521:dbsid?param1=loremipsum").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1521, (int)actual.getPort());
            junit.framework.Assert.assertEquals((String)"dbsid", (String)actual.getSid());
            junit.framework.Assert.assertEquals(null, (String)actual.getService());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@hostname:1521/dbservice.dbdomain").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1521, (int)actual.getPort());
            junit.framework.Assert.assertEquals(null, (String)actual.getSid());
            junit.framework.Assert.assertEquals((String)"dbservice.dbdomain", (String)actual.getService());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@//hostname:1521/dbservice.dbdomain").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1521, (int)actual.getPort());
            junit.framework.Assert.assertEquals(null, (String)actual.getSid());
            junit.framework.Assert.assertEquals((String)"dbservice.dbdomain", (String)actual.getService());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@hostname:1521/dbservice.dbdomain?param1=loremipsum").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1521, (int)actual.getPort());
            junit.framework.Assert.assertEquals(null, (String)actual.getSid());
            junit.framework.Assert.assertEquals((String)"dbservice.dbdomain", (String)actual.getService());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
        try {
            actual = new OraOopJdbcUrl("jdbc:oracle:thin:@//hostname:1521/dbservice.dbdomain?param1=loremipsum").parseJdbcOracleThinConnectionString();
            junit.framework.Assert.assertEquals((String)"hostname", (String)actual.getHost());
            junit.framework.Assert.assertEquals((int)1521, (int)actual.getPort());
            junit.framework.Assert.assertEquals(null, (String)actual.getSid());
            junit.framework.Assert.assertEquals((String)"dbservice.dbdomain", (String)actual.getService());
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetConnectionUrl() {
        String actual;
        try {
            actual = new OraOopJdbcUrl(null).getConnectionUrl();
            junit.framework.Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            actual = new OraOopJdbcUrl("").getConnectionUrl();
            junit.framework.Assert.fail((String)"An IllegalArgumentException should be been thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        actual = new OraOopJdbcUrl("jdbc:oracle:thin:@hostname.domain:1521:dbsid").getConnectionUrl();
        junit.framework.Assert.assertEquals((String)"jdbc:oracle:thin:@hostname.domain:1521:dbsid", (String)actual);
    }
}

