/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestBigDecimalImport
extends ImportJobTestCase {
    private String runBigDecimalImport(List<String> extraArgs) throws IOException {
        String[] types = new String[]{"DECIMAL", "NUMERIC"};
        String[] vals = new String[]{"0.000001", "0.0000001"};
        this.createTableWithColTypes(types, vals);
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        if (extraArgs != null) {
            args.addAll(extraArgs);
        }
        args.add("--table");
        args.add(this.getTableName());
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("-m");
        args.add("1");
        this.runImport(args.toArray(new String[args.size()]));
        Path outputFile = this.getDataFilePath();
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        FSDataInputStream stream = fs.open(outputFile);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream));
        String line = reader.readLine();
        reader.close();
        return line;
    }

    public void testBigDecimalDefault() throws IOException {
        String line = this.runBigDecimalImport(null);
        TestBigDecimalImport.assertEquals((String)"0.000001,0.0000001", (String)line);
    }

    public void testBigDecimalNoFormat() throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Dsqoop.bigdecimal.format.string=false");
        String line = this.runBigDecimalImport(args);
        TestBigDecimalImport.assertEquals((String)"0.000001,1E-7", (String)line);
    }
}

