/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.util.ReflectionUtils;

public final class SeqFileReader {
    public static final Log LOG = LogFactory.getLog((String)SeqFileReader.class.getName());

    private SeqFileReader() {
    }

    public static SequenceFile.Reader getSeqFileReader(String filename) throws IOException {
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info((Object)("Opening SequenceFile " + filename));
        return new SequenceFile.Reader(fs, new Path(filename), conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFirstValue(String filename) throws IOException {
        SequenceFile.Reader r = null;
        try {
            Configuration conf = new Configuration();
            if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
                conf.set("fs.defaultfs.name", "file:///");
            }
            FileSystem fs = FileSystem.get((Configuration)conf);
            r = new SequenceFile.Reader(fs, new Path(filename), conf);
            Object key = ReflectionUtils.newInstance((Class)r.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)r.getValueClass(), (Configuration)conf);
            LOG.info((Object)("Reading value of type " + r.getValueClassName() + " from SequenceFile " + filename));
            r.next(key);
            r.getCurrentValue(val);
            LOG.info((Object)("Value as string: " + val.toString()));
            Object object = val;
            return object;
        }
        finally {
            if (null != r) {
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException during close: " + ioe.toString()));
                }
            }
        }
    }
}

