/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.ConnFactory;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.SQLServerManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ExportJobTestCase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Before;

public class SQLServerManagerExportManualTest
extends ExportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)SQLServerManagerExportManualTest.class.getName());
    static final String HOST_URL = System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    static final String DATABASE_NAME = "SQOOPTEST";
    static final String DATABASE_USER = "SQOOPUSER";
    static final String DATABASE_PASSWORD = "PASSWORD";
    static final String SCHEMA_DBO = "dbo";
    static final String DBO_TABLE_NAME = "EMPLOYEES_MSSQL";
    static final String DBO_BINARY_TABLE_NAME = "BINARYTYPE_MSSQL";
    static final String SCHEMA_SCH = "sch";
    static final String SCH_TABLE_NAME = "PRIVATE_TABLE";
    static final String CONNECT_STRING = HOST_URL + ";databaseName=" + "SQOOPTEST";
    static final String CONNECTOR_FACTORY = System.getProperty("sqoop.test.msserver.connector.factory", ConnFactory.DEFAULT_FACTORY_CLASS_NAMES);
    private SQLServerManager manager;
    private Configuration conf = new Configuration();
    private Connection conn = null;

    @Override
    protected Configuration getConf() {
        return this.conf;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(CONNECT_STRING, DBO_TABLE_NAME);
        options.setUsername(DATABASE_USER);
        options.setPassword(DATABASE_PASSWORD);
        this.manager = new SQLServerManager(options);
        this.createTableAndPopulateData(SCHEMA_DBO, DBO_TABLE_NAME);
        this.createTableAndPopulateData(SCHEMA_SCH, SCH_TABLE_NAME);
        this.conf.setStrings("sqoop.connection.factories", new String[]{CONNECTOR_FACTORY});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableAndPopulateData(String schema, String table) {
        String fulltableName = this.manager.escapeObjectName(schema) + "." + this.manager.escapeObjectName(table);
        Statement stmt = null;
        try {
            this.conn = this.manager.getConnection();
            stmt = this.conn.createStatement();
            stmt.execute("CREATE SCHEMA " + schema);
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Can't create schema: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            this.conn = this.manager.getConnection();
            stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE " + fulltableName);
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Table was not dropped: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
            stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + fulltableName + " (" + "id INT NOT NULL, " + "name VARCHAR(24) NOT NULL, " + "salary FLOAT, " + "dept VARCHAR(32), " + "PRIMARY KEY (id))");
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)"Encountered SQL Exception: ", (Throwable)sqlE);
            sqlE.printStackTrace();
            SQLServerManagerExportManualTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing connection/stmt", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSQLServerBinaryTypeTable(String schema, String table) {
        String fulltableName = this.manager.escapeObjectName(schema) + "." + this.manager.escapeObjectName(table);
        Statement stmt = null;
        try {
            this.conn = this.manager.getConnection();
            stmt = this.conn.createStatement();
            stmt.execute("CREATE SCHEMA " + schema);
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Can't create schema: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            this.conn = this.manager.getConnection();
            stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE " + fulltableName);
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Table was not dropped: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
            stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + fulltableName + " (" + "id INT PRIMARY KEY, " + "b1 BINARY(10), " + "b2 VARBINARY(10))");
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)"Encountered SQL Exception: ", (Throwable)sqlE);
            sqlE.printStackTrace();
            SQLServerManagerExportManualTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing connection/stmt", (Throwable)ex);
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.conn.close();
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            SQLServerManagerExportManualTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    private String[] getArgv(String tableName, String ... extraArgs) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--table");
        args.add(tableName);
        args.add("--export-dir");
        args.add(this.getWarehouseDir());
        args.add("--fields-terminated-by");
        args.add(",");
        args.add("--lines-terminated-by");
        args.add("\\n");
        args.add("--connect");
        args.add(CONNECT_STRING);
        args.add("--username");
        args.add(DATABASE_USER);
        args.add("--password");
        args.add(DATABASE_PASSWORD);
        args.add("-m");
        args.add("1");
        for (String arg : extraArgs) {
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    protected void createTestFile(String filename, String[] lines) throws IOException {
        new File(this.getWarehouseDir()).mkdirs();
        File file = new File(this.getWarehouseDir() + "/" + filename);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        for (String line : lines) {
            output.write(line);
            output.write("\n");
        }
        ((Writer)output).close();
    }

    public void testExport() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,400,sales", "3,Fred,15,marketing"});
        this.runExport(this.getArgv(DBO_TABLE_NAME, new String[0]));
        SQLServerManagerExportManualTest.assertRowCount(2L, this.escapeObjectName(DBO_TABLE_NAME), this.conn);
    }

    public void testExportCustomSchema() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,400,sales", "3,Fred,15,marketing"});
        String[] extra = new String[]{"--", "--schema", SCHEMA_SCH};
        this.runExport(this.getArgv(SCH_TABLE_NAME, extra));
        SQLServerManagerExportManualTest.assertRowCount(2L, this.escapeObjectName(SCHEMA_SCH) + "." + this.escapeObjectName(SCH_TABLE_NAME), this.conn);
    }

    public void testExportTableHints() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,400,sales", "3,Fred,15,marketing"});
        String[] extra = new String[]{"--", "--table-hints", "ROWLOCK"};
        this.runExport(this.getArgv(DBO_TABLE_NAME, extra));
        SQLServerManagerExportManualTest.assertRowCount(2L, this.escapeObjectName(DBO_TABLE_NAME), this.conn);
    }

    public void testExportTableHintsMultiple() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,400,sales", "3,Fred,15,marketing"});
        String[] extra = new String[]{"--", "--table-hints", "ROWLOCK,NOWAIT"};
        this.runExport(this.getArgv(DBO_TABLE_NAME, extra));
        SQLServerManagerExportManualTest.assertRowCount(2L, this.escapeObjectName(DBO_TABLE_NAME), this.conn);
    }

    public void testSQLServerBinaryType() throws IOException, SQLException {
        this.createSQLServerBinaryTypeTable(SCHEMA_DBO, DBO_BINARY_TABLE_NAME);
        this.createTestFile("inputFile", new String[]{"1,73 65 63 72 65 74 00 00 00 00,73 65 63 72 65 74"});
        String[] expectedContent = new String[]{"73656372657400000000", "736563726574"};
        this.runExport(this.getArgv(DBO_BINARY_TABLE_NAME, new String[0]));
        SQLServerManagerExportManualTest.assertRowCount(1L, this.escapeObjectName(DBO_BINARY_TABLE_NAME), this.conn);
        SQLServerManagerExportManualTest.checkSQLBinaryTableContent(expectedContent, this.escapeObjectName(DBO_BINARY_TABLE_NAME), this.conn);
    }

    public void testUpsertTextExport() throws IOException, SQLException {
        this.createTestFile("inputFile", new String[]{"2,Bob,400,sales", "3,Fred,15,marketing"});
        this.runExport(this.getArgv(SCH_TABLE_NAME, "--update-key", "id", "--update-mode", "allowinsert"));
        this.runExport(this.getArgv(SCH_TABLE_NAME, "--update-key", "id", "--update-mode", "allowinsert"));
        SQLServerManagerExportManualTest.assertRowCount(2L, this.escapeObjectName(SCH_TABLE_NAME), this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSQLBinaryTableContent(String[] expected, String tableName, Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT TOP 1 [b1], [b2] FROM " + tableName);
            rs.next();
            SQLServerManagerExportManualTest.assertEquals((String)expected[0], (String)rs.getString("b1"));
            SQLServerManagerExportManualTest.assertEquals((String)expected[1], (String)rs.getString("b2"));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't verify table content", (Throwable)e);
            SQLServerManagerExportManualTest.fail();
        }
        finally {
            try {
                connection.commit();
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                LOG.info((Object)"Ignored exception in finally block.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertRowCount(long expected, String tableName, Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM " + tableName);
            rs.next();
            SQLServerManagerExportManualTest.assertEquals((long)expected, (long)rs.getLong(1));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't verify number of rows", (Throwable)e);
            SQLServerManagerExportManualTest.fail();
        }
        finally {
            try {
                connection.commit();
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                LOG.info((Object)"Ignored exception in finally block.");
            }
        }
    }

    public String escapeObjectName(String objectName) {
        return "[" + objectName + "]";
    }
}

