/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.TestExport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.CubridManager;
import org.apache.sqoop.manager.cubrid.CubridTestUtils;
import org.junit.After;
import org.junit.Before;

public class CubridManagerExportTest
extends TestExport {
    public static final Log LOG = LogFactory.getLog((String)CubridManagerExportTest.class.getName());
    static final String TABLE_PREFIX = "EXPORT_CUBRID_";
    private CubridManager manager;
    private Connection conn;

    @Override
    protected Connection getConnection() {
        return this.conn;
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return CubridTestUtils.getConnectString();
    }

    @Override
    protected String getTablePrefix() {
        return TABLE_PREFIX;
    }

    @Override
    protected String getDropTableStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    public void testMultiTransactionWithStaging() throws IOException, SQLException {
    }

    @Override
    public void testMultiMapTextExportWithStaging() throws IOException, SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableAndPopulateData(String table) {
        String fulltableName = this.manager.escapeTableName(table);
        Statement stmt = null;
        try {
            this.conn = this.manager.getConnection();
            stmt = this.conn.createStatement();
            stmt.execute("DROP TABLE IF EXISTS " + fulltableName);
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.info((Object)("Table was not dropped: " + sqlE.getMessage()));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing stmt", (Throwable)ex);
            }
        }
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
            stmt = this.conn.createStatement();
            stmt.executeUpdate("CREATE TABLE " + fulltableName + " (" + "id INT NOT NULL, " + "name VARCHAR(24) NOT NULL, " + "salary FLOAT, " + "dept VARCHAR(32), " + "PRIMARY KEY (id))");
            this.conn.commit();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)"Encountered SQL Exception: ", (Throwable)sqlE);
            sqlE.printStackTrace();
            CubridManagerExportTest.fail((String)("SQLException when running test setUp(): " + sqlE));
        }
        finally {
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing connection/stmt", (Throwable)ex);
            }
        }
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        SqoopOptions options = new SqoopOptions(CubridTestUtils.getConnectString(), this.getTableName());
        options.setUsername(CubridTestUtils.getCurrentUser());
        options.setPassword(CubridTestUtils.getPassword());
        this.manager = new CubridManager(options);
        try {
            this.conn = this.manager.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)sqlE));
            CubridManagerExportTest.fail((String)("Failed with sql exception in setup: " + sqlE));
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        try {
            this.conn.close();
            this.manager.close();
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Got SQLException: " + sqlE.toString()));
            CubridManagerExportTest.fail((String)("Got SQLException: " + sqlE.toString()));
        }
    }

    @Override
    protected String[] getCodeGenArgv(String ... extraArgs) {
        String[] moreArgs = new String[extraArgs.length + 4];
        int i = 0;
        for (i = 0; i < extraArgs.length; ++i) {
            moreArgs[i] = extraArgs[i];
        }
        moreArgs[i++] = "--username";
        moreArgs[i++] = CubridTestUtils.getCurrentUser();
        moreArgs[i++] = "--password";
        moreArgs[i++] = CubridTestUtils.getPassword();
        return super.getCodeGenArgv(moreArgs);
    }

    @Override
    protected String[] getArgv(boolean includeHadoopFlags, int rowsPerStatement, int statementsPerTx, String ... additionalArgv) {
        String[] subArgv = this.newStrArray(additionalArgv, "--username", CubridTestUtils.getCurrentUser(), "--password", CubridTestUtils.getPassword());
        return super.getArgv(includeHadoopFlags, rowsPerStatement, statementsPerTx, subArgv);
    }

    protected void createTestFile(String filename, String[] lines) throws IOException {
        File testdir = new File(this.getWarehouseDir());
        if (!testdir.exists()) {
            testdir.mkdirs();
        }
        File file = new File(this.getWarehouseDir() + "/" + filename);
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        for (String line : lines) {
            output.write(line);
            output.write("\n");
        }
        ((Writer)output).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertRowCount(long expected, String tableName, Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM " + tableName);
            rs.next();
            CubridManagerExportTest.assertEquals((long)expected, (long)rs.getLong(1));
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't verify number of rows", (Throwable)e);
            CubridManagerExportTest.fail();
        }
        finally {
            try {
                connection.commit();
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                LOG.info((Object)"Ignored exception in finally block.");
            }
        }
    }

    public String escapeTableOrSchemaName(String tableName) {
        return "\"" + tableName + "\"";
    }

    public void testUpsertTextExport() throws IOException, SQLException {
        int TOTAL_RECORDS = 10;
        this.createTextFile(0, 10, false, new TestExport.ColumnGenerator[0]);
        this.createTable(new TestExport.ColumnGenerator[0]);
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(null, "--update-key", "id", "--update-mode", "allowinsert")));
        this.runExport(this.getArgv(true, 10, 10, this.newStrArray(null, "--update-key", "id", "--update-mode", "allowinsert")));
        this.verifyExport(10);
    }
}

