/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import com.cloudera.sqoop.testutil.MockResultSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestLargeObjectLoader
extends TestCase {
    protected Configuration conf;
    protected LargeObjectLoader loader;
    protected Path outDir;

    public void setUp() throws IOException, InterruptedException {
        this.conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            this.conf.set("fs.defaultfs.name", "file:///");
        }
        String tmpDir = System.getProperty("test.build.data", "/tmp/");
        this.outDir = new Path(System.getProperty("java.io.tmpdir"));
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        if (fs.exists(this.outDir)) {
            fs.delete(this.outDir, true);
        }
        fs.mkdirs(this.outDir);
        this.loader = new LargeObjectLoader(this.conf, this.outDir);
    }

    public void testReadClobRef() throws IOException, InterruptedException, SQLException {
        MockResultSet resultSet = new MockResultSet();
        ClobRef clob = this.loader.readClobRef(0, (ResultSet)resultSet);
        TestLargeObjectLoader.assertNotNull((Object)clob);
        TestLargeObjectLoader.assertFalse((boolean)clob.isExternal());
        TestLargeObjectLoader.assertEquals((String)"This is the mock clob data!", (String)clob.toString());
        this.conf.setLong("sqoop.inline.lob.length.max", 4L);
        clob = this.loader.readClobRef(0, (ResultSet)resultSet);
        TestLargeObjectLoader.assertNotNull((Object)clob);
        TestLargeObjectLoader.assertTrue((boolean)clob.isExternal());
        this.loader.close();
        Reader r = (Reader)clob.getDataStream(this.conf, this.outDir);
        char[] buf = new char[4096];
        int chars = r.read(buf, 0, 4096);
        r.close();
        String str = new String(buf, 0, chars);
        TestLargeObjectLoader.assertEquals((String)"This is the mock clob data!", (String)str);
    }

    public void testReadBlobRef() throws IOException, InterruptedException, SQLException {
        MockResultSet resultSet = new MockResultSet();
        BlobRef blob = this.loader.readBlobRef(0, (ResultSet)resultSet);
        TestLargeObjectLoader.assertNotNull((Object)blob);
        TestLargeObjectLoader.assertFalse((boolean)blob.isExternal());
        byte[] data = (byte[])blob.getData();
        byte[] blobData = MockResultSet.blobData();
        TestLargeObjectLoader.assertEquals((int)blobData.length, (int)data.length);
        for (int i = 0; i < data.length; ++i) {
            TestLargeObjectLoader.assertEquals((byte)blobData[i], (byte)data[i]);
        }
        this.conf.setLong("sqoop.inline.lob.length.max", 4L);
        blob = this.loader.readBlobRef(0, (ResultSet)resultSet);
        TestLargeObjectLoader.assertNotNull((Object)blob);
        TestLargeObjectLoader.assertTrue((boolean)blob.isExternal());
        this.loader.close();
        InputStream is = (InputStream)blob.getDataStream(this.conf, this.outDir);
        byte[] buf = new byte[4096];
        int bytes = is.read(buf, 0, 4096);
        is.close();
        TestLargeObjectLoader.assertEquals((int)blobData.length, (int)bytes);
        for (int i = 0; i < bytes; ++i) {
            TestLargeObjectLoader.assertEquals((byte)blobData[i], (byte)buf[i]);
        }
    }
}

