/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.lib;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.testutil.BaseSqoopTestCase;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;

public class TestClobRef
extends TestCase {
    public void testEmptyStr() {
        ClobRef r = ClobRef.parse((String)"");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"", (String)r.toString());
    }

    public void testInline() throws IOException {
        ClobRef r = ClobRef.parse((String)"foo");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"foo", (String)r.toString());
        Reader reader = (Reader)r.getDataStream(null, null);
        TestClobRef.assertNotNull((Object)reader);
        char[] buf = new char[4096];
        int chars = reader.read(buf, 0, 4096);
        reader.close();
        String str = new String(buf, 0, chars);
        TestClobRef.assertEquals((String)"foo", (String)str);
    }

    public void testEmptyFile() {
        ClobRef r = ClobRef.parse((String)"externalLob()");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"externalLob()", (String)r.toString());
        r = ClobRef.parse((String)"externalLob(lf,,0,0)");
        TestClobRef.assertTrue((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"externalLob(lf,,0,0)", (String)r.toString());
    }

    public void testInlineNearMatch() {
        ClobRef r = ClobRef.parse((String)"externalLob(foo)bar");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"externalLob(foo)bar", (String)r.toString());
        r = ClobRef.parse((String)"externalLob(foo)");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"externalLob(foo)", (String)((String)r.getData()));
        r = ClobRef.parse((String)"externalLob(lf,foo)");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"externalLob(lf,foo)", (String)((String)r.getData()));
        r = ClobRef.parse((String)"externalLob(lf,foo,1,2)x");
        TestClobRef.assertFalse((boolean)r.isExternal());
        TestClobRef.assertEquals((String)"externalLob(lf,foo,1,2)x", (String)((String)r.getData()));
    }

    public void testExternal() throws IOException {
        String DATA = "This is the clob data!";
        String FILENAME = "clobdata";
        this.doExternalTest("This is the clob data!", "clobdata");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExternalSubdir() throws IOException {
        String DATA = "This is the clob data!";
        String FILENAME = "_lob/clobdata";
        try {
            this.doExternalTest("This is the clob data!", "_lob/clobdata");
        }
        finally {
            Configuration conf = new Configuration();
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            String tmpDir = System.getProperty("test.build.data", "/tmp/");
            Path lobDir = new Path(new Path(tmpDir), "_lob");
            fs.delete(lobDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExternalTest(String data, String filename) throws IOException {
        String tmpDir;
        Path tmpPath;
        Path clobFile;
        Path clobParent;
        FileSystem fs;
        Configuration conf = new Configuration();
        if (!BaseSqoopTestCase.isOnPhysicalCluster()) {
            conf.set("fs.defaultfs.name", "file:///");
        }
        if (!(fs = FileSystem.get((Configuration)conf)).exists(clobParent = (clobFile = new Path(tmpPath = new Path(tmpDir = System.getProperty("test.build.data", "/tmp/")), filename)).getParent())) {
            fs.mkdirs(clobParent);
        }
        LobFile.Writer lw = LobFile.create((Path)clobFile, (Configuration)conf, (boolean)true);
        try {
            long off = lw.tell();
            long len = data.length();
            Writer w = lw.writeClobRecord(len);
            w.append(data);
            w.close();
            lw.close();
            String refString = "externalLob(lf," + filename + "," + off + "," + len + ")";
            ClobRef clob = ClobRef.parse((String)refString);
            TestClobRef.assertTrue((boolean)clob.isExternal());
            TestClobRef.assertEquals((String)refString, (String)clob.toString());
            Reader r = (Reader)clob.getDataStream(conf, tmpPath);
            TestClobRef.assertNotNull((Object)r);
            char[] buf = new char[4096];
            int chars = r.read(buf, 0, 4096);
            r.close();
            String str = new String(buf, 0, chars);
            TestClobRef.assertEquals((String)data, (String)str);
        }
        finally {
            fs.delete(clobFile, false);
        }
    }
}

