/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;

public class TestFreeFormQueryImport
extends ImportJobTestCase {
    private Log log = LogFactory.getLog((String)TestFreeFormQueryImport.class.getName());
    private List<String> tableNames;

    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void tearDown() {
        for (String tableName : this.tableNames) {
            try {
                this.dropTableIfExists(tableName);
            }
            catch (SQLException e) {
                this.log.warn((Object)("Error trying to drop table '" + tableName + "' on tearDown: " + e));
            }
        }
        super.tearDown();
    }

    protected String[] getArgv(String splitByCol, String query) {
        ArrayList<String> args = new ArrayList<String>();
        CommonArgs.addHadoopFlags(args);
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--target-dir");
        args.add(this.getWarehouseDir());
        args.add("--split-by");
        args.add(splitByCol);
        args.add("--num-mappers");
        args.add("2");
        args.add("--query");
        args.add(query);
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleJoin() throws IOException {
        this.tableNames = new ArrayList<String>();
        String[] types1 = new String[]{"SMALLINT"};
        String[] vals1 = new String[]{"1"};
        String tableName1 = this.getTableName();
        this.createTableWithColTypes(types1, vals1);
        this.tableNames.add(tableName1);
        this.incrementTableNum();
        String[] types2 = new String[]{"SMALLINT", "VARCHAR(32)"};
        String[] vals2 = new String[]{"1", "'foo'"};
        String tableName2 = this.getTableName();
        this.createTableWithColTypes(types2, vals2);
        this.tableNames.add(tableName2);
        String query = "SELECT " + tableName1 + "." + this.getColName(0) + ", " + tableName2 + "." + this.getColName(1) + " " + "FROM " + tableName1 + " JOIN " + tableName2 + " ON (" + tableName1 + "." + this.getColName(0) + " = " + tableName2 + "." + this.getColName(0) + ") WHERE " + tableName1 + "." + this.getColName(0) + " < 3 AND $CONDITIONS";
        this.runImport(this.getArgv(tableName1 + "." + this.getColName(0), query));
        Path warehousePath = new Path(this.getWarehouseDir());
        Path filePath = new Path(warehousePath, "part-m-00000");
        String expectedVal = "1,foo";
        BufferedReader reader = null;
        if (!TestFreeFormQueryImport.isOnPhysicalCluster()) {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath.toString()))));
        } else {
            FileSystem dfs = FileSystem.get((Configuration)this.getConf());
            FSDataInputStream dis = dfs.open(filePath);
            reader = new BufferedReader(new InputStreamReader((InputStream)dis));
        }
        try {
            String line = reader.readLine();
            TestFreeFormQueryImport.assertEquals((String)"QueryResult expected a different string", (String)expectedVal, (String)line);
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
    }
}

