/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMainframeDatasetInputSplit {
    private MainframeDatasetInputSplit mfDatasetInputSplit;

    @Before
    public void setUp() {
        this.mfDatasetInputSplit = new MainframeDatasetInputSplit();
    }

    @Test
    public void testGetCurrentDataset() {
        String currentDataset = this.mfDatasetInputSplit.getCurrentDataset();
        Assert.assertNull((Object)currentDataset);
    }

    @Test
    public void testGetNextDatasetWithNull() {
        String currentDataset = this.mfDatasetInputSplit.getNextDataset();
        Assert.assertNull((Object)currentDataset);
    }

    @Test
    public void testGetNextDataset() {
        String mainframeDataset = "test";
        this.mfDatasetInputSplit.addDataset(mainframeDataset);
        String currentDataset = this.mfDatasetInputSplit.getNextDataset();
        Assert.assertEquals((Object)"test", (Object)currentDataset);
    }

    @Test
    public void testHasMoreWithFalse() {
        boolean retVal = this.mfDatasetInputSplit.hasMore();
        Assert.assertFalse((boolean)retVal);
    }

    @Test
    public void testHasMoreWithTrue() {
        String mainframeDataset = "test";
        this.mfDatasetInputSplit.addDataset(mainframeDataset);
        boolean retVal = this.mfDatasetInputSplit.hasMore();
        Assert.assertTrue((boolean)retVal);
    }

    @Test
    public void testGetLength() {
        String mainframeDataset = "test";
        this.mfDatasetInputSplit.addDataset(mainframeDataset);
        try {
            long retVal = this.mfDatasetInputSplit.getLength();
            Assert.assertEquals((long)1L, (long)retVal);
        }
        catch (IOException ioe) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        catch (InterruptedException ie) {
            Assert.fail((String)"No InterruptedException should be thrown!");
        }
    }

    @Test
    public void testGetLocations() {
        try {
            String[] retVal = this.mfDatasetInputSplit.getLocations();
            Assert.assertNotNull((Object)retVal);
        }
        catch (IOException ioe) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        catch (InterruptedException ie) {
            Assert.fail((String)"No InterruptedException should be thrown!");
        }
    }

    @Test
    public void testWriteRead() {
        this.mfDatasetInputSplit.addDataset("dataSet1");
        this.mfDatasetInputSplit.addDataset("dataSet2");
        DataOutputBuffer dob = new DataOutputBuffer();
        DataInputBuffer dib = new DataInputBuffer();
        MainframeDatasetInputSplit mfReader = new MainframeDatasetInputSplit();
        try {
            this.mfDatasetInputSplit.write((DataOutput)dob);
            dib.reset(dob.getData(), dob.getLength());
            mfReader.readFields((DataInput)dib);
            Assert.assertNotNull((String)"MFReader get data from tester", (Object)mfReader);
            Assert.assertEquals((long)2L, (long)mfReader.getLength());
            Assert.assertEquals((Object)"dataSet1", (Object)mfReader.getNextDataset());
            Assert.assertEquals((Object)"dataSet2", (Object)mfReader.getNextDataset());
        }
        catch (IOException ioe) {
            Assert.fail((String)"No IOException should be thrown!");
        }
        catch (InterruptedException ie) {
            Assert.fail((String)"No InterruptedException should be thrown!");
        }
    }
}

