/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.mainframe;

import com.cloudera.sqoop.config.ConfigurationHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.sqoop.lib.SqoopRecord;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputFormat;
import org.apache.sqoop.mapreduce.mainframe.MainframeDatasetInputSplit;
import org.apache.sqoop.util.MainframeFTPClientUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestMainframeDatasetInputFormat {
    private MainframeDatasetInputFormat<SqoopRecord> format;
    private FTPClient mockFTPClient;

    @Before
    public void setUp() {
        this.format = new MainframeDatasetInputFormat();
        this.mockFTPClient = (FTPClient)Mockito.mock(FTPClient.class);
        MainframeFTPClientUtils.setMockFTPClient((FTPClient)this.mockFTPClient);
        try {
            Mockito.when((Object)this.mockFTPClient.login("user", "pssword")).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.logout()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.isConnected()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.completePendingCommand()).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.changeWorkingDirectory(Matchers.anyString())).thenReturn((Object)true);
            Mockito.when((Object)this.mockFTPClient.getReplyCode()).thenReturn((Object)200);
            Mockito.when((Object)this.mockFTPClient.getReplyString()).thenReturn((Object)"");
            Mockito.when((Object)this.mockFTPClient.noop()).thenReturn((Object)200);
            Mockito.when((Object)this.mockFTPClient.setFileType(Matchers.anyInt())).thenReturn((Object)true);
            FTPFile ftpFile1 = new FTPFile();
            ftpFile1.setType(0);
            ftpFile1.setName("test1");
            FTPFile ftpFile2 = new FTPFile();
            ftpFile2.setType(0);
            ftpFile2.setName("test2");
            FTPFile[] ftpFiles = new FTPFile[]{ftpFile1, ftpFile2};
            Mockito.when((Object)this.mockFTPClient.listFiles()).thenReturn((Object)ftpFiles);
        }
        catch (IOException e) {
            Assert.fail((String)"No IOException should be thrown!");
        }
    }

    @After
    public void tearDown() {
        MainframeFTPClientUtils.setMockFTPClient(null);
    }

    @Test
    public void testRetrieveDatasets() throws IOException {
        JobConf conf = new JobConf();
        conf.set("mapreduce.jdbc.url", "localhost:12345");
        conf.set("mapreduce.jdbc.username", "user");
        conf.set("mapreduce.jdbc.password", "pssword");
        Text PASSWORD_SECRET_KEY = new Text("mapreduce.jdbc.password");
        conf.getCredentials().addSecretKey(PASSWORD_SECRET_KEY, "pssword".getBytes());
        String dsName = "dsName1";
        conf.set("mapreduce.mainframe.input.dataset.name", dsName);
        Job job = new Job((Configuration)conf);
        ConfigurationHelper.setJobNumMaps((Job)job, (int)2);
        List splits = new ArrayList();
        splits = this.format.getSplits((JobContext)job);
        Assert.assertEquals((Object)"test1", (Object)((MainframeDatasetInputSplit)splits.get(0)).getNextDataset().toString());
        Assert.assertEquals((Object)"test2", (Object)((MainframeDatasetInputSplit)splits.get(1)).getNextDataset().toString());
    }
}

