/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.Sqoop;
import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.ExportJobTestCase;
import com.cloudera.sqoop.tool.ExportTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestData;
import org.apache.sqoop.manager.sqlserver.MSSQLTestDataFileParser;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;
import org.junit.Before;
import org.junit.Test;

public abstract class ManagerCompatExport
extends ExportJobTestCase {
    private MSSQLTestDataFileParser tdfs;

    public void createTable(MSSQLTestDataFileParser.DATATYPES dt) throws SQLException {
        String tname = this.getTableName(dt);
        String createTableSql = "CREATE TABLE " + tname + " ( " + this.getColName() + " " + dt.toString() + " )";
        this.dropTableIfExists(tname);
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement(createTableSql, 1003, 1007);
        statement.executeUpdate();
        conn.commit();
        statement.close();
    }

    public void createTable(MSSQLTestDataFileParser.DATATYPES dt, MSSQLTestData td) throws Exception {
        String tname = this.getTableName(dt);
        String scale = td.getData(MSSQLTestData.KEY_STRINGS.SCALE);
        String precision = td.getData(MSSQLTestData.KEY_STRINGS.PREC);
        String createTableSql = "";
        if (scale != null && precision != null) {
            createTableSql = "CREATE TABLE " + tname + " (" + this.getColName() + " " + dt.toString() + "(" + scale + "," + precision + ") )";
        } else if (scale != null && precision == null) {
            createTableSql = "CREATE TABLE " + tname + " ( " + this.getColName() + " " + dt.toString() + "(" + scale + ") )";
        } else {
            throw new Exception("Invalid data for create table");
        }
        this.dropTableIfExists(tname);
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement(createTableSql, 1003, 1007);
        statement.executeUpdate();
        conn.commit();
        statement.close();
    }

    public String getColName() {
        return "COL_1";
    }

    public String getTableName(MSSQLTestDataFileParser.DATATYPES dt) {
        return "t_" + dt.toString();
    }

    public Path getTablePath(MSSQLTestDataFileParser.DATATYPES dt) {
        Path warehousePath = new Path(this.getWarehouseDir());
        Path tablePath = new Path(warehousePath, this.getTableName(dt));
        return tablePath;
    }

    public abstract void createFile(MSSQLTestDataFileParser.DATATYPES var1, String[] var2) throws Exception;

    public abstract void createFile(MSSQLTestDataFileParser.DATATYPES var1, String var2) throws Exception;

    public void testVarBinary() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.VARBINARY);
    }

    public void testTime() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.TIME);
    }

    @Test
    public void testSmalldatetime() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.SMALLDATETIME);
    }

    @Test
    public void testdatetime2() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.DATETIME2);
    }

    @Test
    public void testdatetime() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.DATETIME);
    }

    @Test
    public void testdatetimeoffset() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.DATETIMEOFFSET);
    }

    public void testDecimal() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.DECIMAL);
    }

    public void testNumeric() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.NUMERIC);
    }

    @Test
    public void testBigInt() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.BIGINT);
    }

    @Test
    public void testInt() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.INT);
    }

    @Test
    public void testSmallInt() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.SMALLINT);
    }

    @Test
    public void testTinyint() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.TINYINT);
    }

    @Test
    public void testFloat() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.FLOAT);
    }

    @Test
    public void testReal() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.REAL);
    }

    @Test
    public void testDate() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.DATE);
    }

    public void testMoney() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.MONEY);
    }

    @Test
    public void testSmallMoney() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.SMALLMONEY);
    }

    @Test
    public void testText() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.TEXT);
    }

    @Test
    public void testVarchar() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.VARCHAR);
    }

    @Test
    public void testChar() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.CHAR);
    }

    @Test
    public void testNText() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.NTEXT);
    }

    @Test
    public void testNChar() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.NCHAR);
    }

    @Test
    public void testNVarchar() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.NVARCHAR);
    }

    public void testImage() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.IMAGE);
    }

    public void testBinary() {
        this.exportTestMethod(MSSQLTestDataFileParser.DATATYPES.BINARY);
    }

    public void exportTestMethod(MSSQLTestDataFileParser.DATATYPES dt) {
        int exceptionCount = 0;
        List testdata = this.tdfs.getTestdata(dt);
        System.out.println("Total Samples found : " + testdata.size());
        for (MSSQLTestData current : testdata) {
            System.out.println("Testing with : \n" + current);
            try {
                if (dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.INT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.BIGINT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.SMALLINT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.TINYINT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.MONEY) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.SMALLMONEY) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.TIME) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.DATETIME) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.DATE) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.DATETIME2) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.DATETIMEOFFSET) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.REAL) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.FLOAT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.SMALLDATETIME) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.NTEXT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.TEXT) || dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.IMAGE)) {
                    this.createTable(dt);
                    this.createFile(dt, current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                    this.runExport(this.getArgv(dt));
                    this.verifyExport(dt, current.getData(MSSQLTestData.KEY_STRINGS.DB_READBACK));
                    this.addToReport(current, null);
                    continue;
                }
                if (!dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.DECIMAL) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.NUMERIC) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.CHAR) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.VARCHAR) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.NCHAR) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.NVARCHAR) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.VARBINARY) && !dt.equals((Object)MSSQLTestDataFileParser.DATATYPES.BINARY)) continue;
                this.createTable(dt, current);
                this.createFile(dt, current.getData(MSSQLTestData.KEY_STRINGS.HDFS_READBACK));
                this.runExport(this.getArgv(dt));
                this.verifyExport(dt, current.getData(MSSQLTestData.KEY_STRINGS.DB_READBACK));
                this.addToReport(current, null);
            }
            catch (AssertionError ae) {
                if (current.getData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG).equals("NEG")) {
                    System.out.println("failure was expected, PASS");
                    this.addToReport(current, null);
                    continue;
                }
                System.out.println("-----------------------------------------------------------");
                System.out.println("Failure for following Test Data :\n" + current.toString());
                System.out.println("-----------------------------------------------------------");
                System.out.println("Exception details : \n");
                System.out.println(((Throwable)((Object)ae)).getMessage());
                System.out.println("-----------------------------------------------------------");
                this.addToReport(current, ae);
                ++exceptionCount;
            }
            catch (Exception ae) {
                if (current.getData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG).equals("NEG")) {
                    System.out.println("failure was expected, PASS");
                    this.addToReport(current, null);
                    continue;
                }
                System.out.println("-----------------------------------------------------------");
                System.out.println("Failure for following Test Data :\n" + current.toString());
                System.out.println("-----------------------------------------------------------");
                System.out.println("Exception details : \n");
                System.out.println(ae.getMessage());
                System.out.println("-----------------------------------------------------------");
                this.addToReport(current, ae);
                ++exceptionCount;
            }
            catch (Error e) {
                this.addToReport(current, e);
                ++exceptionCount;
            }
        }
        if (exceptionCount > 0) {
            System.out.println("There were failures for :" + dt.toString());
            System.out.println("Failed for " + exceptionCount + "/" + testdata.size() + " test data samples\n");
            System.out.println("Sroll up for detailed errors");
            System.out.println("-----------------------------------------------------------");
            throw new AssertionError((Object)("Failed for " + exceptionCount + " test data sample"));
        }
    }

    public String[] extractData(List data, String negPosFlag, MSSQLTestData.KEY_STRINGS readBackType) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (MSSQLTestData current : data) {
            if (!current.getData(MSSQLTestData.KEY_STRINGS.NEG_POS_FLAG).toString().equals(negPosFlag)) continue;
            filtered.add(current.getData(readBackType));
        }
        String[] ret = new String[filtered.size()];
        filtered.toArray(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyExport(MSSQLTestDataFileParser.DATATYPES dt, String[] data) throws SQLException {
        LOG.info((Object)("Verifying export: " + this.getTableName()));
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT " + this.getColName() + " FROM " + this.getTableName(dt), 1003, 1007);
        System.out.println("data samples being compared : " + data.length);
        ResultSet rs = null;
        try {
            rs = statement.executeQuery();
            int cnt = 0;
            try {
                while (rs.next()) {
                    String tmp = rs.getString(1);
                    String expected = data[cnt++];
                    System.out.println("Readback, expected" + tmp + " :" + expected);
                    if (tmp == null) {
                        ManagerCompatExport.assertNull((String)"Must be null", (Object)expected);
                        continue;
                    }
                    ManagerCompatExport.assertEquals((String)"Data must match", (String)expected, (String)tmp);
                }
                System.out.println("expected samples : " + data.length + " Actual samples : " + cnt);
                ManagerCompatExport.assertEquals((String)"Resultset must contain expected samples", (int)data.length, (int)cnt);
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyNegativeExport(MSSQLTestDataFileParser.DATATYPES dt, String[] data) throws SQLException {
        LOG.info((Object)("Verifying export: " + this.getTableName()));
        Connection conn = this.getManager().getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT " + this.getColName() + " FROM " + this.getTableName(dt), 1003, 1007);
        System.out.println("data samples being compared : " + data.length);
        ResultSet rs = null;
        try {
            rs = statement.executeQuery();
            int cnt = 0;
            try {
                while (rs.next()) {
                    String tmp = rs.getString(1);
                    String expected = data[cnt++];
                    System.out.println("Readback, expected" + tmp + " :" + expected);
                    if (tmp == null) {
                        ManagerCompatExport.assertNull((String)"Must be null", (Object)expected);
                        continue;
                    }
                    ManagerCompatExport.assertNotSame((String)"Data must match", (Object)expected, (Object)tmp);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            statement.close();
        }
    }

    public void verifyExport(MSSQLTestDataFileParser.DATATYPES dt, String data) throws SQLException {
        this.verifyExport(dt, new String[]{data});
    }

    @Override
    protected List<String> runExport(String[] argv) throws IOException {
        int ret;
        List generatedJars = null;
        try {
            ExportTool exporter = new ExportTool();
            Sqoop sqoop = new Sqoop((SqoopTool)exporter);
            String username = MSSQLTestUtils.getDBUserName();
            String password = MSSQLTestUtils.getDBPassWord();
            sqoop.getOptions().setUsername(username);
            sqoop.getOptions().setPassword(password);
            ret = Sqoop.runSqoop((Sqoop)sqoop, (String[])argv);
            generatedJars = exporter.getGeneratedJarFiles();
        }
        catch (Exception e) {
            LOG.error((Object)("Got exception running Sqoop: " + StringUtils.stringifyException((Throwable)e)));
            ret = 1;
        }
        if (0 != ret) {
            throw new IOException("Failure during job; return status " + ret);
        }
        return generatedJars;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String warehouseDir = this.getWarehouseDir();
        Path tablePath = new Path(warehouseDir);
        try {
            String testfile = System.getProperty("test.data.dir") + "/" + System.getProperty("ms.datatype.test.data.file.export");
            String delim = System.getProperty("ms.datatype.test.data.file.delim", ",");
            this.tdfs = new MSSQLTestDataFileParser(testfile);
            this.tdfs.setDelim(delim);
            this.tdfs.parse();
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            System.out.println("Error with test data file;");
            System.out.println("check stack trace for cause.\nTests cannont continue.");
            System.exit(0);
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            fs.delete(tablePath, true);
            System.out.println("Warehouse dir deleted");
        }
        catch (IOException e) {
            LOG.error((Object)("Setup fail with IOException: " + StringUtils.stringifyException((Throwable)e)));
        }
        if (this.useHsqldbTestServer()) {
            try {
                this.getTestServer().dropExistingSchema();
            }
            catch (SQLException sqlE) {
                LOG.error((Object)("Setup fail with SQLException: " + StringUtils.stringifyException((Throwable)sqlE)));
                ManagerCompatExport.fail((String)sqlE.toString());
            }
        }
    }

    @Override
    protected boolean useHsqldbTestServer() {
        return false;
    }

    @Override
    protected String getConnectString() {
        return System.getProperty("sqoop.test.sqlserver.connectstring.host_url", "jdbc:sqlserver://sqlserverhost:1433");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTableIfExists(String table) throws SQLException {
        Connection conn = this.getManager().getConnection();
        System.out.println("DROPing Table " + table);
        String sqlStmt = "IF OBJECT_ID('" + table + "') IS NOT NULL  DROP TABLE " + table;
        PreparedStatement statement = conn.prepareStatement(sqlStmt, 1003, 1007);
        try {
            statement.executeUpdate();
            conn.commit();
        }
        finally {
            statement.close();
        }
    }

    @Override
    protected SqoopOptions getSqoopOptions(Configuration conf) {
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        SqoopOptions opts = new SqoopOptions(conf);
        opts.setUsername(username);
        opts.setPassword(password);
        return opts;
    }

    protected String[] getArgv(MSSQLTestDataFileParser.DATATYPES dt) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--table");
        args.add(this.getTableName(dt));
        args.add("--export-dir");
        args.add(this.getTablePath(dt).toString());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--fields-terminated-by");
        args.add(",");
        args.add("--lines-terminated-by");
        args.add("\\n");
        args.add("-m");
        args.add("1");
        LOG.debug((Object)"args:");
        for (String a : args) {
            LOG.debug((Object)("  " + a));
        }
        return args.toArray(new String[0]);
    }

    public String getOutputFileName() {
        return "ManagerCompatExport.txt";
    }

    public void addToReport(MSSQLTestData td, Object result) {
        try {
            FileWriter fr = new FileWriter(this.getOutputFileName(), true);
            String offset = td.getData(MSSQLTestData.KEY_STRINGS.OFFSET);
            String dt = td.getDatatype();
            String res = "_";
            if (result == null) {
                res = "Success";
            } else {
                try {
                    res = "FAILED " + ManagerCompatExport.removeNewLines(((Throwable)((Object)((AssertionError)result))).getMessage());
                }
                catch (Exception ae) {
                    res = result instanceof Exception ? "FAILED " + ManagerCompatExport.removeNewLines(((Exception)result).getMessage()) : "FAILED " + result.toString();
                }
            }
            fr.append(offset + "\t" + "\t" + res + "\t" + dt + "\t" + ManagerCompatExport.removeNewLines(td.toString()) + "\n");
            fr.close();
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    public static String removeNewLines(String str) {
        if (str != null) {
            String[] tmp = str.split("\n");
            String result = "";
            for (String a : tmp) {
                result = result + " " + a;
            }
            return result;
        }
        return "";
    }
}

