/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.manager.OracleUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopTestCase;
import org.apache.sqoop.manager.oracle.OracleConnectionFactory;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.junit.Assert;
import org.junit.Test;

public class OracleConnectionFactoryTest
extends OraOopTestCase {
    @Test
    public void testSetJdbcFetchSize() {
        this.setAndCheckJdbcFetchSize(45);
        this.setAndCheckJdbcFetchSize(2000);
    }

    private void setAndCheckJdbcFetchSize(int jdbcFetchSize) {
        try {
            Connection conn = this.getConnection();
            String uniqueJunk = new SimpleDateFormat("yyyyMMddHHmmsszzz").format(new Date()) + jdbcFetchSize;
            Configuration conf = new Configuration();
            conf.setInt("oracle.row.fetch.size", jdbcFetchSize);
            boolean logIsBeingCached = OracleConnectionFactory.LOG.getCacheLogEntries();
            OracleConnectionFactory.LOG.setCacheLogEntries(true);
            OraOopOracleQueries.setJdbcFetchSize((Connection)conn, (Configuration)conf);
            OracleConnectionFactory.LOG.setCacheLogEntries(logIsBeingCached);
            String uniqueSql = String.format("select /*%s*/ * from dba_objects", uniqueJunk);
            ResultSet resultSet1 = conn.createStatement().executeQuery(uniqueSql);
            while (resultSet1.next()) {
            }
            ResultSet resultSet2 = conn.createStatement().executeQuery("WITH sqltable AS     (        SELECT executions, rows_processed, fetches,               ROUND (rows_processed / executions, 2) AS rows_per_exec,               ROUND (rows_processed / fetches, 2) AS rows_per_fetch,               ROUND (LEAST (  ROUND (rows_processed / fetches, 2)                             / LEAST (rows_processed / executions, 10),                             1                            ),                      2                     ) batch_efficiency,               sql_text, u.username parsing_schema_name, buffer_gets,               disk_reads, cpu_time/1000 cpu_time, elapsed_time/1000               elapsed_time, hash_value sql_id, child_number          FROM v$sql s join all_users u on (u.user_id=s.parsing_user_id)         WHERE fetches > 0 AND executions > 0 AND rows_processed > 0           AND parsing_schema_id <> 0 AND sql_text like                                                  'select%dba_objects' )SELECT   sql_id, child_number, array_wastage,          rows_processed, fetches, rows_per_exec,         rows_per_fetch, parsing_schema_name, buffer_gets, disk_reads,         cpu_time, elapsed_time, sql_text,executions    FROM (SELECT sql_id,                 child_number,                 rows_processed * (1 - batch_efficiency) array_wastage,                 rows_processed,                 fetches,                 rows_per_exec,                 rows_per_fetch,                 sql_text,                 parsing_schema_name,                 buffer_gets,                 disk_reads,                 cpu_time,                 elapsed_time,                 executions            FROM sqltable) ");
            boolean sqlFound = false;
            double rowsPerFetch = 0.0;
            while (resultSet2.next()) {
                String sqlText = resultSet2.getString("SQL_TEXT");
                if (!sqlText.contains(uniqueJunk)) continue;
                sqlFound = true;
                rowsPerFetch = resultSet2.getDouble("ROWS_PER_FETCH");
                break;
            }
            if (!sqlFound) {
                Assert.fail((String)"Unable to find the performance metrics for the SQL statement being used to check the JDBC fetch size.");
            }
            if (rowsPerFetch < (double)jdbcFetchSize * 0.95 || rowsPerFetch > (double)jdbcFetchSize * 1.05) {
                Assert.fail((String)String.format("The measured JDBC fetch size is not within 5%% of what we expected. Expected=%s rows/fetch, actual=%s rows/fetch", jdbcFetchSize, rowsPerFetch));
            }
        }
        catch (SQLException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testCreateOracleJdbcConnectionBadUserName() {
        try {
            boolean logIsBeingCached = OracleConnectionFactory.LOG.getCacheLogEntries();
            OracleConnectionFactory.LOG.setCacheLogEntries(true);
            OracleConnectionFactory.createOracleJdbcConnection((String)"oracle.jdbc.OracleDriver", (String)OracleUtils.CONNECT_STRING, (String)"invalidusr", (String)"12345");
            OracleConnectionFactory.LOG.setCacheLogEntries(logIsBeingCached);
            Assert.fail((String)"OracleConnectionFactory should have thrown an exception in response to a rubbish user name.");
        }
        catch (SQLException ex) {
            Assert.assertEquals((long)ex.getErrorCode(), (long)1017L);
        }
    }

    @Test
    public void testCreateOracleJdbcConnectionBadPassword() {
        try {
            boolean logIsBeingCached = OracleConnectionFactory.LOG.getCacheLogEntries();
            OracleConnectionFactory.LOG.setCacheLogEntries(true);
            OracleConnectionFactory.createOracleJdbcConnection((String)"oracle.jdbc.OracleDriver", (String)OracleUtils.CONNECT_STRING, (String)"SQOOPTEST", (String)"a12345");
            OracleConnectionFactory.LOG.setCacheLogEntries(logIsBeingCached);
            Assert.fail((String)"OracleConnectionFactory should have thrown an exception in response to a rubbish password.");
        }
        catch (SQLException ex) {
            Assert.assertEquals((long)ex.getErrorCode(), (long)1017L);
        }
    }

    @Test
    public void testCreateOracleJdbcConnectionOk() {
        try {
            Connection conn = this.getConnection();
            Assert.assertEquals((String)"The connection to the Oracle database does not appear to be valid.", (Object)true, (Object)conn.isValid(15));
            ResultSet resultSet = conn.createStatement().executeQuery("select instance_name from v$instance");
            if (!resultSet.next() || resultSet.getString(1).isEmpty()) {
                Assert.fail((String)"Got blank instance name from v$instance");
            }
        }
        catch (SQLException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testExecuteOraOopSessionInitializationStatements() {
        OraOopLog oraoopLog = Exposer.LOG;
        oraoopLog.setCacheLogEntries(true);
        oraoopLog.clearCache();
        this.checkExecuteOraOopSessionInitializationStatements(null);
        this.checkLogContainsText((OraOopLogFactory.OraOopLog2)oraoopLog, "Initializing Oracle session with SQL : alter session disable parallel query");
        this.checkLogContainsText((OraOopLogFactory.OraOopLog2)oraoopLog, "Initializing Oracle session with SQL : alter session set \"_serial_direct_read\"=true");
        oraoopLog.clearCache();
        this.checkExecuteOraOopSessionInitializationStatements("");
        this.checkLogContainsText((OraOopLogFactory.OraOopLog2)oraoopLog, "No Oracle 'session initialization' statements were found to execute");
        this.checkExecuteOraOopSessionInitializationStatements(";");
        oraoopLog.clearCache();
        this.checkExecuteOraOopSessionInitializationStatements("loremipsum");
        this.checkLogContainsText((OraOopLogFactory.OraOopLog2)oraoopLog, "loremipsum");
        this.checkLogContainsText((OraOopLogFactory.OraOopLog2)oraoopLog, "ORA-00900: invalid SQL statement");
        Connection conn = this.getConnection();
        try {
            this.dropTable(conn, "oraoop_test");
            this.checkExecuteOraOopSessionInitializationStatements("create table oraoop_test (col1 varchar2(1))");
            if (!this.doesTableExist(conn, "oraoop_test")) {
                Assert.fail((String)"The session-initialization statement to create the table oraoop_test did not work.");
            }
            this.dropTable(conn, "oraoop_test");
            this.checkExecuteOraOopSessionInitializationStatements("create table oraoop_test (col1 number);insert into oraoop_test values (1) ; --update oraoop_test set col1 = col1 + 1; update oraoop_test set col1 = col1 + 1; commit ;;");
            ResultSet resultSet = conn.createStatement().executeQuery("select col1 from oraoop_test");
            resultSet.next();
            int actualValue = resultSet.getInt("col1");
            if (actualValue != 2) {
                Assert.fail((String)"The table oraoop_test does not contain the data we expected.");
            }
            this.dropTable(conn, "oraoop_test");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testParseOraOopSessionInitializationStatements() {
        List statements = null;
        try {
            statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements(null);
            Assert.fail((String)"An IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        Configuration conf = new Configuration();
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertTrue((statements.size() > 0 ? 1 : 0) != 0);
        conf.set("oraoop.oracle.session.initialization.statements", "");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)0L, (long)statements.size());
        conf.set("oraoop.oracle.session.initialization.statements", ";");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)0L, (long)statements.size());
        conf.set("oraoop.oracle.session.initialization.statements", ";--;\t--");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)0L, (long)statements.size());
        conf.set("oraoop.oracle.session.initialization.statements", "\ta");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)1L, (long)statements.size());
        if (!((String)statements.get(0)).equalsIgnoreCase("a")) {
            Assert.fail((String)"Expected a session initialization statement of \"a\"");
        }
        conf.set("oraoop.oracle.session.initialization.statements", "a;b;--c;d;");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)3L, (long)statements.size());
        if (!((String)statements.get(0)).equalsIgnoreCase("a")) {
            Assert.fail((String)"Expected a session initialization statement of \"a\"");
        }
        if (!((String)statements.get(1)).equalsIgnoreCase("b")) {
            Assert.fail((String)"Expected a session initialization statement of \"b\"");
        }
        if (!((String)statements.get(2)).equalsIgnoreCase("d")) {
            Assert.fail((String)"Expected a session initialization statement of \"d\"");
        }
        conf.set("oraoop.oracle.session.initialization.statements", "set a={expr1};b={expr2}/{expr3};");
        conf.set("expr1", "1");
        conf.set("expr2", "2");
        conf.set("expr3", "3");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)2L, (long)statements.size());
        String actual = (String)statements.get(0);
        String expected = "set a=1";
        if (!actual.equalsIgnoreCase(expected)) {
            Assert.fail((String)String.format("Expected a session initialization statement of \"%s\", but got \"%s\".", expected, actual));
        }
        if (!(actual = (String)statements.get(1)).equalsIgnoreCase(expected = "b=2/3")) {
            Assert.fail((String)String.format("Expected a session initialization statement of \"%s\", but got \"%s\".", expected, actual));
        }
        conf.set("oraoop.oracle.session.initialization.statements", "set c={expr3|66};d={expr4|15}/{expr5|90};");
        conf.set("expr3", "20");
        statements = OracleConnectionFactory.parseOraOopSessionInitializationStatements((Configuration)conf);
        Assert.assertEquals((long)2L, (long)statements.size());
        actual = (String)statements.get(0);
        expected = "set c=20";
        if (!actual.equalsIgnoreCase(expected)) {
            Assert.fail((String)String.format("Expected a session initialization statement of \"%s\", but got \"%s\".", expected, actual));
        }
        if (!(actual = (String)statements.get(1)).equalsIgnoreCase(expected = "d=15/90")) {
            Assert.fail((String)String.format("Expected a session initialization statement of \"%s\", but got \"%s\".", expected, actual));
        }
    }

    private void dropTable(Connection conn, String tableName) {
        block3: {
            try {
                conn.createStatement().executeQuery("drop table " + tableName);
                if (this.doesTableExist(conn, tableName)) {
                    Assert.fail((String)("Unable to drop the table " + tableName));
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 942) break block3;
                Assert.fail((String)ex.getMessage());
            }
        }
    }

    private boolean doesTableExist(Connection conn, String tableName) {
        boolean result = false;
        try {
            List tables = OraOopOracleQueries.getTables((Connection)conn);
            for (int idx = 0; idx < tables.size(); ++idx) {
                if (!((OracleTable)tables.get(idx)).getName().equalsIgnoreCase(tableName)) continue;
                result = true;
                break;
            }
        }
        catch (SQLException ex) {
            Assert.fail((String)ex.getMessage());
        }
        return result;
    }

    private void checkLogContainsText(OraOopLogFactory.OraOopLog2 oraoopLog, String text) {
        if (!oraoopLog.getLogEntries().toLowerCase().contains(text.toLowerCase())) {
            Assert.fail((String)("The LOG does not contain the following text (when it should):\n\t" + text));
        }
    }

    private void checkExecuteOraOopSessionInitializationStatements(String statements) {
        Connection conn = this.getConnection();
        Configuration conf = new Configuration();
        if (statements != null) {
            conf.set("oraoop.oracle.session.initialization.statements", statements);
        }
        Exposer.executeOraOopSessionInitializationStatements((Connection)conn, (Configuration)conf);
    }

    @Test
    public void testSetSessionClientInfo() {
        Connection conn = this.getConnection();
        Configuration conf = new Configuration();
        String moduleName = "Data Connector for Oracle and Hadoop";
        String actionName = new SimpleDateFormat("yyyyMMddHHmmsszzz").format(new Date());
        conf.set("oraoop.oracle.session.module.action", actionName);
        try {
            PreparedStatement statement = conn.prepareStatement("select process, module, action from v$session where module = ? and action = ?");
            statement.setString(1, moduleName);
            statement.setString(2, actionName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                Assert.fail((String)("There should be no Oracle sessions with an action name of " + actionName));
            }
            OracleConnectionFactory.setSessionClientInfo((Connection)conn, (Configuration)conf);
            int sessionFoundCount = 0;
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ++sessionFoundCount;
            }
            if (sessionFoundCount < 1) {
                Assert.fail((String)"Unable to locate an Oracle session with the expected module and action.");
            }
            if (sessionFoundCount > 1) {
                Assert.fail((String)"Multiple sessions were found with the expected module and action - we only expected to find one.");
            }
        }
        catch (SQLException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private Connection getConnection() {
        try {
            return OracleConnectionFactory.createOracleJdbcConnection((String)"oracle.jdbc.OracleDriver", (String)OracleUtils.CONNECT_STRING, (String)"SQOOPTEST", (String)"12345");
        }
        catch (SQLException ex) {
            Assert.fail((String)ex.getMessage());
            return null;
        }
    }

    public class Exposer
    extends OracleConnectionFactory {
    }
}

