/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop.testutil;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.HsqldbManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.ImportJobBase;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class InjectableConnManager
extends HsqldbManager {
    public static final String MAPPER_KEY = "sqoop.inject.mapper.class";
    public static final String INPUT_FORMAT_KEY = "sqoop.inject.input.format.class";
    public static final String OUTPUT_FORMAT_KEY = "sqoop.inject.output.format.class";
    public static final String IMPORT_JOB_KEY = "sqoop.inject.import.job.class";

    public InjectableConnManager(SqoopOptions options) {
        super(options);
    }

    public void importTable(ImportJobContext context) throws IOException, ImportException {
        SqoopOptions options = context.getOptions();
        Configuration conf = options.getConf();
        Class mapperClass = conf.getClass(MAPPER_KEY, Mapper.class);
        Class ifClass = conf.getClass(INPUT_FORMAT_KEY, TextInputFormat.class);
        Class ofClass = conf.getClass(OUTPUT_FORMAT_KEY, TextOutputFormat.class);
        Class jobClass = conf.getClass(IMPORT_JOB_KEY, ImportJobBase.class);
        String tableName = context.getTableName();
        ImportJobBase importJob = (ImportJobBase)ReflectionUtils.newInstance((Class)jobClass, (Configuration)conf);
        importJob.setOptions(options);
        importJob.setMapperClass(mapperClass);
        importJob.setInputFormatClass(ifClass);
        importJob.setOutputFormatClass(ofClass);
        importJob.runImport(tableName, context.getJarFile(), this.getSplitColumn(options, tableName), conf);
    }
}

