/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.orm.CompilationManager;
import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.HsqldbTestServer;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.testutil.SeqFileReader;
import com.cloudera.sqoop.tool.ImportTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.util.ReflectionUtils;

public class TestQuery
extends ImportJobTestCase {
    protected String[] getArgv(boolean includeHadoopFlags, String query, String targetDir, boolean allowParallel) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--query");
        args.add(query);
        args.add("--split-by");
        args.add("INTFIELD1");
        args.add("--connect");
        args.add(HsqldbTestServer.getUrl());
        args.add("--as-sequencefile");
        args.add("--target-dir");
        args.add(targetDir);
        args.add("--class-name");
        args.add(this.getTableName());
        if (allowParallel) {
            args.add("--num-mappers");
            args.add("2");
        } else {
            args.add("--num-mappers");
            args.add("1");
        }
        return args.toArray(new String[0]);
    }

    @Override
    protected String getTableName() {
        return HsqldbTestServer.getTableName();
    }

    private int getFirstInt(String str) {
        String[] parts = str.split(",");
        return Integer.parseInt(parts[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runQueryTest(String query, String firstValStr, int numExpectedResults, int expectedSum, String targetDir) throws IOException {
        ClassLoader prevClassLoader = null;
        SequenceFile.Reader reader = null;
        String[] argv = this.getArgv(true, query, targetDir, false);
        this.runImport(argv);
        try {
            SqoopOptions opts = new ImportTool().parseArguments(this.getArgv(false, query, targetDir, false), null, null, true);
            CompilationManager compileMgr = new CompilationManager(opts);
            String jarFileName = compileMgr.getJarFilename();
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)this.getTableName());
            reader = SeqFileReader.getSeqFileReader(this.getDataFilePath().toString());
            Configuration conf = new Configuration();
            Object key = ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Object val = ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            if (reader.next(key) == null) {
                TestQuery.fail((String)"Empty SequenceFile during import");
            }
            reader.getCurrentValue(val);
            TestQuery.assertEquals((String)"Invalid ordering within sorted SeqFile", (String)firstValStr, (String)val.toString());
            int curSum = this.getFirstInt(val.toString());
            int totalResults = 1;
            while (reader.next(key) != null) {
                reader.getCurrentValue(val);
                curSum += this.getFirstInt(val.toString());
                ++totalResults;
            }
            TestQuery.assertEquals((String)"Total sum of first db column mismatch", (int)expectedSum, (int)curSum);
            TestQuery.assertEquals((String)"Incorrect number of results for query", (int)numExpectedResults, (int)totalResults);
            IOUtils.closeStream((Closeable)reader);
            if (null == prevClassLoader) return;
        }
        catch (SqoopOptions.InvalidOptionsException ioe) {
            TestQuery.fail((String)ioe.toString());
            return;
        }
        catch (ParseException pe) {
            TestQuery.fail((String)pe.toString());
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeStream(reader);
            if (null != prevClassLoader) {
                ClassLoaderStack.setCurrentClassLoader(prevClassLoader);
            }
        }
        ClassLoaderStack.setCurrentClassLoader((ClassLoader)prevClassLoader);
        return;
    }

    public void testSelectStar() throws IOException {
        this.runQueryTest("SELECT * FROM " + this.getTableName() + " WHERE INTFIELD2 > 4 AND $CONDITIONS", "1,8\n", 2, 4, this.getTablePath().toString());
    }

    public void testCompoundWhere() throws IOException {
        this.runQueryTest("SELECT * FROM " + this.getTableName() + " WHERE INTFIELD1 > 4 AND INTFIELD2 < 3 AND $CONDITIONS", "7,2\n", 1, 7, this.getTablePath().toString());
    }

    public void testFailNoConditions() throws IOException {
        String[] argv = this.getArgv(true, "SELECT * FROM " + this.getTableName(), this.getTablePath().toString(), true);
        try {
            this.runImport(argv);
            TestQuery.fail((String)"Expected exception running import without $CONDITIONS");
        }
        catch (Exception e) {
            LOG.info((Object)("Got exception " + e + " running job (expected; ok)"));
        }
    }
}

