/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestMultiCols
extends ImportJobTestCase {
    public static final Log LOG = LogFactory.getLog((String)TestMultiCols.class.getName());

    private void verifyTypes(String[] types, String[] insertVals, String validateLine) {
        this.verifyTypes(types, insertVals, validateLine, null);
    }

    private void verifyTypes(String[] types, String[] insertVals, String validateLine, String[] importColumns) {
        this.createTableWithColTypes(types, insertVals);
        this.verifyImport(validateLine, importColumns);
        LOG.debug((Object)("Verified input line as " + validateLine + " -- ok!"));
    }

    public void testThreeStrings() {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"'foo'", "'bar'", "'baz'"};
        String validateLine = "foo,bar,baz";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testStringsWithNull1() {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"'foo'", "null", "'baz'"};
        String validateLine = "foo,null,baz";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testStringsWithNull2() {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"null", "'foo'", "'baz'"};
        String validateLine = "null,foo,baz";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testStringsWithNull3() {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"'foo'", "'baz'", "null"};
        String validateLine = "foo,baz,null";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testThreeInts() {
        String[] types = new String[]{"INTEGER", "INTEGER", "INTEGER"};
        String[] insertVals = new String[]{"1", "2", "3"};
        String validateLine = "1,2,3";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testIntsWithNulls() {
        String[] types = new String[]{"INTEGER", "INTEGER", "INTEGER"};
        String[] insertVals = new String[]{"1", "null", "3"};
        String validateLine = "1,null,3";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testMixed1() {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "DATE"};
        String[] insertVals = new String[]{"1", "'meep'", "'2009-12-31'"};
        String validateLine = "1,meep,2009-12-31";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testMixed2() {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "DATE"};
        String[] insertVals = new String[]{"null", "'meep'", "'2009-12-31'"};
        String validateLine = "null,meep,2009-12-31";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testMixed3() {
        String[] types = new String[]{"INTEGER", "VARCHAR(32)", "DATE"};
        String[] insertVals = new String[]{"1", "'meep'", "null"};
        String validateLine = "1,meep,null";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testMixed4() {
        String[] types = new String[]{"NUMERIC", "INTEGER", "NUMERIC"};
        String[] insertVals = new String[]{"-42", "17", "33333333333333333333333.1714"};
        String validateLine = "-42,17,33333333333333333333333.1714";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testMixed5() {
        String[] types = new String[]{"NUMERIC", "INTEGER", "NUMERIC"};
        String[] insertVals = new String[]{"null", "17", "33333333333333333333333.0"};
        String validateLine = "null,17,33333333333333333333333.0";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testMixed6() {
        String[] types = new String[]{"NUMERIC", "INTEGER", "NUMERIC"};
        String[] insertVals = new String[]{"33333333333333333333333", "17", "-42"};
        String validateLine = "33333333333333333333333,17,-42";
        this.verifyTypes(types, insertVals, validateLine);
    }

    public void testSkipFirstCol() {
        String[] types = new String[]{"NUMERIC", "INTEGER", "NUMERIC"};
        String[] insertVals = new String[]{"33333333333333333333333", "17", "-42"};
        String validateLine = "17,-42";
        String[] loadCols = new String[]{"DATA_COL1", "DATA_COL2"};
        this.verifyTypes(types, insertVals, validateLine, loadCols);
    }

    public void testSkipSecondCol() {
        String[] types = new String[]{"NUMERIC", "INTEGER", "NUMERIC"};
        String[] insertVals = new String[]{"33333333333333333333333", "17", "-42"};
        String validateLine = "33333333333333333333333,-42";
        String[] loadCols = new String[]{"DATA_COL0", "DATA_COL2"};
        this.verifyTypes(types, insertVals, validateLine, loadCols);
    }

    public void testSkipThirdCol() {
        String[] types = new String[]{"NUMERIC", "INTEGER", "NUMERIC"};
        String[] insertVals = new String[]{"33333333333333333333333", "17", "-42"};
        String validateLine = "33333333333333333333333,17";
        String[] loadCols = new String[]{"DATA_COL0", "DATA_COL1"};
        this.verifyTypes(types, insertVals, validateLine, loadCols);
    }

    public void testSingleColumnsArg() throws IOException {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"'foo'", "'bar'", "'baz'"};
        String validateLine = "foo,bar,baz";
        String[] loadCols = new String[]{"DATA_COL0,DATA_COL1,DATA_COL2"};
        this.verifyTypes(types, insertVals, validateLine, loadCols);
    }

    public void testColumnsWithSpaces() throws IOException {
        String[] types = new String[]{"VARCHAR(32)", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"'foo'", "'bar'", "'baz'"};
        String validateLine = "foo,bar,baz";
        String[] loadCols = new String[]{"DATA_COL0, DATA_COL1, DATA_COL2"};
        this.verifyTypes(types, insertVals, validateLine, loadCols);
    }
}

