/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqoop;

import com.cloudera.sqoop.testutil.CommonArgs;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import com.cloudera.sqoop.tool.ImportAllTablesTool;
import com.cloudera.sqoop.tool.SqoopTool;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.junit.After;
import org.junit.Before;

public class TestAllTables
extends ImportJobTestCase {
    private List<String> tableNames;
    private List<String> expectedStrings;

    private String[] getArgv(boolean includeHadoopFlags, String[] excludeTables) {
        ArrayList<String> args = new ArrayList<String>();
        if (includeHadoopFlags) {
            CommonArgs.addHadoopFlags(args);
        }
        args.add("--warehouse-dir");
        args.add(this.getWarehouseDir());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--num-mappers");
        args.add("1");
        args.add("--escaped-by");
        args.add("\\");
        if (excludeTables != null) {
            args.add("--exclude-tables");
            args.add(StringUtils.join((Object[])excludeTables, (String)","));
        }
        return args.toArray(new String[0]);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        if (this.useHsqldbTestServer()) {
            try {
                this.getTestServer().dropExistingSchema();
            }
            catch (SQLException sqlE) {
                TestAllTables.fail((String)sqlE.toString());
            }
        }
        this.tableNames = new ArrayList<String>();
        this.expectedStrings = new ArrayList<String>();
        this.expectedStrings.add("A winner");
        this.expectedStrings.add("is you!");
        this.expectedStrings.add(null);
        int i = 0;
        for (String expectedStr : this.expectedStrings) {
            String wrappedStr = null;
            if (expectedStr != null) {
                wrappedStr = "'" + expectedStr + "'";
            }
            String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)"};
            String[] vals = new String[]{Integer.toString(i++), wrappedStr};
            this.createTableWithColTypes(types, vals);
            this.tableNames.add(this.getTableName());
            this.removeTableDir();
            this.incrementTableNum();
        }
    }

    @Override
    @After
    public void tearDown() {
        try {
            for (String table : this.tableNames) {
                this.dropTableIfExists(table);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Can't clean up the database:", (Throwable)e);
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiTableImport() throws IOException {
        String[] argv = this.getArgv(true, null);
        this.runImport((SqoopTool)new ImportAllTablesTool(), argv);
        Path warehousePath = new Path(this.getWarehouseDir());
        int i = 0;
        for (String tableName : this.tableNames) {
            Path tablePath = new Path(warehousePath, tableName);
            Path filePath = new Path(tablePath, "part-m-00000");
            String expectedVal = Integer.toString(i++) + "," + this.expectedStrings.get(0);
            this.expectedStrings.remove(0);
            BufferedReader reader = null;
            if (!TestAllTables.isOnPhysicalCluster()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath.toString()))));
            } else {
                FileSystem dfs = FileSystem.get((Configuration)this.getConf());
                FSDataInputStream dis = dfs.open(filePath);
                reader = new BufferedReader(new InputStreamReader((InputStream)dis));
            }
            try {
                String line = reader.readLine();
                TestAllTables.assertEquals((String)("Table " + tableName + " expected a different string"), (String)expectedVal, (String)line);
            }
            finally {
                IOUtils.closeStream((Closeable)reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiTableImportWithExclude() throws IOException {
        String exclude = this.tableNames.get(0);
        String[] argv = this.getArgv(true, new String[]{exclude});
        this.runImport((SqoopTool)new ImportAllTablesTool(), argv);
        Path warehousePath = new Path(this.getWarehouseDir());
        int i = 0;
        for (String tableName : this.tableNames) {
            Path tablePath = new Path(warehousePath, tableName);
            Path filePath = new Path(tablePath, "part-m-00000");
            String expectedVal = Integer.toString(i++) + "," + this.expectedStrings.get(0);
            this.expectedStrings.remove(0);
            BufferedReader reader = null;
            if (!TestAllTables.isOnPhysicalCluster()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath.toString()))));
            } else {
                FSDataInputStream dis;
                block9: {
                    FileSystem dfs = FileSystem.get((Configuration)this.getConf());
                    if (tableName.equals(exclude)) {
                        try {
                            dis = dfs.open(filePath);
                            TestAllTables.assertFalse((boolean)true);
                            break block9;
                        }
                        catch (FileNotFoundException e) {
                            continue;
                        }
                    }
                    dis = dfs.open(filePath);
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)dis));
            }
            try {
                String line = reader.readLine();
                TestAllTables.assertEquals((String)("Table " + tableName + " expected a different string"), (String)expectedVal, (String)line);
            }
            finally {
                IOUtils.closeStream((Closeable)reader);
            }
        }
    }
}

