/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.testutil.ImportJobTestCase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.tool.ImportTool;
import org.apache.sqoop.validation.AbortOnFailureHandler;
import org.apache.sqoop.validation.AbsoluteValidationThreshold;
import org.apache.sqoop.validation.RowCountValidator;
import org.apache.sqoop.validation.ValidationContext;
import org.apache.sqoop.validation.ValidationException;

public class RowCountValidatorImportTest
extends ImportJobTestCase {
    @Override
    protected List<String> getExtraArgs(Configuration conf) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("--validate");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidateOptionIsEnabledInCLI() throws Exception {
        String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"1", "'Bob'", "'sales'"};
        try {
            this.createTableWithColTypes(types, insertVals);
            String[] args = this.getArgv(true, null, this.getConf());
            ArrayList argsList = new ArrayList();
            Collections.addAll(argsList, args);
            RowCountValidatorImportTest.assertTrue((String)"Validate option missing.", (boolean)argsList.contains("--validate"));
        }
        finally {
            this.dropTableIfExists(this.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationOptionsParsedCorrectly() throws Exception {
        String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"1", "'Bob'", "'sales'"};
        try {
            this.createTableWithColTypes(types, insertVals);
            String[] args = this.getArgv(true, null, this.getConf());
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("--validator");
            argsList.add("org.apache.sqoop.validation.RowCountValidator");
            argsList.add("--validation-threshold");
            argsList.add("org.apache.sqoop.validation.AbsoluteValidationThreshold");
            argsList.add("--validation-failurehandler");
            argsList.add("org.apache.sqoop.validation.AbortOnFailureHandler");
            Collections.addAll(argsList, args);
            RowCountValidatorImportTest.assertTrue((String)"Validate option missing.", (boolean)argsList.contains("--validate"));
            RowCountValidatorImportTest.assertTrue((String)"Validator option missing.", (boolean)argsList.contains("--validator"));
            String[] optionArgs = this.toStringArray(argsList);
            SqoopOptions validationOptions = new ImportTool().parseArguments(optionArgs, this.getConf(), this.getSqoopOptions(this.getConf()), true);
            RowCountValidatorImportTest.assertEquals(RowCountValidator.class, (Object)validationOptions.getValidatorClass());
            RowCountValidatorImportTest.assertEquals(AbsoluteValidationThreshold.class, (Object)validationOptions.getValidationThresholdClass());
            RowCountValidatorImportTest.assertEquals(AbortOnFailureHandler.class, (Object)validationOptions.getValidationFailureHandlerClass());
        }
        catch (Exception e) {
            RowCountValidatorImportTest.fail((String)("The validation options are passed correctly: " + e.getMessage()));
        }
        finally {
            this.dropTableIfExists(this.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidValidationOptions() throws Exception {
        String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"1", "'Bob'", "'sales'"};
        try {
            this.createTableWithColTypes(types, insertVals);
            String[] args = this.getArgv(true, null, this.getConf());
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("--validator");
            argsList.add("org.apache.sqoop.validation.NullValidator");
            argsList.add("--validation-threshold");
            argsList.add("org.apache.sqoop.validation.NullValidationThreshold");
            argsList.add("--validation-failurehandler");
            argsList.add("org.apache.sqoop.validation.NullFailureHandler");
            Collections.addAll(argsList, args);
            String[] optionArgs = this.toStringArray(argsList);
            new ImportTool().parseArguments(optionArgs, this.getConf(), this.getSqoopOptions(this.getConf()), true);
            RowCountValidatorImportTest.fail((String)"The validation options are incorrect and must throw an exception");
        }
        catch (Exception e) {
            System.out.println("e.getMessage() = " + e.getMessage());
            System.out.println("e.getClass() = " + e.getClass());
            RowCountValidatorImportTest.assertEquals(SqoopOptions.InvalidOptionsException.class, e.getClass());
        }
        finally {
            this.dropTableIfExists(this.getTableName());
        }
    }

    private String[] toStringArray(ArrayList<String> argsList) {
        String[] optionArgs = new String[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            optionArgs[i] = argsList.get(i);
        }
        return optionArgs;
    }

    public void testValidatorWithDifferentRowCounts() {
        try {
            RowCountValidator validator = new RowCountValidator();
            validator.validate(new ValidationContext(100L, 90L));
            RowCountValidatorImportTest.fail((String)"FailureHandler should have thrown an exception");
        }
        catch (ValidationException e) {
            RowCountValidatorImportTest.assertEquals((String)"Validation failed by RowCountValidator. Reason: The expected counter value was 100 but the actual value was 90, Row Count at Source: 100, Row Count at Target: 90", (String)e.getMessage());
        }
    }

    public void testValidatorWithMatchingRowCounts() {
        try {
            RowCountValidator validator = new RowCountValidator();
            validator.validate(new ValidationContext(100L, 100L));
        }
        catch (ValidationException e) {
            RowCountValidatorImportTest.fail((String)"FailureHandler should NOT have thrown an exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidatorForImportTable() throws Exception {
        String[] types = new String[]{"INT NOT NULL PRIMARY KEY", "VARCHAR(32)", "VARCHAR(32)"};
        String[] insertVals = new String[]{"1", "'Bob'", "'sales'"};
        String validateLine = "1,Bob,sales";
        try {
            this.createTableWithColTypes(types, insertVals);
            this.verifyImport(validateLine, null);
            LOG.debug((Object)("Verified input line as " + validateLine + " -- ok!"));
        }
        finally {
            this.dropTableIfExists(this.getTableName());
        }
    }
}

