/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.sqlserver;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.tool.CodeGenTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.manager.sqlserver.MSSQLTestDataFileParser;
import org.apache.sqoop.manager.sqlserver.MSSQLTestUtils;
import org.apache.sqoop.manager.sqlserver.ManagerCompatExport;

public class SQLServerDatatypeExportSequenceFileManualTest
extends ManagerCompatExport {
    private static Map jars = new HashMap();

    @Override
    public void createFile(MSSQLTestDataFileParser.DATATYPES dt, String[] data) throws Exception {
        try {
            this.codeGen(dt);
            Class<?> cls = Class.forName(this.getTableName(dt), true, Thread.currentThread().getContextClassLoader());
            SqoopRecord record = (SqoopRecord)ReflectionUtils.newInstance(cls, (Configuration)new Configuration());
            Configuration conf = new Configuration();
            String hdfsroot = System.getProperty("ms.datatype.test.hdfsprefix");
            if (hdfsroot == null) {
                hdfsroot = "hdfs://localhost/";
            }
            conf.set("fs.default.name", hdfsroot);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tablePath = this.getTablePath(dt);
            Path filePath = new Path(tablePath, this.getTableName(dt));
            fs.mkdirs(tablePath);
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)filePath, LongWritable.class, cls);
            int cnt = 0;
            for (String tmp : data) {
                record.parse((CharSequence)(tmp + "\n"));
                w.append((Writable)new LongWritable((long)cnt), (Writable)record);
            }
            w.close();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        catch (RecordParser.ParseError pe) {
            throw new IOException(pe);
        }
    }

    @Override
    public void createFile(MSSQLTestDataFileParser.DATATYPES dt, String data) throws Exception {
        this.createFile(dt, new String[]{data});
    }

    public String[] codeGen(MSSQLTestDataFileParser.DATATYPES dt) throws Exception {
        CodeGenTool codeGen = new CodeGenTool();
        String[] codeGenArgs = this.getCodeGenArgv(dt);
        SqoopOptions options = codeGen.parseArguments(codeGenArgs, null, null, true);
        String username = MSSQLTestUtils.getDBUserName();
        String password = MSSQLTestUtils.getDBPassWord();
        options.setUsername(username);
        options.setPassword(password);
        codeGen.validateOptions(options);
        int ret = codeGen.run(options);
        SQLServerDatatypeExportSequenceFileManualTest.assertEquals((int)0, (int)ret);
        List generatedJars = codeGen.getGeneratedJarFiles();
        SQLServerDatatypeExportSequenceFileManualTest.assertNotNull((Object)generatedJars);
        SQLServerDatatypeExportSequenceFileManualTest.assertEquals((String)"Expected 1 generated jar file", (int)1, (int)generatedJars.size());
        String jarFileName = (String)generatedJars.get(0);
        Path jarPath = new Path(jarFileName);
        String jarBaseName = jarPath.getName();
        SQLServerDatatypeExportSequenceFileManualTest.assertTrue((boolean)jarBaseName.endsWith(".jar"));
        SQLServerDatatypeExportSequenceFileManualTest.assertTrue((jarBaseName.length() > ".jar".length() ? 1 : 0) != 0);
        String className = jarBaseName.substring(0, jarBaseName.length() - ".jar".length());
        LOG.info((Object)("Using jar filename: " + jarFileName));
        LOG.info((Object)("Using class name: " + className));
        ClassLoader prevClassLoader = null;
        if (null != jarFileName) {
            prevClassLoader = ClassLoaderStack.addJarFile((String)jarFileName, (String)className);
            System.out.println("Jar,class =" + jarFileName + " , " + className);
        }
        LOG.info((Object)"Exporting SequenceFile-based data");
        jars.put(dt, jarFileName);
        return this.getArgv(dt, "--class-name", className, "--jar-file", jarFileName);
    }

    @Override
    protected String[] getArgv(MSSQLTestDataFileParser.DATATYPES dt) {
        String[] args = super.getArgv(dt);
        String[] addtionalArgs = Arrays.copyOf(args, args.length + 4);
        String[] additional = new String[]{"--class-name", this.getTableName(dt), "--jar-file", jars.get((Object)dt).toString()};
        int i = args.length;
        int j = 0;
        while (i < addtionalArgs.length) {
            addtionalArgs[i] = additional[j];
            ++i;
            ++j;
        }
        for (String a : addtionalArgs) {
            System.out.println(a);
        }
        return addtionalArgs;
    }

    protected String[] getCodeGenArgv(MSSQLTestDataFileParser.DATATYPES dt) {
        ArrayList<String> codeGenArgv = new ArrayList<String>();
        codeGenArgv.add("--table");
        codeGenArgv.add(this.getTableName(dt));
        codeGenArgv.add("--connect");
        codeGenArgv.add(this.getConnectString());
        codeGenArgv.add("--fields-terminated-by");
        codeGenArgv.add("\\t");
        codeGenArgv.add("--lines-terminated-by");
        codeGenArgv.add("\\n");
        return codeGenArgv.toArray(new String[0]);
    }

    protected String[] getArgv(MSSQLTestDataFileParser.DATATYPES dt, String ... additionalArgv) {
        boolean prevIsFlag;
        ArrayList<String> args = new ArrayList<String>();
        if (null != additionalArgv) {
            prevIsFlag = false;
            for (String arg : additionalArgv) {
                if (arg.equals("-D")) {
                    args.add(arg);
                    prevIsFlag = true;
                    continue;
                }
                if (!prevIsFlag) continue;
                args.add(arg);
                prevIsFlag = false;
            }
        }
        if (null != additionalArgv) {
            prevIsFlag = false;
            for (String arg : additionalArgv) {
                if (arg.equals("-D")) {
                    prevIsFlag = true;
                    continue;
                }
                if (prevIsFlag) {
                    prevIsFlag = false;
                    continue;
                }
                args.add(arg);
            }
        }
        args.add("--table");
        args.add(this.getTableName(dt));
        args.add("--export-dir");
        args.add(this.getTablePath(dt).toString());
        args.add("--connect");
        args.add(this.getConnectString());
        args.add("--fields-terminated-by");
        args.add("\\t");
        args.add("--lines-terminated-by");
        args.add("\\n");
        args.add("-m");
        args.add("1");
        LOG.debug((Object)"args:");
        for (String a : args) {
            LOG.debug((Object)("  " + a));
        }
        return args.toArray(new String[0]);
    }

    @Override
    public String getOutputFileName() {
        return "ManagerCompatExportSeq.txt";
    }
}

